/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.TabbedPaneTheme;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.pane.BTabbedPane;

public class PalladiumTabbedPaneTheme
extends PalladiumWidgetTheme
implements TabbedPaneTheme {
    private static double thetaTop = 0.0;
    private static double thetaLeft = 4.71238898038469;
    private static double thetaRight = 1.5707963267948966;
    private static double thetaBottom = Math.PI;
    private static BInsets contentInsetsFull = BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0);
    private static BInsets tabInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
    private static BInsets contentInsetsTop = BInsets.make((double)8.0, (double)0.0, (double)0.0, (double)0.0);
    private static BInsets contentInsetsLeft = BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)8.0);
    private static BInsets contentInsetsRight = BInsets.make((double)0.0, (double)8.0, (double)0.0, (double)0.0);
    private static BInsets contentInsetsBottom = BInsets.make((double)0.0, (double)0.0, (double)8.0, (double)0.0);

    @Override
    public BInsets getTabInsets(BAlign tabPlacement) {
        return tabInsets;
    }

    @Override
    public BInsets getContentInsets(BAlign tabPlacement, boolean fullBorder) {
        if (fullBorder) {
            return contentInsetsFull;
        }
        switch (tabPlacement.getOrdinal()) {
            case 0: {
                return contentInsetsTop;
            }
            case 1: {
                return contentInsetsLeft;
            }
            case 3: {
                return contentInsetsRight;
            }
            case 2: {
                return contentInsetsBottom;
            }
        }
        return null;
    }

    @Override
    public void paintContentBackground(Graphics g, BTabbedPane p, BAlign tabPlacement, BWidget content, boolean fullBorder) {
        BInsets ci = this.getContentInsets(tabPlacement, fullBorder);
        double cx = content.getX() - ci.left;
        double cy = content.getY() - ci.top;
        double cw = content.getWidth() + ci.left + ci.right;
        double ch = content.getHeight() + ci.top + ci.bottom;
        if (fullBorder) {
            g.setBrush(this.getControlForeground());
            g.strokeRect(cx, cy, cw - 1.0, ch - 1.0);
            g.setBrush(this.getControlHighlight());
            g.strokeLine(cx + 1.0, cy + 1.0, cx + cw - 3.0, cy + 1.0);
            g.strokeLine(cx + 1.0, cy + 1.0, cx + 1.0, cy + ch - 3.0);
            g.setBrush(this.getControlShadow());
            g.strokeLine(cx + cw - 2.0, cy + 1.0, cx + cw - 2.0, cy + ch - 2.0);
            g.strokeLine(cx + cw - 2.0, cy + ch - 2.0, cx + 1.0, cy + ch - 2.0);
        } else {
            switch (tabPlacement.getOrdinal()) {
                case 0: {
                    g.setBrush(this.getControlForeground());
                    g.strokeLine(cx, cy, cx + cw, cy);
                    g.setBrush(this.getControlHighlight());
                    g.strokeLine(cx, cy + 1.0, cx + cw, cy + 1.0);
                    break;
                }
                case 2: {
                    g.setBrush(this.getControlForeground());
                    g.strokeLine(cx, cy + ch - 1.0, cx + cw, cy + ch - 1.0);
                    g.setBrush(this.getControlShadow());
                    g.strokeLine(cx, cy + ch - 2.0, cx + cw, cy + ch - 2.0);
                    break;
                }
                case 1: {
                    g.setBrush(this.getControlForeground());
                    g.strokeLine(cx, cy, cx, cy + ch - 1.0);
                    g.setBrush(this.getControlHighlight());
                    g.strokeLine(cx + 1.0, cy, cx + 1.0, cy + ch - 1.0);
                    break;
                }
                case 3: {
                    g.setBrush(this.getControlForeground());
                    g.strokeLine(cx + cw - 1.0, cy, cx + cw - 1.0, cy + ch - 1.0);
                    g.setBrush(this.getControlShadow());
                    g.strokeLine(cx + cw - 2.0, cy, cx + cw - 2.0, cy + ch - 1.0);
                }
            }
        }
    }

    @Override
    public void paintTabBackground(Graphics g, BTabbedPane p, BAlign tabPlacement, BLabel label, boolean isSelected, BWidget c, boolean fullBorder) {
        BInsets ti = this.getTabInsets(tabPlacement);
        BInsets ci = this.getContentInsets(tabPlacement, fullBorder);
        double tx = label.getX() - ti.left;
        double ty = label.getY() - ti.top;
        double tw = label.getWidth() + ti.left + ti.right;
        double th = label.getHeight() + ti.top + ti.bottom;
        double maxw = tw;
        double maxh = th;
        if (tx + tw >= p.getWidth()) {
            tw = p.getWidth() - tx - 1.0;
        }
        if (ty + th >= p.getHeight()) {
            th = p.getHeight() - ty - 1.0;
        }
        switch (tabPlacement.getOrdinal()) {
            case 0: {
                maxh = c.getY() - ci.top;
                break;
            }
            case 2: {
                maxh = c.getY() + c.getHeight() + ci.bottom;
                break;
            }
            case 1: {
                maxw = c.getX() - ci.left;
                break;
            }
            case 3: {
                maxw = c.getX() + c.getWidth() + ci.right;
            }
        }
        this.paintTabBackground(g, p, label, tabPlacement, tx, ty, tw, th, maxw, maxh, isSelected);
    }

    protected void paintTabBackground(Graphics g, BTabbedPane p, BLabel label, BAlign tabPlacement, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        if (tw <= 0.0 || th <= 0.0) {
            return;
        }
        switch (tabPlacement.getOrdinal()) {
            case 0: {
                this.paintTabTop(g, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            case 1: {
                this.paintTabLeft(g, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            case 3: {
                this.paintTabRight(g, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            case 2: {
                this.paintTabBottom(g, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            default: {
                return;
            }
        }
        if (p.hasFocus() && isSelected) {
            this.paintFocus(g, new RectGeom(label.getX() - 1.0, label.getY() - 1.0, label.getWidth() + 1.0, label.getHeight() + 1.0));
        }
    }

    protected void paintTabTop(Graphics g, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = isSelected ? this.getControlHighlight() : this.getControlBackground();
        double[] x = new double[]{tx, tx, tx + 7.0, tx + tw, tx + tw};
        double[] y = new double[]{maxh, ty + 7.0, ty, ty, maxh};
        int numPoints = 5;
        PolygonGeom poly = new PolygonGeom(x, y, numPoints);
        if (isSelected) {
            g.setBrush(this.getControlBackground());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.fill((IGeom)poly);
        g.setBrush(this.getControlForeground());
        g.strokeLine(x[0], y[0], x[1], y[1]);
        g.strokeLine(x[1], y[1], x[2], y[2]);
        g.strokeLine(x[2], y[2], x[3], y[3]);
        g.strokeLine(x[3], y[3], x[4], y[4]);
        g.setBrush(highlight);
        g.strokeLine(x[0] + 1.0, y[0] - 1.0, x[1] + 1.0, y[1]);
        g.strokeLine(x[1] + 1.0, y[1], x[2], y[2] + 1.0);
        g.strokeLine(x[2], y[2] + 1.0, x[3] - 1.0, y[3] + 1.0);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x[3] - 1.0, y[3] + 1.0, x[4] - 1.0, y[4] - 1.0);
        if (isSelected && maxh - ty <= th) {
            g.setBrush(this.getControlBackground());
            g.strokeLine(x[0] + 2.0, y[0], x[4] - 1.0, y[4]);
            g.strokeLine(x[0] + 2.0, y[0] + 1.0, x[4] - 1.0, y[4] + 1.0);
            g.setBrush(this.getControlHighlight());
            g.strokeLine(x[0] + 1.0, y[0], x[0] + 1.0, y[0] + 1.0);
            g.setBrush(this.getControlShadow());
            g.strokeLine(x[4] - 1.0, y[4], x[4] - 1.0, y[4] + 1.0);
        }
    }

    protected void paintTabLeft(Graphics g, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = isSelected ? this.getControlHighlight() : this.getControlBackground();
        double[] x = new double[]{maxw, tx + 7.0, tx, tx, maxw};
        double[] y = new double[]{ty + th, ty + th, ty + th - 7.0, ty, ty};
        int numPoints = 5;
        PolygonGeom poly = new PolygonGeom(x, y, numPoints);
        if (isSelected) {
            g.setBrush(this.getControlBackground());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.fill((IGeom)poly);
        g.setBrush(this.getControlForeground());
        g.strokeLine(x[0], y[0], x[1], y[1]);
        g.strokeLine(x[1], y[1], x[2], y[2]);
        g.strokeLine(x[2], y[2], x[3], y[3]);
        g.strokeLine(x[3], y[3], x[4], y[4]);
        g.setBrush(highlight);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x[0] - 1.0, y[0] - 1.0, x[1], y[1] - 1.0);
        g.setBrush(highlight);
        g.strokeLine(x[2] + 1.0, y[2], x[3] + 1.0, y[3] + 1.0);
        g.strokeLine(x[3] + 1.0, y[3] + 1.0, x[4] - 1.0, y[4] + 1.0);
        if (isSelected && maxw - tx <= tw) {
            g.setBrush(this.getControlBackground());
            g.strokeLine(x[0], y[0] - 1.0, x[4], y[4] + 2.0);
            g.strokeLine(x[0] + 1.0, y[0] - 1.0, x[4] + 1.0, y[4] + 2.0);
            g.setBrush(this.getControlHighlight());
            g.strokeLine(x[4], y[4] + 1.0, x[4] + 1.0, y[4] + 1.0);
            g.setBrush(this.getControlShadow());
            g.strokeLine(x[0], y[0] - 1.0, x[0] + 1.0, y[0] - 1.0);
        }
    }

    protected void paintTabRight(Graphics g, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = isSelected ? this.getControlHighlight() : this.getControlBackground();
        double[] x = new double[]{maxw, tx + tw - 7.0, tx + tw, tx + tw, maxw};
        double[] y = new double[]{ty + th, ty + th, ty + th - 7.0, ty, ty};
        int numPoints = 5;
        PolygonGeom poly = new PolygonGeom(x, y, numPoints);
        if (isSelected) {
            g.setBrush(this.getControlBackground());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.fill((IGeom)poly);
        g.setBrush(this.getControlForeground());
        g.strokeLine(x[0], y[0], x[1], y[1]);
        g.strokeLine(x[1], y[1], x[2], y[2]);
        g.strokeLine(x[2], y[2], x[3], y[3]);
        g.strokeLine(x[3], y[3], x[4], y[4]);
        g.setBrush(highlight);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x[0], y[0] - 1.0, x[1] - 1.0, y[1] - 1.0);
        g.strokeLine(x[1], y[1] - 1.0, x[2] - 1.0, y[2]);
        g.strokeLine(x[2] - 1.0, y[2] - 1.0, x[3] - 1.0, y[3] + 1.0);
        g.setBrush(highlight);
        g.strokeLine(x[3] - 2.0, y[3] + 1.0, x[4], y[4] + 1.0);
        if (isSelected && tx <= maxw) {
            g.setBrush(this.getControlBackground());
            g.strokeLine(x[0] - 1.0, y[0] - 2.0, x[4] - 1.0, y[4] + 1.0);
            g.strokeLine(x[0] - 2.0, y[0] - 2.0, x[4] - 2.0, y[4] + 1.0);
            g.setBrush(this.getControlShadow());
            g.strokeLine(x[0], y[0] - 1.0, x[0] - 1.0, y[0] - 1.0);
            g.setBrush(this.getControlHighlight());
            g.strokeLine(x[4], y[4] + 1.0, x[4] - 2.0, y[4] + 1.0);
        }
    }

    protected void paintTabBottom(Graphics g, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = isSelected ? this.getControlHighlight() : this.getControlBackground();
        double[] x = new double[]{tx, tx, tx + 7.0, tx + tw, tx + tw};
        double[] y = new double[]{maxh, ty + th - 7.0, ty + th, ty + th, maxh};
        int numPoints = 5;
        PolygonGeom poly = new PolygonGeom(x, y, numPoints);
        if (isSelected) {
            g.setBrush(this.getControlBackground());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.fill((IGeom)poly);
        g.setBrush(this.getControlForeground());
        g.strokeLine(x[0], y[0], x[1], y[1]);
        g.strokeLine(x[1], y[1], x[2], y[2]);
        g.strokeLine(x[2], y[2], x[3], y[3]);
        g.strokeLine(x[3], y[3], x[4], y[4]);
        g.setBrush(highlight);
        g.strokeLine(x[0] + 1.0, y[0], x[1] + 1.0, y[1]);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x[2], y[2] - 1.0, x[3] - 1.0, y[3] - 1.0);
        g.strokeLine(x[3] - 1.0, y[3] - 1.0, x[4] - 1.0, y[4]);
        if (isSelected && ty <= maxh) {
            g.setBrush(this.getControlBackground());
            g.strokeLine(x[0] + 2.0, y[0] - 1.0, x[4] - 1.0, y[4] - 1.0);
            g.strokeLine(x[0] + 2.0, y[0] - 2.0, x[4] - 1.0, y[4] - 2.0);
            g.setBrush(this.getControlHighlight());
            g.strokeLine(x[0] + 1.0, y[0], x[0] + 1.0, y[0] - 2.0);
            g.setBrush(this.getControlShadow());
            g.strokeLine(x[4] - 1.0, y[4], x[4] - 1.0, y[4] - 2.0);
        }
    }
}

