/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.SeparatorTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.Graphics;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.enums.BOrientation;

public class CustomSeparatorTheme
extends CustomWidgetTheme
implements SeparatorTheme {
    private double menuFixedWidth;
    private double toolbarFixedWidth;
    private double defaultFixedWidth;

    public CustomSeparatorTheme() {
        NSS nss = CustomSeparatorTheme.getNSS();
        NSS separator = nss.selectNode("separator");
        this.regFallbackValue(separator, "menuFixedWidth", "width-menu", "8");
        this.regFallbackValue(separator, "toolbarFixedWidth", "width-toolbar", "8");
        this.regFallbackValue(separator, "defaultFixedWidth", "width", "2");
    }

    @Override
    String getNSSSelector() {
        return "separator";
    }

    public double getMenuFixedWidth() {
        return this.menuFixedWidth;
    }

    public void setMenuFixedWidth(double mfw) {
        this.menuFixedWidth = mfw;
    }

    public double getToolbarFixedWidth() {
        return this.toolbarFixedWidth;
    }

    public void setToolbarFixedWidth(double tfw) {
        this.toolbarFixedWidth = tfw;
    }

    public double getDefaultFixedWidth() {
        return this.defaultFixedWidth;
    }

    public void setDefaultFixedWidth(double dfw) {
        this.defaultFixedWidth = dfw;
    }

    @Override
    public double getFixedWidth(BSeparator sep) {
        if (sep.getParent() instanceof BMenu) {
            return this.menuFixedWidth;
        }
        if (sep.getParent() instanceof BToolBar) {
            return this.toolbarFixedWidth;
        }
        return this.defaultFixedWidth;
    }

    @Override
    public void paintSeparator(Graphics g, BSeparator sep) {
        double w = sep.getWidth();
        double h = sep.getHeight();
        double x = w / 2.0 - 1.0;
        double y = h / 2.0 - 1.0;
        if (sep.getOrientation() == BOrientation.horizontal) {
            g.setBrush(this.getControlShadow(sep));
            g.strokeLine(0.0, y, w, y);
            g.setBrush(this.getControlHighlight(sep));
            g.strokeLine(0.0, y + 1.0, w, y + 1.0);
        } else {
            g.setBrush(this.getControlShadow(sep));
            g.strokeLine(x, 0.0, x, h);
            g.setBrush(this.getControlHighlight(sep));
            g.strokeLine(x + 1.0, 0.0, x + 1.0, h);
        }
    }
}

