/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.style.IStylable;

public class CustomMenuItemTheme
extends CustomWidgetTheme
implements MenuItemTheme {
    private BInsets insets;
    private BFont acceleratorFont;
    private BBrush acceleratorBrush;
    private double iconIndent;

    public CustomMenuItemTheme() {
        NSS nss = CustomMenuItemTheme.getNSS();
        NSS menuItem = nss.selectNode("menu-item");
        this.regFallbackValue(menuItem, "insets", "padding", "2 14 2 22");
        this.regFallbackValue(menuItem, "iconIndent", "icon-indent", "2");
        this.regFallbackSelector(nss, "acceleratorBrush", "menu-item accelerator color", "selection-background-color");
        BFont acceleratorFont = (BFont)menuItem.selectProperty("accelerator font");
        if (acceleratorFont == null) {
            BFont font = this.getTextFont();
            acceleratorFont = BFont.make((String)font.getName(), (double)(font.getSize() - 1.0), (int)font.getStyle());
        }
        this.setAcceleratorFont(acceleratorFont);
    }

    @Override
    String getNSSSelector() {
        return "menu-item";
    }

    @Override
    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets i) {
        this.insets = i;
    }

    @Override
    public double getIconIndent() {
        return this.iconIndent;
    }

    public void setIconIndent(double iconIndent) {
        this.iconIndent = iconIndent;
    }

    @Override
    public BFont getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public void setAcceleratorFont(BFont af) {
        this.acceleratorFont = af;
    }

    @Override
    public BBrush getAcceleratorBrush() {
        return this.acceleratorBrush;
    }

    @Override
    public BBrush getAcceleratorBrush(IStylable widget) {
        return (BBrush)this.select(widget, "menu-item accelerator color");
    }

    public void setAcceleratorBrush(BBrush ab) {
        this.acceleratorBrush = ab;
    }

    @Override
    public void paintDisabledText(Graphics g, IStylable widget, String s, double x, double y) {
        g.setBrush(this.getControlHighlight(widget));
        g.drawString(s, x + 1.0, y + 1.0);
        g.setBrush(this.getControlShadow(widget));
        g.drawString(s, x, y);
    }

    @Override
    public void paintBackground(Graphics g, BMenuItem m, boolean selected) {
        if (selected) {
            g.setBrush(this.getSelectionBackground(m));
        } else {
            g.setBrush(this.getControlBackground(m));
        }
        g.fillRect(0.0, 0.0, m.getWidth(), m.getHeight());
    }

    @Override
    public void paintSubMenuArrow(Graphics g, BMenuItem m, boolean selected) {
        double w = m.getWidth();
        double h = m.getHeight();
        double mid = h / 2.0;
        double x = w - 4.0;
        if (m.getEnabled()) {
            if (selected) {
                g.setBrush(this.getSelectionForeground(m));
            } else {
                g.setBrush(this.getTextBrush(m));
            }
        } else {
            g.setBrush(this.getTextDisabled(m));
        }
        g.strokeLine(x, mid - 0.0, x, mid + 0.0);
        g.strokeLine(x -= 1.0, mid - 1.0, x, mid + 1.0);
        g.strokeLine(x -= 1.0, mid - 2.0, x, mid + 2.0);
        g.strokeLine(x -= 1.0, mid - 3.0, x, mid + 3.0);
        g.strokeLine(x -= 1.0, mid - 4.0, x, mid + 4.0);
        x -= 1.0;
    }

    @Override
    public void paintCheckBox(Graphics g, BCheckBoxMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double h = m.getHeight();
            double x = this.insets.left / 2.0 - 4.0;
            double y = h / 2.0 + 2.0;
            if (m.getEnabled()) {
                g.setBrush(selected ? this.getSelectionForeground(m) : this.getControlForeground(m));
            } else {
                g.setBrush(this.getTextDisabled(m));
            }
            g.strokeLine(x, y, x + 1.0, y - 1.0);
            g.strokeLine(x + 1.0, y + 1.0, x + 6.0, y - 4.0);
            g.strokeLine(x + 2.0, y + 2.0, x + 7.0, y - 3.0);
            g.strokeLine(x + 1.0, y, x + 2.0, y + 1.0);
            g.strokeLine(x + 2.0, y + 1.0, x + 6.0, y - 3.0);
        }
    }

    @Override
    public void paintRadioBox(Graphics g, BRadioButtonMenuItem m, boolean selected) {
        if (m.getSelected()) {
            double w = 4.0;
            double h = 4.0;
            double x = this.insets.left / 2.0 - w / 2.0;
            double y = m.getHeight() / 2.0 - h / 2.0 + 1.0;
            if (m.getEnabled()) {
                g.setBrush(selected ? this.getSelectionForeground(m) : this.getControlForeground(m));
            } else {
                g.setBrush(this.getTextDisabled(m));
            }
            g.strokeLine(x, y + h / 2.0, x + w / 2.0, y);
            g.strokeLine(x + 1.0, y + h / 2.0 + 1.0, x + w / 2.0 + 1.0, y + 1.0);
            g.strokeLine(x + 2.0, y + h / 2.0 + 2.0, x + w / 2.0 + 2.0, y + 2.0);
            g.strokeLine(x + 1.0, y + h / 2.0, x + w / 2.0, y + 1.0);
            g.strokeLine(x + 2.0, y + h / 2.0 + 1.0, x + w / 2.0 + 1.0, y + 2.0);
        }
    }
}

