/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.px;

import com.tridium.ui.px.Target;
import com.tridium.ui.px.TargetArray;
import javax.baja.sys.BComponent;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxProperty;

public class PxPropertyComponent {
    private BComponent comp;
    private final TargetArray targets;

    public PxPropertyComponent(BComponent comp) {
        this.comp = comp;
        this.targets = new TargetArray();
    }

    public void addTarget(PxProperty group, String propName) {
        this.targets.add(group, propName);
    }

    public void removeTarget(PxProperty group, String propName) {
        this.targets.remove(group, propName);
    }

    public boolean hasTargets() {
        return this.targets.size() > 0;
    }

    public void cloneTargets(PxPropertyComponent oldC) {
        TargetArray oldT = oldC.getTargets();
        for (int j = 0; j < oldT.size(); ++j) {
            Target z = oldT.get(j);
            this.targets.add(z.getPxProperty(), z.getPropertyName());
        }
    }

    public BComponent getComponent() {
        return this.comp;
    }

    public BWidget getWidget() {
        if (this.comp instanceof BWidget) {
            return (BWidget)this.comp;
        }
        if (!(this.comp instanceof BBinding)) {
            throw new IllegalStateException();
        }
        return (BWidget)this.comp.getParent();
    }

    public TargetArray getTargets() {
        return this.targets;
    }

    public String toString() {
        return "PxPropertyComponent:" + this.comp.getClass().getName() + ":" + this.targets;
    }

    void setComponent(BComponent comp) {
        this.comp = comp;
    }
}

