/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx.toolbar;

import com.tridium.ui.fx.BFxWidget;
import com.tridium.ui.fx.FxUtil;
import com.tridium.ui.fx.toolbar.FxToolbarButtonBuilder;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.MenuButton;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.toolbar.BIToolBar;

@NiagaraType
public final class BFxToolBar
extends BFxWidget
implements BIToolBar {
    @Generated
    public static final Type TYPE = Sys.loadType(BFxToolBar.class);
    private final ToolBar fxToolBar = new ToolBar();
    private final Map<BAbstractButton, Node> buttonsToFxButtons = Collections.synchronizedMap(new HashMap());
    private final HBox fxMergedToolBarGroup = new HBox();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Parent createNode() {
        return this.fxToolBar;
    }

    @Override
    protected void fxInitialized() {
        if (FxUtil.toolbarFixRequired()) {
            this.getJfxPanel().addFocusListener((FocusListener)new FocusAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusLost(FocusEvent e) {
                    ToolBar toolBar = BFxToolBar.this.fxToolBar;
                    synchronized (toolBar) {
                        BFxToolBar.this.fxToolBar.getItems().forEach(node -> {
                            if (node instanceof MenuButton) {
                                MenuButton mb = (MenuButton)node;
                                mb.setUserData((Object)false);
                            }
                        });
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String id) {
        ToolBar toolBar = this.fxToolBar;
        synchronized (toolBar) {
            this.fxToolBar.setId(id);
        }
    }

    @Override
    public BAbstractButton removeButton(String buttonName) {
        BAbstractButton btnToRemove = (BAbstractButton)this.get(buttonName);
        this.remove(buttonName);
        return btnToRemove;
    }

    @Override
    public void removeAllButtons() {
        this.removeAll();
    }

    @Override
    public void addSeparator() {
        this.add("sep?", (BValue)new BSeparator());
    }

    @Override
    @Deprecated
    public BAbstractButton add(String name, Command cmd) {
        BAbstractButton button = BAbstractButton.make(cmd, false, true);
        button.setFocusTraversable(true);
        this.add(name, (BValue)button);
        return button;
    }

    @Override
    public BAbstractButton addButton(String buttonName, Command command) {
        return this.add(buttonName, command);
    }

    @Override
    public BAbstractButton getButton(String buttonName) {
        return (BAbstractButton)this.get(buttonName);
    }

    @Override
    public void removeConsecutiveSeparators() {
    }

    @Override
    public BWidget asWidget() {
        return this;
    }

    public final void added(Property property, Context context) {
        BValue value = this.get(property);
        BFxToolBar.postfx(() -> {
            if (value instanceof BAbstractButton) {
                this.buttonAdded((BAbstractButton)value, false);
            } else if (value instanceof BIToolBar) {
                this.mergedToolBarAdded((BIToolBar)value);
            }
        });
    }

    public final void removed(Property property, BValue oldValue, Context context) {
        BFxToolBar.postfx(() -> {
            if (oldValue instanceof BAbstractButton) {
                this.buttonRemoved((BAbstractButton)oldValue, false);
            } else if (oldValue instanceof BIToolBar) {
                this.mergedToolBarRemoved((BIToolBar)oldValue);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buttonAdded(BAbstractButton button, boolean mergedButton) {
        if (button == null) {
            return;
        }
        FxToolbarButtonBuilder fxButton = FxToolbarButtonBuilder.makeFor(button);
        this.buttonsToFxButtons.put(button, fxButton.toNode());
        if (mergedButton) {
            this.fxMergedToolBarGroup.getChildren().addAll((Object[])new Node[]{fxButton.toNode()});
        } else {
            ToolBar toolBar = this.fxToolBar;
            synchronized (toolBar) {
                this.fxToolBar.getItems().add((Object)fxButton.toNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buttonRemoved(BAbstractButton button, boolean mergedButton) {
        BMenu menu;
        if (button == null) {
            return;
        }
        Node node = this.buttonsToFxButtons.remove(button);
        if (node != null) {
            if (mergedButton) {
                this.fxMergedToolBarGroup.getChildren().removeAll((Object[])new Node[]{node});
            } else {
                ToolBar toolBar = this.fxToolBar;
                synchronized (toolBar) {
                    this.fxToolBar.getItems().removeAll((Object[])new Node[]{node});
                }
            }
            node.setOnMouseReleased(null);
        }
        for (ToolBar subscriber : button.getSubscribers()) {
            subscriber.unsubscribe((BComponent)button);
        }
        BAbstractButton.MenuController mc = button.getMenuController();
        if (mc != null && (menu = mc.getMenu(button)) != null) {
            for (BIMenuItem bIMenuItem : menu.getMenuItems()) {
                for (Subscriber subscriber : bIMenuItem.asWidget().getSubscribers()) {
                    subscriber.unsubscribe((BComponent)bIMenuItem.asWidget());
                }
            }
            for (BIMenuItem bIMenuItem : menu.asWidget().getSubscribers()) {
                bIMenuItem.unsubscribe(menu.asWidget());
            }
        }
    }

    private void mergedToolBarAdded(BIToolBar toolBar) {
        if (toolBar == null) {
            return;
        }
        BWidget widget = toolBar.asWidget();
        Arrays.stream(widget.getPropertiesArray()).map(arg_0 -> ((BWidget)widget).get(arg_0)).filter(Objects::nonNull).filter(v -> v instanceof BAbstractButton).forEach(v -> this.buttonAdded((BAbstractButton)v, false));
        Subscriber sub = new Subscriber(){

            public void event(BComponentEvent event) {
                BValue value = event.getValue();
                if (value instanceof BAbstractButton) {
                    BAbstractButton button = (BAbstractButton)value;
                    switch (event.getId()) {
                        case 1: {
                            BFxWidget.postfx(() -> BFxToolBar.this.buttonAdded(button, false));
                            break;
                        }
                        case 2: {
                            BFxWidget.postfx(() -> BFxToolBar.this.buttonRemoved(button, false));
                        }
                    }
                }
            }
        };
        sub.subscribe((BComponent)widget);
    }

    private void mergedToolBarRemoved(BIToolBar toolBar) {
        if (toolBar == null) {
            return;
        }
        BWidget widget = toolBar.asWidget();
        Arrays.stream(widget.getPropertiesArray()).map(arg_0 -> ((BWidget)widget).get(arg_0)).filter(Objects::nonNull).filter(v -> v instanceof BAbstractButton).forEach(v -> this.buttonRemoved((BAbstractButton)v, false));
        for (Subscriber subscriber : toolBar.asWidget().getSubscribers()) {
            subscriber.unsubscribeAll();
        }
    }
}

