/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx.menu;

import com.tridium.ui.fx.FxUtil;
import com.tridium.ui.fx.menu.FxMenuItemFactory;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleGroup;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.menu.BISubMenuItem;
import javax.baja.ui.menu.BIToggleMenuItem;

final class FxMenuFactory {
    FxMenuFactory() {
    }

    static Menu makeFor(BIMenu menu) {
        Menu fxMenu = new Menu(menu.getText());
        if (menu.isDynamic()) {
            fxMenu.getItems().add((Object)new MenuItem());
            fxMenu.setOnMenuValidation(event -> {
                menu.update();
                FxMenuFactory.buildMenu(fxMenu, menu);
            });
        } else {
            FxMenuFactory.buildMenu(fxMenu, menu);
        }
        return fxMenu;
    }

    static Menu makeFor(BIMenuItem menuItem) {
        Menu fxMenu = new Menu(menuItem.getText(), Theme.javaFx().shouldHideNonessentialIcons() ? null : FxUtil.getImage(menuItem.getImage()));
        if (menuItem instanceof BISubMenuItem) {
            FxMenuFactory.buildMenu(fxMenu, ((BISubMenuItem)menuItem).getSubMenu());
        }
        return fxMenu;
    }

    private static void buildMenu(Menu fxMenu, BIMenu menu) {
        fxMenu.getItems().clear();
        ArrayList fxMenuItems = new ArrayList();
        HashMap toggleGroupMap = new HashMap();
        BWidget widget = menu.asWidget();
        Arrays.stream(widget.getPropertiesArray()).map(arg_0 -> ((BWidget)widget).get(arg_0)).filter(Objects::nonNull).forEach(value -> {
            try {
                if (value instanceof BSeparator) {
                    fxMenuItems.add(new SeparatorMenuItem());
                } else if (value instanceof BIMenuItem) {
                    BIMenuItem menuItem = (BIMenuItem)value;
                    MenuItem fxMenuItem = FxMenuItemFactory.makeFor(menuItem);
                    FxMenuFactory.setToggleGroup(fxMenuItem, menuItem, toggleGroupMap);
                    fxMenuItems.add(fxMenuItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        fxMenu.getItems().addAll(fxMenuItems);
    }

    private static void setToggleGroup(MenuItem fxMenuItem, BIMenuItem menuItem, Map<ToggleCommandGroup<ToggleCommand>, ToggleGroup> toggleGroupMap) {
        if (!(menuItem instanceof BIToggleMenuItem)) {
            return;
        }
        BIToggleMenuItem toggleMenuItem = (BIToggleMenuItem)menuItem;
        ToggleCommandGroup group = toggleMenuItem.getToggleGroup();
        ToggleGroup fxGroup = group != null && toggleGroupMap.containsKey(group) ? toggleGroupMap.get(group) : new ToggleGroup();
        toggleGroupMap.putIfAbsent(group, fxGroup);
        if (toggleMenuItem.isRadioButtonItem() && fxMenuItem instanceof RadioMenuItem) {
            ((RadioMenuItem)fxMenuItem).setToggleGroup(fxGroup);
        }
    }
}

