/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx;

import com.tridium.sys.Nre;
import com.tridium.ui.swing.BSwingWidget;
import com.tridium.ui.theme.Theme;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

@NiagaraType
public abstract class BFxWidget
extends BSwingWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BFxWidget.class);
    static String BAJAUI_CSS;
    private JFXPanel jfxPanel;
    private Node node;
    private BorderPane borderPane;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 12) {
            this.fwStopped();
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStopped() {
        if (this.jfxPanel != null) {
            BFxWidget.postfx(() -> {
                this.jfxPanel.setScene(null);
                this.borderPane.setCenter(null);
            });
        }
    }

    @Override
    public JComponent createContent() {
        this.jfxPanel = new JFXPanel(){

            protected void processMouseEvent(MouseEvent mouseEvent) {
                if (Nre.bootEnv.isRemote()) {
                    HierarchyEvent he = new HierarchyEvent((Component)BFxWidget.this.jfxPanel, 1401, (Component)BFxWidget.this.jfxPanel, BFxWidget.this.jfxPanel.getParent());
                    BFxWidget.this.jfxPanel.dispatchEvent((AWTEvent)he);
                }
                super.processMouseEvent(mouseEvent);
            }
        };
        this.jfxPanel.setLayout((LayoutManager)new BorderLayout());
        return this.jfxPanel;
    }

    @Override
    protected void doInitialize() {
        if (!this.canInitialize()) {
            return;
        }
        Platform.setImplicitExit((boolean)false);
        BFxWidget.postfx(() -> {
            Stage stage = new Stage();
            stage.setResizable(false);
            this.borderPane = new BorderPane();
            AccessController.doPrivileged(() -> {
                Scene scene = new Scene((Parent)this.borderPane);
                scene.getStylesheets().add((Object)BAJAUI_CSS);
                String fxCss = Theme.getFxCss();
                if (fxCss != null) {
                    scene.getStylesheets().add((Object)fxCss);
                }
                stage.setScene(scene);
                if (this.node == null) {
                    this.node = this.createNode();
                }
                this.borderPane.setCenter(this.node);
                this.borderPane.setStyle(String.format("-fx-font-size: %spx;", Theme.label().getTextFont().getSize()));
                this.jfxPanel.setScene(scene);
                BWidget.invokeLater(this::relayoutAll);
                return null;
            });
            this.fxInitialized();
            this.relayout();
        });
    }

    private void relayoutAll() {
        for (BWidget w = this; w != null; w = w.getParentWidget()) {
            if (w.needsLayout()) continue;
            w.relayout();
        }
    }

    public abstract Node createNode();

    protected final Node getNode() {
        return this.node;
    }

    protected void fxInitialized() {
    }

    protected final JFXPanel getJfxPanel() {
        return this.jfxPanel;
    }

    public static void postfx(Runnable r) {
        Platform.runLater((Runnable)r);
    }

    public static boolean isFxThread() {
        return Platform.isFxApplicationThread();
    }

    public CompletableFuture<BImage> snapshot() {
        CompletableFuture<BImage> future = new CompletableFuture<BImage>();
        Runnable r = () -> {
            if (this.node == null) {
                future.complete(BImage.DEFAULT);
            } else {
                WritableImage wimg = new WritableImage((int)this.getWidth(), (int)this.getHeight());
                this.node.snapshot(result -> {
                    BufferedImage bimg = SwingFXUtils.fromFXImage((Image)wimg, null);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bimg, "png", out);
                        future.complete(BImage.make((byte[])out.toByteArray()));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                    return null;
                }, new SnapshotParameters(), wimg);
            }
        };
        if (BFxWidget.isFxThread()) {
            r.run();
        } else {
            BFxWidget.postfx(r);
        }
        return future;
    }

    static {
        AccessController.doPrivileged(() -> new JFXPanel());
        String[] fontPaths = Theme.getFontPaths();
        if (fontPaths != null) {
            for (String path : fontPaths) {
                try {
                    AccessController.doPrivileged(() -> Font.loadFont((String)path, (double)-1.0));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        BAJAUI_CSS = TYPE.getModule().getResource("rc/fx/theme.css").toString();
    }
}

