/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.theme.Theme;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;

public class PreviewRenderer {
    BWidget parent;
    BIFile file;
    Preparer preparer;

    public PreviewRenderer(BWidget parent) {
        this.parent = parent;
    }

    public BIFile getFile() {
        return this.file;
    }

    public void setFile(BIFile file) {
        this.file = file;
    }

    public final void paint(Graphics g) {
        if (this.preparer.prepared) {
            this.doPaint(g);
        } else {
            String text = UiLexicon.bajaui().getText("fileChooser.loading");
            BFont font = Theme.widget().getTextFont();
            double x = (this.preparer.w - font.width(text)) / 2.0;
            double y = (this.preparer.h - font.getHeight()) / 2.0;
            g.setFont(font);
            g.setBrush(BColor.black);
            g.drawString(text, x, y + font.getAscent());
        }
    }

    public void doPaint(Graphics g) {
    }

    public final void prepare(double width, double height) {
        this.preparer = new Preparer(width, height);
        this.preparer.start();
    }

    public void doPrepare(double width, double height) throws Exception {
    }

    class Preparer
    extends Thread {
        double w;
        double h;
        boolean prepared;

        public Preparer(double w, double h) {
            this.w = w;
            this.h = h;
            this.prepared = false;
        }

        @Override
        public void run() {
            try {
                PreviewRenderer.this.doPrepare(this.w, this.h);
                this.prepared = true;
                PreviewRenderer.this.parent.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

