/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.provisioning;

import com.tridium.migrator.MigrationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BProvisioningConverter
extends BComponent
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BProvisioningConverter.class);
    private static final List<String> convertTypes;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) {
        String[] moduleAndType = typeSpecName.split(":");
        if ("PlatformConnection".equals(moduleAndType[1])) {
            boolean foundSecure = false;
            boolean foundPort = false;
            for (XElem propElem : x.elems("p")) {
                if ("secure".equals(propElem.get("n", null))) {
                    if ("true".equals(propElem.get("v", "false"))) {
                        MigrationUtils.logInfo("provisioningConverter.removeUnneededSecure", new Object[0]);
                        x.removeContent((XContent)propElem);
                    } else {
                        MigrationUtils.logInfo("provisioningConverter.updateDefaultSecure", new Object[0]);
                        propElem.setAttr("v", "false");
                    }
                    foundSecure = true;
                } else if ("port".equals(propElem.get("n", null))) {
                    String portValue = propElem.get("v", null);
                    if ("5011".equals(portValue)) {
                        MigrationUtils.logInfo("provisioningConverter.removeUnneededPort", new Object[0]);
                        x.removeContent((XContent)propElem);
                    } else if (portValue == null) {
                        MigrationUtils.logInfo("provisioningConverter.updateDefaultPort", new Object[0]);
                        propElem.setAttr("v", "3011");
                    }
                    foundPort = true;
                }
                if (foundSecure && foundPort) break;
            }
            if (!foundSecure) {
                XElem secure = new XElem("p");
                secure.addAttr("n", "secure");
                secure.addAttr("v", "false");
                MigrationUtils.logInfo("provisioningConverter.addSecureDefault", new Object[0]);
                x.addContent((XContent)secure);
            }
            if (!foundPort) {
                XElem port = new XElem("p");
                port.addAttr("n", "port");
                port.addAttr("v", "3011");
                MigrationUtils.logInfo("provisioningConverter.addPortDefault", new Object[0]);
                x.addContent((XContent)port);
            }
        } else if ("ProvisioningNiagaraNetworkExt".equals(moduleAndType[1])) {
            for (XElem actElem : x.elems("a")) {
                if (!actElem.get("n", "").equals("startBackup")) continue;
                MigrationUtils.logInfo("provisioningConverter.removeStartBackup", new Object[0]);
                x.removeContent((XContent)actElem);
            }
        }
        return x;
    }

    static {
        ArrayList mutableConvertTypes = new ArrayList();
        Collections.addAll(mutableConvertTypes, "provisioningNiagara:PlatformConnection", "provisioningNiagara:ProvisioningNiagaraNetworkExt");
        convertTypes = Collections.unmodifiableList(mutableConvertTypes);
    }
}

