/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.ldap;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.BAuthenticationService;
import com.tridium.ldap.BLdapAuthenticationScheme;
import com.tridium.ldap.v3.BKerberosAuthenticationScheme;
import com.tridium.migrator.baja.BClientPasswordConverter;
import com.tridium.migrator.baja.BUserConfigConverter;
import com.tridium.util.ComponentTreeCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BBlankAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BLdapUserServiceConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapUserServiceConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private static final Logger log;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeName, Version sourceVersion) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BLdapUserServiceConverter.convertXElem(): x=" + x + "; typeName=" + typeName);
        }
        switch (typeName) {
            case "ldap:LdapUserService": {
                log.info("Converting ldap:LdapUserService to b:UserService");
                x.setAttr("n", "UserService");
                x.setAttr("t", "b:UserService");
                x = new BUserConfigConverter().convertXElem(x, "baja:UserService", sourceVersion);
                break;
            }
            case "ldap:PrototypeFolder": {
                log.info("Converting ldap:PrototypeFolder to b:UserPrototypes");
                x.setAttr("n", "userPrototypes");
                x.setAttr("t", "b:UserPrototypes");
                break;
            }
            case "ldap:ActiveDirectoryExt": 
            case "ldap:LdapV2": 
            case "ldap:LdapV3Ext": {
                x = this.setupLdapScheme(x, typeName);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BLdapUserServiceConverter.convertXElem() FINISH: returning x: " + x);
        }
        return x;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BLdapUserServiceConverter.convertComplex(): root=" + root + "; toConvert=" + toConvert);
        }
        if (!(toConvert instanceof BLdapAuthenticationScheme) && !(toConvert instanceof BKerberosAuthenticationScheme)) {
            return;
        }
        if (!(toConvert.getParent() instanceof BUserService)) {
            return;
        }
        BAuthenticationScheme scheme = (BAuthenticationScheme)toConvert.as(BAuthenticationScheme.class);
        BUserService userService = null;
        BAuthenticationSchemeFolder authSchemeFolder = null;
        BAuthenticationService authService = null;
        BServiceContainer serviceContainer = null;
        ComponentTreeCursor ctc = new ComponentTreeCursor(root, null);
        while (ctc.nextComponent()) {
            BComponent c = ctc.get().asComponent();
            if (c.getType().is(BUserService.TYPE)) {
                userService = (BUserService)c.as(BUserService.class);
                if (authSchemeFolder == null) continue;
                break;
            }
            if (c.getType().is(BAuthenticationSchemeFolder.TYPE)) {
                authSchemeFolder = (BAuthenticationSchemeFolder)c.as(BAuthenticationSchemeFolder.class);
                if (userService == null) continue;
                break;
            }
            if (c.getType().is(BAuthenticationService.TYPE)) {
                authService = (BAuthenticationService)c.as(BAuthenticationService.class);
                continue;
            }
            if (!c.getType().is(BServiceContainer.TYPE)) continue;
            serviceContainer = (BServiceContainer)c.as(BServiceContainer.class);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished finding the services: userService=" + userService + "; authSchemeFolder=" + authSchemeFolder + "; authService=" + authService + "; serviceContainer=" + serviceContainer);
        }
        if (authSchemeFolder == null) {
            if (authService == null) {
                authService = new BAuthenticationService();
                serviceContainer.add(authService.getType().getTypeName(), (BValue)authService);
            }
            authSchemeFolder = authService.getAuthenticationSchemes();
        }
        if (authSchemeFolder == null) {
            throw new IllegalStateException("No Authentication Service found in station!");
        }
        String schemeName = scheme.getName();
        log.info("Moving " + schemeName + " to AuthenticationSchemeFolder");
        scheme.getParent().asComponent().remove(schemeName);
        authSchemeFolder.add(schemeName, (BValue)scheme);
        ctc = new ComponentTreeCursor((BComponent)userService, null);
        while (ctc.nextComponent()) {
            BUser user;
            BComponent c = ctc.get().asComponent();
            if (!c.getType().is(BUser.TYPE) || !BLdapUserServiceConverter.isLdapUser(user = (BUser)c.as(BUser.class))) continue;
            String username = user.getUsername();
            String userSchemeName = schemeName;
            BValue extensionName = user.get("ldapExtension");
            if (extensionName != null) {
                userSchemeName = ((BString)extensionName).getString();
                log.info("Setting user " + username + "'s AuthenticationScheme to " + userSchemeName);
                user.remove("ldapExtension");
            } else {
                log.info("No configured ldapExtension found on " + username + ". Setting AuthenticationScheme to " + userSchemeName);
            }
            String flags = Flags.encodeToString((int)user.getParent().getFlags((Slot)user.getPropertyInParent()));
            flags = flags.replace("1", "");
            user.getParent().setFlags((Slot)user.getPropertyInParent(), Flags.decodeFromString((String)flags));
            user.setAuthenticationSchemeName(userSchemeName);
            BPassword password = (BPassword)user.get("password");
            if (password == null) {
                BAbstractAuthenticator auth = user.getAuthenticator();
                if (auth != null && auth instanceof BPasswordAuthenticator) {
                    password = ((BPasswordAuthenticator)auth).getPassword();
                }
            } else {
                log.info("Removing password from user " + username);
                user.remove("password");
            }
            if (password == null) continue;
            if (scheme instanceof BLdapAuthenticationScheme) {
                log.info("Adding BPasswordCache to user " + username);
                user.setAuthenticator((BAbstractAuthenticator)new BPasswordCache(password));
                continue;
            }
            log.info("Adding BBlankAuthenticator to user " + username);
            user.setAuthenticator((BAbstractAuthenticator)new BBlankAuthenticator());
        }
    }

    public String newTypeSpec(String typeSpecName) {
        if (typeSpecName.equals("ldap:LdapUserService")) {
            return "baja:UserService";
        }
        return typeSpecName;
    }

    private static boolean isLdapUser(BUser user) {
        return Flags.isUserDefined1((BComplex)user.getParent(), (Slot)user.getPropertyInParent());
    }

    private XElem setupLdapScheme(XElem x, String typeName) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BLdapUserServiceConverter.setupLdapScheme(): x=" + x + "; typeName=" + (String)typeName);
        }
        XElem[] children = x.elems();
        XElem scheme = new XElem("p");
        XElem config = new XElem("p");
        config.setAttr("n", "config");
        String schemeName = x.get("n");
        switch (typeName) {
            case "ldap:ActiveDirectoryExt": {
                scheme.setAttr("n", schemeName);
                scheme.setAttr("t", "ldap:LdapAuthenticationScheme");
                XElem typeSpec = new XElem("p");
                typeSpec.setAttr("n", "typeSpec");
                typeSpec.setAttr("t", "b:TypeSpec");
                typeSpec.setAttr("v", "ldap:ActiveDirectoryConfig");
                config.setAttr("t", "ldap:LdapTypeConfig");
                config.addContent((XContent)typeSpec);
                break;
            }
            case "ldap:LdapV2": {
                BClientPasswordConverter.findAndConvert(x, "connectionPwd", (String)typeName);
                scheme.setAttr("n", schemeName);
                scheme.setAttr("t", "ldap:LdapAuthenticationScheme");
                XElem typeSpec = new XElem("p");
                typeSpec.setAttr("n", "typeSpec");
                typeSpec.setAttr("t", "b:TypeSpec");
                typeSpec.setAttr("v", "ldap:LdapV2Config");
                config.setAttr("t", "ldap:LdapTypeConfig");
                config.addContent((XContent)typeSpec);
                break;
            }
            case "ldap:LdapV3Ext": {
                XElem authenticator = null;
                for (XElem temp : children) {
                    if (!temp.get("t", "").equals("ldap:SimpleAuthenticator") && !temp.get("t", "").equals("ldap:KerberosAuthenticator")) continue;
                    x.removeContent((XContent)temp);
                    authenticator = temp;
                    break;
                }
                if (authenticator == null) {
                    authenticator = new XElem("p");
                    authenticator.setAttr("t", "ldap:SimpleAuthenticator");
                }
                if (authenticator.get("t", "").equals("ldap:KerberosAuthenticator")) {
                    BClientPasswordConverter.findAndConvert(authenticator, "stationKerberosPassword", authenticator.get("t"));
                    scheme.setAttr("n", schemeName);
                    scheme.setAttr("t", "ldap:KerberosAuthenticationScheme");
                    config.setAttr("t", "ldap:KerberosConfig");
                    for (XElem elem : authenticator.elems()) {
                        if (elem.get("n").equals("keyTabLocation")) {
                            XElem keytab = new XElem("p");
                            keytab.setAttr("n", "keyTabFile");
                            keytab.setAttr("t", "ldap:KeytabFile");
                            String oldOrd = elem.get("v");
                            int index = oldOrd.lastIndexOf("/");
                            if (index < 0 && (index = oldOrd.lastIndexOf(":")) >= 0) {
                                ++index;
                            }
                            if (index < 0) continue;
                            String fileName = oldOrd.substring(index + 1);
                            elem.setAttr("v", "file:^^ldap/" + fileName);
                            keytab.addContent((XContent)elem.copy());
                            config.addContent((XContent)keytab);
                            continue;
                        }
                        config.addContent((XContent)elem.copy());
                    }
                }
                if (authenticator.get("t", "").equals("ldap:SimpleAuthenticator")) {
                    BClientPasswordConverter.findAndConvert(authenticator, "connectionPassword", authenticator.get("t"));
                    scheme.setAttr("n", schemeName);
                    scheme.setAttr("t", "ldap:LdapAuthenticationScheme");
                    XElem typeSpec = new XElem("p");
                    typeSpec.setAttr("n", "typeSpec");
                    typeSpec.setAttr("t", "b:TypeSpec");
                    typeSpec.setAttr("v", "ldap:LdapV3Config");
                    config.setAttr("t", "ldap:LdapTypeConfig");
                    config.addContent((XContent)typeSpec);
                    for (XElem elem : authenticator.elems()) {
                        elem = elem.copy();
                        elem.setAttr("f", "r");
                        if (elem.get("t", "").equals("")) {
                            elem.setAttr("t", "b:String");
                        }
                        config.addContent((XContent)elem);
                    }
                }
                children = x.elems();
            }
        }
        for (XElem elem : children) {
            elem = elem.copy();
            String name = elem.get("n", "");
            if (scheme.get("t").equals("ldap:KerberosAuthenticationScheme") && (name.equals("bindFormat") || name.equals("realmDisplayName"))) continue;
            if (name.equals("enableConnectionPooling") || name.equals("SSL")) {
                elem.setAttr("t", "b:Boolean");
            } else if (elem.get("t", "").equals("")) {
                elem.setAttr("t", "b:String");
            }
            if (scheme.get("t").equals("ldap:LdapAuthenticationScheme")) {
                elem.setAttr("f", "r");
            }
            config.addContent((XContent)elem);
        }
        log.info("Converting " + (String)typeName + " to " + scheme.get("t"));
        scheme.addContent((XContent)config);
        return scheme;
    }

    static {
        convertTypes.add("ldap:LdapUserService");
        convertTypes.add("ldap:PrototypeFolder");
        convertTypes.add("ldap:ActiveDirectoryExt");
        convertTypes.add("ldap:LdapV2");
        convertTypes.add("ldap:LdapV3Ext");
        convertTypes.add("ldap:LdapAuthenticationScheme");
        convertTypes.add("ldap:KerberosAuthenticationScheme");
        log = Logger.getLogger("migration.ldap");
    }
}

