/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.history;

import com.tridium.history.log.BLogRecord;
import com.tridium.migrator.MigrationUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.baja.history.BHistoryRecord;
import javax.baja.migration.BFileMigrator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BHistoryDbMigrator
extends BFileMigrator {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryDbMigrator.class);
    private static final Lexicon lex = Lexicon.make((String)"migrator");
    private final Logger log = Logger.getLogger("migration.history");
    private final List<String> corruptHistoryMessages = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateDirs() {
        return new String[]{"history"};
    }

    public String[] getMigrateFiles() {
        return new String[]{"history"};
    }

    public String[] getMigrateTypes() {
        return new String[]{"hdb"};
    }

    public void setLogLevel(Level level) {
        super.setLogLevel(level);
        this.log.setLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> migrate() throws Exception {
        StringBuilder sb = new StringBuilder();
        Optional<String> result = Optional.empty();
        File[] srcFiles = this.source.listFiles();
        if (srcFiles == null) {
            return Optional.of("Empty history folder!");
        }
        String srcStationName = BHistoryDbMigrator.getStationName(this.source);
        String tgtStationName = BHistoryDbMigrator.getStationName(this.target);
        for (File srcFile : srcFiles) {
            String srcName = srcFile.getName();
            if ("station".equals(FileUtil.getBase((String)srcName))) {
                this.log.config("Migrating station history db: " + srcFile);
                Optional<String> res = this.migrateHistoryDb(this.source, srcStationName, this.target, tgtStationName);
                if (!res.isPresent()) continue;
                sb.append(res.get());
                continue;
            }
            if ("zip".equals(FileUtil.getExtension((String)srcName))) {
                File tempSrc = MigrationUtils.createMigTempDir("histSrc");
                File tempTgt = MigrationUtils.createMigTempDir("histTgt");
                this.log.config("Migrating zipped history db: " + srcFile);
                this.log.fine("Extracting zip to temp file " + tempSrc);
                try (ZipFile zSrc = new ZipFile(srcFile);){
                    MigrationUtils.extractZip(zSrc, tempSrc, ze -> true);
                    Optional<String> res = this.migrateHistoryDb(tempSrc, srcStationName, tempTgt, tgtStationName);
                    if (res.isPresent()) {
                        sb.append(res.get()).append(';');
                    }
                    this.log.fine("Compressing temp file " + tempTgt + " to zip");
                    MigrationUtils.createZip(tempTgt, new File(this.target, srcName));
                    continue;
                }
                finally {
                    FileUtil.delete((File)tempSrc);
                    FileUtil.delete((File)tempTgt);
                }
            }
            this.log.warning("\nUnexpected file in history db migration:" + srcFile);
        }
        if (sb.length() > 0) {
            result = Optional.of(sb.toString());
        }
        return result;
    }

    public void addCompletionMessage(List<String> messages) {
        messages.addAll(this.corruptHistoryMessages);
    }

    /*
     * Exception decompiling
     */
    private Optional<String> migrateHistoryDb(File src, String srcStationName, File tgt, String tgtStationName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateLogSeverity(BHistoryRecord writeRec) {
        if (writeRec instanceof BLogRecord) {
            BLogRecord record = (BLogRecord)writeRec;
            int oldSeverityValue = record.getSeverity();
            int newSeverityValue = 0;
            switch (oldSeverityValue) {
                case 0: {
                    newSeverityValue = 500;
                    break;
                }
                case 1: {
                    newSeverityValue = 800;
                    break;
                }
                case 2: {
                    newSeverityValue = 900;
                    break;
                }
                case 3: {
                    newSeverityValue = 1000;
                }
            }
            if (newSeverityValue == 0) {
                this.log.info("No matching j.u.logging severity level was found for baja severity level " + oldSeverityValue + "; setting to default level INFO");
                record.setSeverity(800);
            } else {
                record.setSeverity(newSeverityValue);
            }
        }
    }

    private static String getStationName(File hdbFile) {
        File parent = hdbFile.getParentFile();
        return parent.getName();
    }

    private static String progressName(String fullPath) {
        if (fullPath == null) {
            return "";
        }
        int ndx = fullPath.indexOf("migTemp");
        if (ndx < 0) {
            return fullPath;
        }
        return fullPath.substring(ndx + 7);
    }
}

