/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.baja;

import com.tridium.authn.BAuthenticationService;
import com.tridium.migrator.MigReportUtil;
import com.tridium.migrator.baja.BRestrictedServiceConverter;
import com.tridium.user.BGlobalPasswordConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BUserConfigConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BUserConfigConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private final String GLOBAL_CONFIG = "baja_UserServicePasswordConfiguration";
    private final String STRONG_PASSWORDS = "requireStrongPasswords";
    private final String PASSWORD_STRENGTH = "passwordStrength";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeName, Version sourceVersion) {
        if (typeName.equals("baja:UserServicePasswordConfiguration")) {
            log.info("Changing " + typeName + " to b:GlobalPasswordConfiguration");
            x.setAttr("t", "b:GlobalPasswordConfiguration");
        } else if (typeName.equals("baja:UserService")) {
            XElem[] props;
            for (XElem p : props = x.elems("p")) {
                String n = p.get("n", "-");
                if (!n.equals("requireStrongPasswords")) continue;
                log.info("Removing requireStrongPasswords property from " + typeName);
                x.removeContent((XContent)p);
                break;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("migrated: new x is %s", x));
        }
        return x;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        if (toConvert instanceof BUserService) {
            this.movePasswordConfig((BUserService)toConvert, root);
            BRestrictedServiceConverter.checkRestrictedService(root, toConvert);
        }
    }

    public String newTypeSpec(String typeSpecName) {
        if (typeSpecName.equals("baja:UserServicePasswordConfiguration")) {
            return "baja:GlobalPasswordConfiguration";
        }
        return typeSpecName;
    }

    private BAuthenticationService getAuthenticationService(BComponent root) {
        BAuthenticationService authService = null;
        BServiceContainer[] services = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (services != null && services.length > 0) {
            BAuthenticationService[] authServices = (BAuthenticationService[])services[0].getChildren(BAuthenticationService.class);
            if (authServices == null || authServices.length <= 0) {
                log.info("Creating a new AuthenticationService.");
                authService = new BAuthenticationService();
                services[0].add(authService.getType().getTypeName(), (BValue)authService);
            } else {
                authService = authServices[0];
                log.fine("Found existing AuthenticationService: " + authService);
            }
        }
        return authService;
    }

    private void movePasswordConfig(BUserService service, BComponent root) {
        block9: {
            BPasswordStrength strength;
            block8: {
                BAuthenticationService authService;
                BGlobalPasswordConfiguration config = (BGlobalPasswordConfiguration)service.get("baja_UserServicePasswordConfiguration");
                strength = (BPasswordStrength)service.get("passwordStrength");
                if (service.get("requireStrongPasswords") != null) {
                    log.info(String.format("BUserService: removing %s from component %s [%s]", "requireStrongPasswords", service, service.getType()));
                    service.remove("requireStrongPasswords");
                }
                if (config == null) break block8;
                service.remove("baja_UserServicePasswordConfiguration");
                if (strength != null) {
                    log.info(String.format("BUserService: moving %s from component %s [%s] to component %s [%s]", "passwordStrength", service, service.getType(), config, config.getType()));
                    service.remove("passwordStrength");
                    config.setPasswordStrength(strength);
                }
                if ((authService = this.getAuthenticationService(root)) == null) {
                    log.severe("Could not convert UserService: no AuthenticationService can be found under root component " + MigReportUtil.getReportName((BComplex)root));
                    return;
                }
                BAuthenticationScheme[] schemes = (BAuthenticationScheme[])authService.getAuthenticationSchemes().getChildren(BAuthenticationScheme.class);
                if (schemes == null) break block9;
                for (BAuthenticationScheme scheme : schemes) {
                    if (!(scheme instanceof BPasswordAuthenticationScheme)) continue;
                    log.info(String.format("BUserService: moving %s from component %s [%s] to component %s [%s]", "baja_UserServicePasswordConfiguration", service, service.getType(), scheme, scheme.getType()));
                    ((BPasswordAuthenticationScheme)scheme).setGlobalPasswordConfiguration((BGlobalPasswordConfiguration)config.newCopy());
                }
                break block9;
            }
            if (strength != null) {
                service.remove("passwordStrength");
                BAuthenticationService authService = this.getAuthenticationService(root);
                if (authService == null) {
                    log.severe("Could not convert UserService: no AuthenticationService can be found under root component " + MigReportUtil.getReportName((BComplex)root));
                    return;
                }
                BAuthenticationScheme[] schemes = (BAuthenticationScheme[])authService.getAuthenticationSchemes().getChildren(BAuthenticationScheme.class);
                if (schemes != null) {
                    for (BAuthenticationScheme scheme : schemes) {
                        if (!(scheme instanceof BPasswordAuthenticationScheme)) continue;
                        BGlobalPasswordConfiguration globalConfig = ((BPasswordAuthenticationScheme)scheme).getGlobalPasswordConfiguration();
                        log.info(String.format("BUserService: moving %s from component %s [%s] to component %s [%s]", "passwordStrength", service, service.getType(), globalConfig, globalConfig.getType()));
                        globalConfig.setPasswordStrength((BPasswordStrength)strength.newCopy());
                    }
                }
            }
        }
    }

    static {
        convertTypes.add("baja:UserService");
        convertTypes.add("baja:UserServicePasswordConfiguration");
        convertTypes.add("baja:UserPasswordConfiguration");
        convertTypes.add("baja:GlobalPasswordConfiguration");
    }
}

