/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator.alarm;

import com.tridium.migrator.baja.BRestrictedServiceConverter;
import com.tridium.orion.BOrionService;
import java.util.ArrayList;
import java.util.List;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.driver.BDriverContainer;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
public class BAlarmServiceConverter
extends BComponent
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmServiceConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeName, Version sourceVersion) {
        int originalCapacity = 500;
        for (XElem xlm : x.elems("p")) {
            String n = xlm.get("n", "");
            if (!n.equals("capacity")) continue;
            originalCapacity = xlm.geti("v", 500);
            x.removeContent((XContent)xlm);
        }
        if (typeName.equals("alarm:AlarmService")) {
            XElem dbConfig = new XElem("p");
            dbConfig.setAttr("n", "alarmDbConfig");
            XElem capacity = new XElem("p");
            capacity.setAttr("n", "capacity");
            capacity.setAttr("v", "" + originalCapacity);
            dbConfig.addContent((XContent)capacity);
            x.addContent((XContent)dbConfig);
        }
        if (typeName.equals("alarmRdb:RdbAlarmService")) {
            XElem[] xa;
            x.setAttr("n", "OrionAlarmService");
            x.setAttr("m", "alarmOrion=alarmOrion");
            x.setAttr("t", "alarmOrion:OrionAlarmService");
            log.info("Changing RdbAlarmService to alarmOrion:OrionAlarmService");
            for (XElem xdr : xa = x.elems()) {
                if (!xdr.attrValue(xdr.attrIndex("n")).equals("driver")) continue;
                xdr.setAttr("t", "b:String");
            }
        }
        return x;
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) throws Exception {
        BRestrictedServiceConverter.checkRestrictedService(root, toConvert);
        if (!(toConvert instanceof BOrionAlarmService)) {
            return;
        }
        BOrionAlarmService oas = (BOrionAlarmService)toConvert;
        BServiceContainer services = (BServiceContainer)toConvert.getParent();
        if (((BOrionService[])services.getChildren(BOrionService.class)).length > 0) {
            return;
        }
        services.add("OrionService", (BValue)new BOrionService());
        BValue v = oas.get("driver");
        if (v == null) {
            return;
        }
        String driver = v.toString();
        oas.remove("driver");
        BDriverContainer dc = (BDriverContainer)root.get("Drivers");
        if (dc == null) {
            return;
        }
        BRdbmsNetwork[] rdNets = (BRdbmsNetwork[])dc.getChildren(BRdbmsNetwork.class);
        if (rdNets.length == 0) {
            return;
        }
        oas.setDatabase(BOrd.make((String)("station:|slot:/Drivers/" + rdNets[0].getName() + "/" + driver)));
    }

    public BValue newInstance(String moduleName, String typeName) {
        return (BValue)BTypeSpec.make((String)moduleName, (String)typeName).getInstance();
    }

    public String newTypeSpec(String typeSpecName) {
        if (typeSpecName.equals("alarmRdb:RdbAlarmService")) {
            return "alarmOrion:OrionAlarmService";
        }
        return typeSpecName;
    }

    static {
        convertTypes.add("alarm:AlarmService");
        convertTypes.add("alarmOrion:OrionAlarmService");
        convertTypes.add("alarmRdb:RdbAlarmService");
    }
}

