/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.migrator.BBogMigrator;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.util.List;
import java.util.logging.Level;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.ConverterRegistry;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.xml.XException;

public class MigratorTypeResolver
extends ValueDocDecoder.BogTypeResolver {
    private BBogMigrator bogMigrator;

    public MigratorTypeResolver(BBogMigrator bogMigrator) {
        this.bogMigrator = bogMigrator;
    }

    public BModule loadModule(ValueDocDecoder decoder, BComplex parent, String propName, String moduleStr, String typeStr) {
        try {
            String[] an = moduleStr.trim().split("=");
            if (an.length != 2) {
                throw new IllegalArgumentException(moduleStr);
            }
            String abbrev = an[0];
            String name = an[1];
            NModule[] modules = Nre.getModuleManager().loadModuleParts(name);
            if (modules.length > 0) {
                this.updateModuleMap(decoder, modules);
                this.bogMigrator.updateModuleMap(abbrev, name);
                return modules[0].bmodule();
            }
            return null;
        }
        catch (ModuleException e) {
            if (BBogMigrator.log.isLoggable(Level.FINE)) {
                BBogMigrator.log.fine("Skipping ModuleException " + (Object)((Object)e) + " for moduleStr '" + moduleStr + "'");
            }
            return null;
        }
        catch (Exception e) {
            throw decoder.getPlugin().err("Invalid module attribute '" + moduleStr + "'");
        }
    }

    public BValue newInstance(ValueDocDecoder decoder, BComplex parent, String propName, Property prop, String typeStr) {
        if (typeStr == null) {
            if (prop != null) {
                return prop.getDefaultValue();
            }
            decoder.getPlugin().warningAndSkip("Missing frozen property: " + propName);
            return null;
        }
        String moduleName = "";
        String tkey = "";
        try {
            String[] kn = typeStr.split(":");
            if (kn.length != 2) {
                throw decoder.getPlugin().err("Invalid typespec '" + typeStr + "'");
            }
            tkey = kn[0];
            String tname = kn[1];
            NModule[] nModules = this.getMappedModules(decoder, tkey);
            if (nModules == null) {
                moduleName = this.bogMigrator.getMappedModuleName(tkey);
                nModules = Nre.getModuleManager().loadModuleParts(moduleName);
            }
            if (nModules == null) {
                moduleName = (String)this.getModuleNameMap(decoder).get(tkey);
                List noModuleHandlers = ConverterRegistry.lookupConverters((String)moduleName);
                if (!noModuleHandlers.isEmpty()) {
                    BValue handlerValue = ((BIBogElementConverter)noModuleHandlers.get(noModuleHandlers.size() - 1)).newInstance(moduleName, tname);
                    if (handlerValue == null) {
                        decoder.getPlugin().warningAndSkip("Type \"" + typeStr + "\" not found for prop " + propName);
                        return null;
                    }
                    decoder.getPlugin().warning("Type \"" + typeStr + "\" migrated to type \"" + handlerValue.getType());
                    return handlerValue;
                }
                throw decoder.getPlugin().err("Undeclared module symbol: " + tkey, (Throwable)new ModuleNotFoundException(tkey));
            }
            RuntimeProfile typeProfile = nModules[0].bmodule().getType(tname).getRuntimeProfile();
            for (NModule module : nModules) {
                if (module.getRuntimeProfile() != typeProfile) continue;
                return ValueDocDecoder.typeResolverNewInstance((NModule)module, (String)tname);
            }
            throw new TypeNotFoundException(tname);
        }
        catch (XException e) {
            throw e;
        }
        catch (TypeNotFoundException e) {
            decoder.getPlugin().warningAndSkip("Type '" + e.getMessage() + "' not found: " + propName + "; parent:" + parent.getName());
            BBogMigrator.log.log(Level.WARNING, "stacktrace:", e);
            return null;
        }
        catch (ModuleNotFoundException e) {
            decoder.getPlugin().warningAndSkip("Module '" + moduleName + "' not found for " + tkey);
            return null;
        }
        catch (Throwable e) {
            BBogMigrator.log.log(Level.WARNING, "Cannot instantiate type '" + typeStr + "'", e);
            throw decoder.getPlugin().err("Cannot instantiate type '" + typeStr + "'", e);
        }
    }
}

