/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.nre.security.SecretChars;
import java.io.Console;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.sys.Localizable;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

public class LazyConsolePassPhraseSupplier
implements Supplier<BPassword> {
    private BPassword passPhrase = null;
    private static final Lexicon LEXICON = Lexicon.make((String)"migrator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BPassword get() {
        if (this.passPhrase != null) {
            return this.passPhrase;
        }
        Console console = System.console();
        while (true) {
            System.out.println(LEXICON.getText("migrate.passphrase.header"));
            SecretChars passPhrase1 = new SecretChars(console.readPassword("%s ", LEXICON.getText("migrate.passphrase.enter")), true);
            Throwable throwable = null;
            try {
                if (passPhrase1.size() == 0) {
                    BPassword bPassword = null;
                    return bPassword;
                }
                try {
                    SecretChars passPhrase2 = new SecretChars(console.readPassword("%s ", LEXICON.getText("migrate.passphrase.confirm")), true);
                    Throwable throwable2 = null;
                    try {
                        if (Arrays.equals(passPhrase1.get(), passPhrase2.get())) {
                            AtomicReference messageRef = new AtomicReference();
                            if (BPasswordStrength.DEFAULT.isPasswordValid(passPhrase1.get(), messageRef::set)) {
                                BPassword bPassword = this.passPhrase = BPassword.make((char[])passPhrase1.get(), (String)BAes256PasswordEncoder.ENCODING_TYPE);
                                return bPassword;
                            }
                            System.out.println(((Localizable)messageRef.get()).toString(null));
                            continue;
                        }
                        System.out.println(LEXICON.getText("migrate.passphrase.mismatch"));
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (passPhrase2 == null) continue;
                        if (throwable2 != null) {
                            try {
                                passPhrase2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        passPhrase2.close();
                        continue;
                    }
                }
                finally {
                    System.out.println(LEXICON.getText("migrate.passphrase.recorded"));
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (passPhrase1 == null) continue;
                if (throwable != null) {
                    try {
                        passPhrase1.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                passPhrase1.close();
                continue;
            }
            break;
        }
    }
}

