/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.install.installable.DistributionManifest;
import com.tridium.migrator.MigReportUtil;
import com.tridium.migrator.MigrationUtils;
import com.tridium.util.CompUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.converters.BObjectToString;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BPxFile;
import javax.baja.migration.BFileMigrator;
import javax.baja.migration.BIPxElementConverter;
import javax.baja.migration.ConverterRegistry;
import javax.baja.migration.IOrdConverter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BValueBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

@NiagaraType
public class BPxMigrator
extends BFileMigrator {
    @Generated
    public static final Type TYPE = Sys.loadType(BPxMigrator.class);
    private static final String DFS = "decodeFromString(";
    private static final Pattern SLOT_ROOT_PATTERN = Pattern.compile("slot:/", 16);
    private static final Lexicon lex = Lexicon.make((String)"migrator");
    public final Logger log = Logger.getLogger("migration.px");
    private BComplex pxBase;
    private String[] modules;
    private final Map<String, TypeInfo> types = new HashMap<String, TypeInfo>();
    private final Map<String, String> moduleMap = new HashMap<String, String>();
    protected File stubbed;
    private final TreeSet<String> removedModules = new TreeSet();
    private final TreeSet<String> removedTypes = new TreeSet();
    private Version sourceBajaVersion;
    private IOrdConverter ordConverter;
    private BComponent base;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String[] getMigrateTypes() {
        return new String[]{"px"};
    }

    public void initialize(File src, File tgt, Supplier<BPassword> passwordSupplier, DistributionManifest distManifest) {
        super.initialize(src, tgt, passwordSupplier, distManifest);
        this.sourceBajaVersion = MigrationUtils.getVersion(distManifest, "baja");
        this.stubbed = new File(this.target.getParentFile(), "stub_" + src.getName());
        this.stubbed.deleteOnExit();
    }

    public Optional<String> migrate() throws Exception {
        try {
            if (this.source.length() == 0L) {
                Optional optional = super.migrate();
                return optional;
            }
            XElem root = this.initializeDecoder();
            this.stubPx(root);
            this.writePx();
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            Optional<String> optional = MigrationUtils.errorResult(this.log, MessageFormat.format(lex.getText("migrate.exceptionFor"), this.source), e);
            return optional;
        }
        finally {
            if (!this.args.hasOption("keepTemp") && !this.stubbed.delete() && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Could not delete stub file " + this.stubbed);
            }
        }
    }

    public boolean mayContainOrds() {
        return true;
    }

    public Optional<String> updateOrds(IOrdConverter dat, boolean setZipped) {
        try {
            if (this.source.length() == 0L) {
                return Optional.empty();
            }
            this.ordConverter = dat;
            this.base = this.ordConverter.getBase();
            String pathName = this.target.getAbsolutePath().replace('\\', '/');
            String pxName = pathName.substring(pathName.lastIndexOf(47) + 1, pathName.lastIndexOf(".px"));
            BPxView[] pxViews = (BPxView[])CompUtil.getDescendants((BComponent)this.base, BPxView.class);
            if (pxViews.length == 0) {
                return Optional.empty();
            }
            this.pxBase = null;
            for (BPxView v : pxViews) {
                if (!v.getName().equals(pxName)) continue;
                this.pxBase = v.getParent();
            }
            if (this.pxBase == null) {
                return Optional.empty();
            }
            if (pathName.indexOf("/") != 0) {
                pathName = '/' + pathName;
            }
            FilePath fp = new FilePath(pathName);
            BIFile f = BFileSystem.INSTANCE.findFile(fp);
            PxDecoder decoder = new PxDecoder((BIFile)new BPxFile(f.getStore()));
            BWidget widget = decoder.decodeDocument();
            this.processComplex((BComplex)widget);
            BPxView view = new BPxView();
            if (decoder.getMedia() != null) {
                view.setMedia(decoder.getMedia().getTypeSpec());
            }
            try (PxEncoder pxEncoder = new PxEncoder(this.target);){
                pxEncoder.encodeDocument(widget, null, (BAbstractPxView)view);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return MigrationUtils.errorResult(this.log, "Error in updateOrds on " + this.target, e);
        }
    }

    public void addCompletionMessage(List<String> messages) {
        messages.addAll(this.removedModules.stream().map(s -> MessageFormat.format(lex.getText("pxMigrator.removedModule"), this.source.toPath().getFileName(), s)).collect(Collectors.toList()));
        messages.addAll(this.removedTypes.stream().map(s -> MessageFormat.format(lex.getText("pxMigrator.removedType"), this.source.toPath().getFileName(), s)).collect(Collectors.toList()));
    }

    private void decodeImport(XElem root) {
        XElem elem = root.elem("import");
        if (elem == null) {
            throw this.err("Missing <import> element", root);
        }
        XElem[] moduleElems = elem.elems("module");
        ArrayList<String> moduleList = new ArrayList<String>();
        for (XElem moduleElem : moduleElems) {
            String moduleName = moduleElem.get("name");
            List pxConverters = ConverterRegistry.lookupPxConverters((String)moduleName);
            try {
                String mappedModule = this.moduleMap.get(moduleName);
                if (mappedModule != null) {
                    Sys.loadModule((String)mappedModule);
                    moduleList.add(mappedModule);
                    continue;
                }
                if (pxConverters.isEmpty()) {
                    Sys.loadModule((String)moduleName);
                    moduleList.add(moduleName);
                    continue;
                }
                boolean found = false;
                for (BIPxElementConverter pxConverter : pxConverters) {
                    Optional optModule = pxConverter.newModule(moduleName);
                    if (!optModule.isPresent() || (mappedModule = (String)optModule.get()).equalsIgnoreCase(moduleName)) continue;
                    Sys.loadModule((String)mappedModule);
                    moduleList.add(mappedModule);
                    this.moduleMap.put(moduleName, mappedModule);
                    found = true;
                    break;
                }
                if (found) continue;
                Sys.loadModule((String)moduleName);
                moduleList.add(moduleName);
            }
            catch (ModuleException ignored) {
                elem.removeContent((XContent)moduleElem);
                this.removedModules.add(moduleName);
                this.log.fine("Removed module from px import: " + moduleName);
            }
        }
        this.modules = moduleList.toArray(new String[0]);
    }

    private Optional<String> checkPropertyType(XElem x) {
        String typeName = x.get("type");
        TypeInfo type = this.types.get(typeName);
        if (type != null) {
            return Optional.empty();
        }
        if (typeName.contains(":")) {
            String[] moduleAndType = typeName.split(":");
            try {
                type = Sys.getRegistry().getType(typeName);
                this.types.put(moduleAndType[1], type);
                return Optional.empty();
            }
            catch (TypeNotFoundException typeNotFoundException) {
                for (BIPxElementConverter converter : ConverterRegistry.lookupPxConverters((String)typeName)) {
                    Optional newTypeSpec = converter.newTypeSpec(typeName);
                    if (!newTypeSpec.isPresent()) continue;
                    type = Sys.getRegistry().getType((String)newTypeSpec.get());
                    String newTypeName = (String)converter.newTypeName(moduleAndType[1]).get();
                    this.types.put(newTypeName, type);
                    x.setAttr("type", newTypeName);
                    return Optional.empty();
                }
            }
            catch (Exception typeNotFoundException) {}
        } else {
            Optional<String> moduleCheck = this.checkModules(typeName);
            if (!moduleCheck.isPresent()) {
                return moduleCheck;
            }
        }
        for (BIPxElementConverter converter : ConverterRegistry.lookupPxConverters((String)typeName)) {
            for (String convertTypeSpecs : converter.getConvertTypeSpecs()) {
                Optional optTypeSpec;
                if (!convertTypeSpecs.endsWith(typeName) || !(optTypeSpec = converter.newTypeSpec(typeName)).isPresent()) continue;
                String newTypeSpec = (String)optTypeSpec.get();
                type = Sys.getRegistry().getType(newTypeSpec);
                String newTypeName = (String)converter.newTypeName(typeName).get();
                this.types.put(newTypeName, type);
                x.setAttr("type", newTypeName);
                return Optional.empty();
            }
        }
        return Optional.of(typeName);
    }

    private Optional<String> checkType(XElem x) {
        String typeName = x.name();
        TypeInfo type = this.types.get(typeName);
        if (type != null) {
            return Optional.empty();
        }
        Optional<String> moduleCheck = this.checkModules(typeName);
        if (!moduleCheck.isPresent()) {
            return moduleCheck;
        }
        for (BIPxElementConverter converter : ConverterRegistry.lookupPxConverters((String)typeName)) {
            for (String convertTypeSpecs : converter.getConvertTypeSpecs()) {
                Optional optTypeSpec;
                if (!convertTypeSpecs.endsWith(typeName) || !(optTypeSpec = converter.newTypeSpec(typeName)).isPresent()) continue;
                String newTypeSpec = (String)optTypeSpec.get();
                type = Sys.getRegistry().getType(newTypeSpec);
                String newTypeName = (String)converter.newTypeName(typeName).get();
                this.types.put(newTypeName, type);
                x.setName(newTypeName);
                return Optional.empty();
            }
        }
        return Optional.of(typeName);
    }

    private Optional<String> checkModules(String typeName) {
        for (String module : this.modules) {
            String moduleAndTypeName = module + ':' + typeName;
            try {
                TypeInfo type = Sys.getRegistry().getType(moduleAndTypeName);
                this.types.put(typeName, type);
                return Optional.empty();
            }
            catch (TypeNotFoundException typeNotFoundException) {
                String mappedTypeName = this.moduleMap.get(typeName);
                if (mappedTypeName == null) {
                    mappedTypeName = this.moduleMap.get(moduleAndTypeName);
                }
                if (mappedTypeName == null) continue;
                TypeInfo type = Sys.getRegistry().getType(mappedTypeName);
                this.types.put(typeName, type);
                return Optional.empty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.of(typeName);
    }

    private XElem initializeDecoder() throws Exception {
        FilePath srcPath;
        BIFile src;
        PxDecoder decoder;
        XElem root;
        String srcPathStr = this.source.getAbsolutePath().replace('\\', '/');
        if (srcPathStr.indexOf("/") != 0) {
            srcPathStr = '/' + srcPathStr;
        }
        if (!"px".equals((root = (decoder = new PxDecoder((BIFile)new BPxFile((src = BFileSystem.INSTANCE.findFile(srcPath = new FilePath(srcPathStr))).getStore()))).parse()).name())) {
            throw this.err("Root element must be \"px\"", root);
        }
        String ver = root.get("version");
        if (!"1.0".equals(ver)) {
            throw this.err("Only version 1.0 is supported", root);
        }
        this.decodeImport(root);
        return root;
    }

    private void stubPx(XElem root) throws Exception {
        XElem content;
        XElem properties;
        XElem moduleImport;
        if (!this.moduleMap.isEmpty() && (moduleImport = root.elem("import")) != null) {
            for (XElem singleImport : moduleImport.elems()) {
                String moduleName = singleImport.get("name");
                String updatedName = this.moduleMap.get(moduleName);
                if (updatedName == null) continue;
                singleImport.setAttr("name", updatedName);
            }
        }
        if ((properties = root.elem("properties")) != null) {
            XElem[] propertyElements;
            for (XElem property : propertyElements = properties.elems()) {
                Optional<String> missingType = this.checkPropertyType(property);
                if (!missingType.isPresent()) continue;
                String name = property.get("name", property.name());
                this.log.info(MessageFormat.format(lex.getText("pxMigrator.removedWidget"), name, property.name()));
                properties.removeContent((XContent)property);
                this.removedTypes.add(missingType.get());
            }
        }
        if ((content = root.elem("content")) == null) {
            throw this.err(lex.getText("pxMigrator.missingContent"), root);
        }
        XElem[] subElems = content.elems();
        if (subElems.length != 1) {
            throw this.err(lex.getText("pxMigrator.notOneChild"), content);
        }
        XElem widgetElem = subElems[0];
        LinkedList<XElem> todo = new LinkedList<XElem>();
        todo.add(widgetElem);
        while (!todo.isEmpty()) {
            XElem[] kids;
            XElem elem = (XElem)todo.removeFirst();
            for (XElem kid : kids = elem.elems()) {
                Optional<String> missingType;
                if ("LinkSheet".equals(kid.name())) {
                    kid.setName("RelationSheet");
                }
                if ((missingType = this.checkType(kid)).isPresent()) {
                    String name = kid.get("name", kid.name());
                    this.log.info(MessageFormat.format(lex.getText("pxMigrator.removedWidget"), name, kid.name()));
                    elem.removeContent((XContent)kid);
                    this.removedTypes.add(missingType.get());
                    continue;
                }
                todo.add(kid);
            }
        }
        root.write(this.stubbed);
    }

    private void writePx() throws Exception {
        String stubPathStr = this.stubbed.getAbsolutePath().replace('\\', '/');
        if (stubPathStr.indexOf("/") != 0) {
            stubPathStr = '/' + stubPathStr;
        }
        FilePath stubPath = new FilePath(stubPathStr);
        BIFile stub = BFileSystem.INSTANCE.findFile(stubPath);
        PxDecoder decoder = new PxDecoder((BIFile)new BPxFile(stub.getStore()));
        BWidget rootWidget = decoder.decodeDocument();
        BPxView view = new BPxView();
        if (decoder.getMedia() != null) {
            view.setMedia(decoder.getMedia().getTypeSpec());
        }
        try (PxEncoder pxEncoder = new PxEncoder(this.target);){
            pxEncoder.encodeDocument(rootWidget, decoder.getPxProperties(), decoder.getPxLayers(), (BAbstractPxView)view);
        }
    }

    XException err(String msg, XElem elem, Throwable cause) {
        return new XException(msg, elem, cause);
    }

    private XException err(String msg, XElem elem) {
        return new XException(msg, elem);
    }

    void warning(String msg, XElem elem) {
        String line = "";
        if (elem != null) {
            line = " [line " + elem.line() + ']';
        }
        this.log.warning("WARNING: " + msg + line);
    }

    private void processComplex(BComplex parent) {
        SlotCursor sc = parent.getProperties();
        while (sc.next()) {
            BValue v = sc.get();
            if (v instanceof BOrd) {
                this.processOrd((BOrd)v, parent, sc.property());
                continue;
            }
            if (v instanceof BFormat) {
                this.processFormat((BFormat)v, parent, sc.property());
                continue;
            }
            if (!v.isComplex()) continue;
            this.processComplex((BComplex)v);
        }
    }

    private void processOrd(BOrd ord, BComplex parent, Property p) {
        if (ord.isNull()) {
            return;
        }
        BOrd newOrd = this.ordConverter.convertOrd(ord, this.pxBase, p, this.sourceBajaVersion, this.log);
        if (newOrd == ord) {
            return;
        }
        String name = MigReportUtil.getReportName(parent, p);
        if (newOrd.isNull()) {
            this.log.info("Unable to resolve ord: " + ord + " in " + name + "; manual update may be required");
            return;
        }
        this.log.info("Modified ord at " + name + "\n\tfrom:" + ord + "\n\tto:" + newOrd);
        parent.set(p, (BValue)newOrd, null);
    }

    private void processFormat(BFormat fmt, BComplex parent, Property p) {
        Object[] objects;
        String typeSpec;
        List cnvList;
        String fs = fmt.getFormat();
        boolean changed = false;
        int ndx = fs.indexOf(DFS);
        if (ndx >= 0 && !(cnvList = ConverterRegistry.lookupPxConverters((String)(typeSpec = fs.substring(ndx += DFS.length(), fs.indexOf(58, fs.indexOf(58, ndx) + 1))))).isEmpty()) {
            for (BIPxElementConverter cnv : cnvList) {
                String newTypeSpec = (String)cnv.newTypeSpec(typeSpec).get();
                if (newTypeSpec.equals(typeSpec)) continue;
                String newFs = fs.replace(typeSpec, newTypeSpec);
                this.log.info("Modified format\n\tfrom:" + fs.substring(1, fs.length() - 1) + "\n\tto:" + newFs.substring(1, newFs.length() - 1));
                changed = true;
                fmt = BFormat.make((String)newFs);
                fs = newFs;
            }
        }
        String name = MigReportUtil.getReportName(parent, p);
        try {
            objects = fmt.parse();
        }
        catch (Throwable e) {
            this.log.info("Could not resolve format: " + fmt + " in " + name + "; manual update may be required");
            return;
        }
        for (Object object : objects) {
            if (!(object instanceof BFormat.ReflectCall)) continue;
            BFormat.ReflectCall reflect = (BFormat.ReflectCall)object;
            BComplex refObj = parent;
            if (refObj instanceof BObjectToString) {
                refObj = refObj.getParent();
            }
            if (!(refObj instanceof BValueBinding)) {
                return;
            }
            BValueBinding vb = (BValueBinding)refObj;
            BOrd baseOrd = vb.getOrd();
            if (baseOrd.isNull()) {
                return;
            }
            String bOrdOrigS = baseOrd.toString();
            String bOrds = bOrdOrigS;
            if (bOrds.startsWith("station:|")) {
                bOrds = bOrds.substring(9);
                baseOrd = BOrd.make((String)bOrds);
            }
            BComplex ordBase = this.pxBase;
            if (bOrds.startsWith("slot:/")) {
                bOrds = SLOT_ROOT_PATTERN.matcher(bOrds).replaceAll("slot:");
                baseOrd = BOrd.make((String)bOrds);
                ordBase = this.base;
            }
            BObject bo = null;
            try {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("\nattempting to resolve ord '" + baseOrd + "' against base object: " + ordBase.getName());
                }
                bo = baseOrd.resolve((BObject)ordBase).get();
            }
            catch (Exception e) {
                this.log.info("Unable to resolve ord '" + baseOrd + "' while processing BFormat: " + e + "\n  parent=" + MigReportUtil.getReportName(parent, p) + "; manual update may be required");
            }
            if (!(bo instanceof BComplex)) {
                return;
            }
            BComplex baseObj = (BComplex)bo;
            try {
                reflect.eval((Object)baseObj, null, null);
                if (!reflect.getEvalFailed()) {
                    continue;
                }
            }
            catch (Throwable e) {
                MigrationUtils.logInfo("pxMigrator.formatEval.fail", e, baseObj, MigReportUtil.getReportName(parent, p));
            }
            String origRfl = reflect.toString();
            BOrd ord = BOrd.make((String)(bOrdOrigS + '/' + origRfl));
            BOrd newOrd = this.ordConverter.convertOrd(ord, this.pxBase, p, this.sourceBajaVersion, this.log);
            if (newOrd.isNull()) {
                this.log.info("Could not resolve format: " + ord + " in " + name + "; manual update may be required");
                continue;
            }
            String newOrdS = newOrd.toString();
            String newRfl = newOrdS.substring(newOrdS.lastIndexOf(47) + 1);
            fs = fs.replace(origRfl, newRfl);
            this.log.info("Modified format at " + name + "\n\tfrom:" + origRfl + "\n\tto:" + newRfl);
            changed = true;
        }
        if (changed) {
            parent.set(p, (BValue)BFormat.make((String)fs));
        }
    }
}

