/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.setup;

import com.tridium.nrio.BNrioDevice;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.entsec.access.BAccessControlService;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class NetworkIdStatusPoll
extends Command {
    public NetworkIdStatusPoll(BHxView view) {
        super(view);
    }

    public void handle(HxOp op) throws Exception {
        String fadeRate = op.getCookie("fadeRate");
        int iFadeRate = 5;
        if (fadeRate != null) {
            iFadeRate = Integer.parseInt(fadeRate);
        }
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        HtmlWriter out = op.getHtmlWriter();
        BIAccessDevice[] modules = (BIAccessDevice[])network.getChildren(BIAccessDevice.class);
        for (int i = 0; i < modules.length; ++i) {
            NetworkIdStatusPoll.updateModule(modules[i], iFadeRate, op);
            BAccessDoor[] doors = (BAccessDoor[])modules[i].getPoints().getChildren(BAccessDoor.class);
            for (int j = 0; j < doors.length; ++j) {
                NetworkIdStatusPoll.updateComponent((BComponent)doors[j], service, iFadeRate, op);
            }
            BAccessElevator[] elevators = (BAccessElevator[])modules[i].getPoints().getChildren(BAccessElevator.class);
            for (int j = 0; j < elevators.length; ++j) {
                NetworkIdStatusPoll.updateComponent((BComponent)elevators[j], service, iFadeRate, op);
            }
        }
        BAccessReader[] readers = BAccessNetwork.getReaders((BComponent)network);
        for (int i = 0; i < readers.length; ++i) {
            NetworkIdStatusPoll.updateComponent((BComponent)readers[i], service, iFadeRate, op);
        }
        out.w((Object)"setTimeout(\"");
        out.w((Object)"hx.fireEvent('").w((Object)op.getPath());
        out.w((Object)"','");
        out.w((Object)this.getId());
        out.w((Object)"')");
        out.w((Object)"\",1000);");
    }

    public static void updateModule(BIAccessDevice module, int fadeRate, HxOp op) throws Exception {
        String handle = ((BComponent)module).getHandle().toString();
        String info = module.toStatusString((Context)op);
        HtmlWriter out = op.getHtmlWriter();
        String oldValue = op.getFormValue("hidden" + handle);
        if (oldValue == null) {
            return;
        }
        String currentValue = HxTabUtil.safeForFormValue((String)info);
        out.w((Object)"try{");
        out.w((Object)"var input = $$('").w((Object)handle).w((Object)"');");
        out.w((Object)"var bg = color.parseBG(input.style.backgroundColor);");
        out.w((Object)"if(bg[0] - ").w(fadeRate).w((Object)" > 204){");
        out.w((Object)"var newBg = '#' + color.toHex(bg[0] - ").w(fadeRate);
        out.w((Object)") + color.toHex(bg[1] - ").w(fadeRate).w((Object)") + color.toHex(bg[2] - (-").w(fadeRate * 4).w((Object)"));");
        out.w((Object)"input.style.backgroundColor = newBg;}");
        out.w((Object)"if(bg[0] - ").w(fadeRate).w((Object)" <= 204)");
        out.w((Object)"{input.style.backgroundColor = '#CCCCCC';}");
        if (!oldValue.equals(currentValue)) {
            out.w((Object)"$$('").w((Object)handle).w((Object)"')");
            out.w((Object)".style.backgroundColor='#FFFF00';");
        }
        out.w((Object)"$$('").w((Object)handle);
        out.w((Object)"').value='").w((Object)currentValue).w((Object)"';");
        out.w((Object)"$$('hidden").w((Object)handle);
        out.w((Object)"').value='").w((Object)currentValue).w((Object)"';");
        out.w((Object)"$$('wink").w((Object)handle).w((Object)"').firstChild");
        if (!Flags.isHidden((BComplex)((BComponent)module), (Slot)BNrioDevice.winkCancel)) {
            out.w((Object)".style.color='red';");
        } else {
            out.w((Object)".style.color='black';");
        }
        out.w((Object)"}catch(err){}");
    }

    public static void updateComponent(BComponent component, BAccessControlService service, int fadeRate, HxOp op) throws Exception {
        String currentValue = null;
        if (component instanceof BAccessReader) {
            currentValue = NetworkIdStatusPoll.getBadgeInfo((BAccessReader)component, service);
        } else if (component instanceof BIAccessDevice) {
            currentValue = ((BIAccessDevice)component).toStatusString((Context)op);
        } else if (component instanceof BAccessDoor) {
            currentValue = ((BAccessDoor)component).toStatusString((Context)op);
        } else if (component instanceof BAccessElevator) {
            currentValue = ((BAccessElevator)component).toStatusString((Context)op);
        }
        currentValue = HxTabUtil.safeForFormValue((String)currentValue);
        HtmlWriter out = op.getHtmlWriter();
        String oldValue = op.getFormValue("hidden" + component.getHandle());
        if (oldValue == null) {
            return;
        }
        out.w((Object)"try{");
        out.w((Object)"var input = $$('").w(component.getHandle()).w((Object)"');");
        out.w((Object)"var bg = color.parseBG(input.style.backgroundColor);");
        out.w((Object)"if(parseInt(bg[0]) - ").w(fadeRate).w((Object)" > 204){");
        out.w((Object)"var newBg = '#' + color.toHex(parseInt(bg[0]) - ").w(fadeRate);
        out.w((Object)") + color.toHex(parseInt(bg[1]) - ").w(fadeRate);
        out.w((Object)") + color.toHex(parseInt(bg[2]) - (-").w(fadeRate * 4).w((Object)"));");
        out.w((Object)"input.style.backgroundColor = newBg;}");
        out.w((Object)"if(parseInt(bg[0]) - ").w(fadeRate).w((Object)" <= 204)");
        out.w((Object)"{input.style.backgroundColor = '#CCCCCC';}");
        if (!currentValue.equals(oldValue)) {
            out.w((Object)"$$('").w(component.getHandle()).w((Object)"')");
            out.w((Object)".style.backgroundColor='#FFFF00';");
        }
        out.w((Object)"$$('").w(component.getHandle());
        out.w((Object)"').value='").w((Object)currentValue).w((Object)"';");
        out.w((Object)"$$('hidden").w(component.getHandle());
        out.w((Object)"').value='").w((Object)currentValue).w((Object)"';");
        if (component instanceof BAccessReader) {
            BAccessReader reader = (BAccessReader)component;
            out.w((Object)"$$('outputTest").w(reader.getHandle()).w((Object)"').firstChild");
            if (reader.getGreen().getStatus().isOverridden() || reader.getRed().getStatus().isOverridden() || reader.getBeeper().getStatus().isOverridden()) {
                out.w((Object)".style.color='red';");
            } else {
                out.w((Object)".style.color='black';");
            }
        }
        out.w((Object)"}catch(err){}");
    }

    public static String getBadgeInfo(BAccessReader reader, BAccessControlService service) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(reader.getStatus());
        String newBadge = reader.getLastPersonName();
        if (newBadge.length() > 0) {
            buffer.append(" ").append(newBadge);
        }
        if (reader.getValidBadge().getOut().getValue()) {
            buffer.append(" valid");
        }
        if (reader.getInvalidBadge().getOut().getValue()) {
            buffer.append(" invalid");
        }
        if (reader.getGreen().getOut().getValue()) {
            buffer.append(" green");
        }
        if (reader.getRed().getOut().getValue()) {
            buffer.append(" red");
        }
        if (reader.getBeeper().getOut().getValue()) {
            buffer.append(" beep");
        }
        return buffer.toString();
    }
}

