/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.query;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.query.BOrderByCol;
import com.tridium.query.BQueryEngine;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.FinishTableThread;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.RenameCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.export.ExportCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.filter.PrefilteringUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxAddQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.ColumnsCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.FilterCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.QueryReportCommand;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:WbQueryTableView", "query:Query"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxQueryTableView
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxQueryTableView.class);
    @Generated
    public static final BHxQueryTableView INSTANCE = new BHxQueryTableView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxQueryTableView.class);
    public static final BImage moveUp = BImage.make((BIcon)BIcon.make((String)"module://icons/x16/arrowUp.png"));
    public static final BImage moveDown = BImage.make((BIcon)BIcon.make((String)"module://icons/x16/arrowDown.png"));
    private CommandBindings bindings = null;
    private BTypeSpec dynamicRowType;
    private Command sortCommand;
    protected SmartCommand addCommand = new AddCommand((BHxView)this);
    protected SmartCommand deleteCommand;
    protected SmartCommand renameCommand;
    protected SmartCommand columnsCommand;
    protected SmartCommand filterCommand;
    protected SmartCommand hyperlinkCommand;
    protected SmartCommand refreshCommand;
    protected SmartCommand exportCommand;
    protected SmartCommand reportCommand;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxQueryTableView() {
        this.registerEvent((Event)this.addCommand);
        this.deleteCommand = new DeleteCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
        this.renameCommand = new RenameSubjectCommand((BHxView)this);
        this.registerEvent((Event)this.renameCommand);
        this.sortCommand = new SortCommand((BHxView)this);
        this.registerEvent((Event)this.sortCommand);
        this.columnsCommand = new ColumnsCommand((BHxView)this);
        this.registerEvent((Event)this.columnsCommand);
        this.filterCommand = new FilterCommand((BHxView)this);
        this.registerEvent((Event)this.filterCommand);
        this.hyperlinkCommand = new HyperlinkCommand((BHxView)this);
        this.registerEvent((Event)this.hyperlinkCommand);
        this.refreshCommand = new RefreshCommand((BHxView)this);
        this.registerEvent((Event)this.refreshCommand);
        this.exportCommand = new ExportCommand((BHxView)this);
        this.registerEvent((Event)this.exportCommand);
        this.reportCommand = new QueryReportCommand((BHxView)this);
        this.registerEvent((Event)this.reportCommand);
    }

    public boolean supportsPagination(HxOp op) {
        return true;
    }

    public boolean requiresPrefiltering(HxOp op) {
        if (op.getPath().length() > 0) {
            return false;
        }
        BQuery query = this.getQuery(op);
        BQueryTableOptions options = (BQueryTableOptions)this.getOptionsManager(op).load(BQueryTableOptions.TYPE);
        return options.getPrefiltering(query);
    }

    public void loadTable(HxOp op) throws Exception {
        FinishTableThread finishTableThread = this.makeTableThread(false, op);
        if (finishTableThread == null) {
            return;
        }
        if (this.requiresPrefiltering(op)) {
            op.addOnload(this.filterCommand.getInvokeCode(op));
            String quote = HxUtil.getInnerQuote((HxOp)op);
            op.addOnload("smartTable.pause($$(" + quote + op.scope("loading") + quote + "));");
        } else {
            op.addOnload(this.finishTableCommand.getInvokeCode(op));
        }
    }

    public BObject getBase(HxOp op) {
        return op.get();
    }

    public BQuery getQuery(HxOp op) {
        BQuery query = (BQuery)op.get();
        return QueryUtil.getWorkingCopy((BQuery)query, (BObject)this.getBase(op), (Context)op);
    }

    public void write(HxOp op) throws Exception {
        BQuery query = this.getQuery(op);
        boolean prefiltering = PrefilteringUtil.getPrefiltering((BQuery)query);
        BQueryTableOptions options = (BQueryTableOptions)this.getOptionsManager(op).load(BQueryTableOptions.TYPE);
        BFilterSet filterSet = options.getFilterSet(query);
        if (QueryUtil.hasDefaultFilters((BQuery)query) && filterSet == null || !BQueryTableOptions.isFilterSetValid((BQuery)query, (BFilterSet)filterSet)) {
            filterSet = BQueryTableOptions.rebuildFilterSet((BQuery)query, (BFilterSet)filterSet, (Context)op);
            options.setFilterSet(query, filterSet);
            this.getOptionsManager(op).save((BOptions)options);
        }
        BTypeSpec typeSpec = QueryUtil.getRowType((BQuery)query);
        BHxQueryTableView.writeFormValue((String)"typeSpec", (String)typeSpec.toString(), (HxOp)op);
        super.write(op);
    }

    public HxOptionsManager getOptionsManager(HxOp op) {
        return new HxOptionsManager(this.getBase(op), op);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addCommand, this.columnsCommand, this.filterCommand, this.hyperlinkCommand, this.deleteCommand, this.renameCommand, this.reportCommand, this.exportCommand};
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BQuery query = this.getQuery(op);
        BQueryTableOptions options = (BQueryTableOptions)this.getOptionsManager(op).load(BQueryTableOptions.TYPE);
        int sortCol = options.getSortColumnIndex(query);
        boolean asc = options.getSortColumnAscForIndex(query);
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        int visibleColumnCount = 0;
        boolean sortColumnFound = false;
        for (int i = 0; i < columns.length; ++i) {
            if (Flags.isHidden((BComplex)query.getProjection(), (Slot)columns[i].getPropertyInParent())) continue;
            out.w((Object)"<th ");
            out.attr(" id", op.scope("" + visibleColumnCount));
            out.w((Object)(" onclick='hx.setFormValue(&quot;" + op.scope("sortBy") + "&quot;,&quot;" + visibleColumnCount + "&quot;);" + this.sortCommand.getInvokeCode(op)));
            out.w((Object)"'>");
            out.safe((Object)columns[i].getAlias());
            if (sortCol == visibleColumnCount && this.isEnabled(op)) {
                BHxQueryTableView.writeSortColumnHeader(sortCol, asc, op);
                sortColumnFound = true;
            }
            out.w((Object)"</th>");
            ++visibleColumnCount;
        }
        if (!sortColumnFound) {
            BHxQueryTableView.writeSortColumnHeader(-1, false, op);
        }
    }

    public static void writeSortColumnHeader(int sortCol, boolean asc, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)" ");
        out.w((Object)"<span ");
        out.attr("id", op.scope("upArrow"));
        if (sortCol == -1 || !asc) {
            out.attr(" style", "display: none;");
        }
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)moveUp, (HxOp)op);
        out.w((Object)"</span>");
        out.w((Object)"<span ");
        out.attr("id", op.scope("downArrow"));
        if (sortCol == -1 || asc) {
            out.attr(" style", "display: none;");
        }
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)moveDown, (HxOp)op);
        out.w((Object)"</span>");
    }

    public TableContents writeContents(HxOp op) throws Exception {
        BExpression exp;
        BQuery query = this.getQuery(op);
        BQueryTableOptions options = (BQueryTableOptions)this.getOptionsManager(op).load(BQueryTableOptions.TYPE);
        int sortCol = options.getSortColumnIndex(query);
        boolean asc = options.getSortColumnAscForIndex(query);
        BFilterSet filterSet = options.getFilterSet(query);
        if (filterSet == null) {
            filterSet = BQueryTableOptions.rebuildFilterSet((BQuery)query, (BFilterSet)filterSet, (Context)op);
        }
        BQueryTableOptions.updateFilterSet((BFilterSet)filterSet);
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        BQuery copy = QueryUtil.getWorkingCopy((BQuery)query, (BObject)this.getBase(op), (Context)op);
        BPredicate queryPredicate = query.getPredicate();
        BExpression queryExp = null;
        if (queryPredicate != null) {
            queryExp = queryPredicate.getPredicateExpr();
        }
        ExpressionBuilder builder = new ExpressionBuilder(queryExp);
        if (filterSet != null && filterSet.getQueryPredicate() != null && filterSet.getQueryPredicate().getPredicateExpr() != null) {
            builder = builder.and((BExpression)filterSet.getQueryPredicate().getPredicateExpr().newCopy(true));
        }
        if ((exp = builder.getExpression()) != null) {
            copy.where(new BPredicate((BExpression)exp.newCopy(true)));
        }
        if (sortCol > -1 && sortCol < columns.length) {
            BOrderByCol orderBy = new BOrderByCol(columns[sortCol].getColumnExpression().newExprCopy());
            if (!asc) {
                orderBy.desc();
            }
            copy.orderBy(BOrdering.make((BOrderByColumn)orderBy));
        }
        BTypeSpec typeSpec = QueryUtil.getRowType((BQuery)query);
        BITable<? extends BIObject> collection = this.getCollection(BHxQueryTableView.getBaseOrd(query, op), copy, op);
        TableContents tableContents = this.writeRows(collection, query, op);
        return tableContents;
    }

    protected BITable<? extends BIObject> getCollection(BOrd baseOrd, BQuery query, HxOp op) {
        BSpace space = this.getSpace(op);
        BQueryEngine engine = BQueryEngine.make((BSpace)space);
        return engine.compile(query, baseOrd).execute();
    }

    public BSpace getSpace(HxOp op) {
        OrdTarget target = op.getBaseOrdTarget();
        BSpace space = target.getComponent().getSpace();
        while (space == null) {
            target = target.getBaseOrdTarget();
            space = target.getComponent().getSpace();
        }
        if (space == null) {
            throw new IllegalStateException("BQueryEngine requires a space");
        }
        return space;
    }

    public String getRowKey(Type rowType, TableCursor<? extends BIObject> cursor, HxOp op) {
        BITable table = cursor.getTable();
        if (rowType.is(BComponent.TYPE)) {
            Column keyColumn = table.getColumns().get(TypeSpecPath.PARENT_COMPONENT_SLOT_PATH.path);
            if (keyColumn == null) {
                keyColumn = table.getColumns().get(table.getColumns().size() - 1);
            }
            return cursor.cell(keyColumn).toString();
        }
        boolean enforceStructRules = rowType.is(BStruct.TYPE);
        Column keyColumn1 = table.getColumns().get(TypeSpecPath.PARENT_COMPONENT_SLOT_PATH.path);
        Column keyColumn2 = table.getColumns().get(TypeSpecPath.PARENT_NAME.path);
        Column keyColumn3 = table.getColumns().get(TypeSpecPath.NAME.path);
        String slotPath = cursor.cell(keyColumn1).toString(null);
        String parentName = cursor.cell(keyColumn2).toString(null);
        String name = cursor.cell(keyColumn3).toString(null);
        if (!enforceStructRules && slotPath.endsWith(name)) {
            return slotPath;
        }
        if (!slotPath.endsWith(parentName)) {
            slotPath = slotPath + "/" + parentName;
        }
        return slotPath + "/" + name;
    }

    public BImage[] getRowIcons(TableCursor<? extends BIObject> cursor, HxOp op) {
        BImage image = this.getRowIcon(cursor, op);
        if (image == null) {
            return null;
        }
        return new BImage[]{image};
    }

    public BImage getRowIcon(TableCursor<? extends BIObject> cursor, HxOp op) {
        return null;
    }

    public String getAdditionalRowClassName(TableCursor<? extends BIObject> cursor, HxOp op) {
        Column statusCol = cursor.getTable().getColumns().get(TypeSpecPath.STATUS.path);
        if (statusCol != null) {
            String typeSpec;
            Type colType = null;
            BFacets colFacets = statusCol.getFacets();
            if (colFacets != null && (typeSpec = colFacets.gets("origType", null)) != null) {
                colType = BTypeSpec.make((String)typeSpec).getResolvedType();
            }
            if (colType == null) {
                colType = statusCol.getType();
            }
            if (colType.is(BStatus.TYPE)) {
                BObject obj = (BObject)cursor.cell(statusCol);
                if (obj instanceof BStatus) {
                    BStatus status = (BStatus)obj;
                    if (status.isDisabled()) {
                        return "row-disabled";
                    }
                    if (status.isFault()) {
                        return "row-fault";
                    }
                    if (status.isDown()) {
                        return "row-down";
                    }
                    if (status.isAlarm()) {
                        return "row-alarm";
                    }
                    if (status.isStale()) {
                        return "row-stale";
                    }
                    if (status.isOverridden()) {
                        return "row-overridden";
                    }
                } else if (obj instanceof BString) {
                    String status = ((BString)obj).getString();
                    if (status.indexOf(BStatus.DEFAULT.getDisplayTag(1, (Context)op)) >= 0) {
                        return "row-disabled";
                    }
                    if (status.indexOf(BStatus.DEFAULT.getDisplayTag(2, (Context)op)) >= 0) {
                        return "row-fault";
                    }
                    if (status.indexOf(BStatus.DEFAULT.getDisplayTag(4, (Context)op)) >= 0) {
                        return "row-down";
                    }
                    if (status.indexOf(BStatus.DEFAULT.getDisplayTag(8, (Context)op)) >= 0) {
                        return "row-alarm";
                    }
                    if (status.indexOf(BStatus.DEFAULT.getDisplayTag(16, (Context)op)) >= 0) {
                        return "row-stale";
                    }
                    if (status.indexOf(BStatus.DEFAULT.getDisplayTag(32, (Context)op)) >= 0) {
                        return "row-overridden";
                    }
                }
            }
        }
        return null;
    }

    public boolean hasPermissionsFor(TableCursor<? extends BIObject> cursor, HxOp op) {
        Object o = cursor.get();
        return !(o instanceof BIProtected) || ((BIProtected)o).getPermissions((Context)op).has(BPermissions.operatorRead);
    }

    public TableContents writeRows(BITable<? extends BIObject> table, BQuery query, HxOp op) {
        TableContents contents = new TableContents(op.scope("records"));
        if (table == null || table.getColumns() == null) {
            return contents;
        }
        BTypeSpec typeSpec = ((BSingleExtent)query.getExtent()).getBaseExtent();
        Type rowType = typeSpec.getResolvedType();
        int columnSize = table.getColumns().size() - QueryUtil.getHiddenColumnsCount((BQuery)query);
        for (int k = 0; k < columnSize; ++k) {
            Column c = table.getColumns().get(k);
            TableContents.Td td = new TableContents.Td(c.getDisplayName((Context)op));
            contents.columns.td.add(td);
        }
        int maxResultSize = this.getMaxResultSize((Context)op);
        TableCursor cursor = table.cursor();
        while (cursor.next()) {
            if (contents.tr.size() >= maxResultSize) {
                return contents;
            }
            TableContents.Tr tr = new TableContents.Tr();
            Object o = cursor.get();
            if (!this.hasPermissionsFor((TableCursor<? extends BIObject>)cursor, op)) continue;
            tr.id = this.getRowKey(rowType, (TableCursor<? extends BIObject>)cursor, op);
            if (this.scopeRowIds(op)) {
                tr.id = BHxQueryTableView.scopeId((String)tr.id, (HxOp)op);
            }
            tr.icons = this.getRowIcons((TableCursor<? extends BIObject>)cursor, op);
            String className = this.getAdditionalRowClassName((TableCursor<? extends BIObject>)cursor, op);
            for (int k = 0; k < columnSize; ++k) {
                Column c = table.getColumns().get(k);
                String value = cursor.cell(c).toString();
                if (c.getType().equals(BBlob.TYPE)) {
                    value = HxTabUtil.blobDisplay((String)value);
                }
                if (value.equals("<null>")) {
                    value = "";
                }
                TableContents.Td td = new TableContents.Td(value);
                td.additionalClassName = className;
                tr.td.add(td);
            }
            contents.tr.add(tr);
        }
        return contents;
    }

    public static BOrd getBaseOrd(BQuery query, HxOp op) {
        BOrd base = BOrd.make((String)"slot:/");
        if (query.get("base") instanceof BOrd) {
            base = (BOrd)query.get("base");
        }
        BOrd stationOrd = BOrd.make((BOrd)BOrd.make((String)"station:"), (BOrd)base);
        BISession session = ((BComponent)op.get()).getSession();
        if (session != null) {
            return BOrd.make((BOrd)session.getAbsoluteOrd(), (BOrd)stationOrd);
        }
        return stationOrd;
    }

    public static BTypeSpec getRowType(HxOp op) {
        String formValue = op.getFormValue("typeSpec");
        BTypeSpec typeSpec = BTypeSpec.make((String)formValue);
        return typeSpec;
    }

    public BObject getNewSubject(HxOp op) {
        try {
            BQuery query = this.getQuery(op);
            BTypeSpec typeSpec = QueryUtil.getRowType((BQuery)query);
            return typeSpec.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getSubject(HxOp op) {
        return BHxQueryTableView.getSubject(false, op);
    }

    public static Object getSubject(boolean allowMultipleQuery, HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList.length == 1 || allowMultipleQuery && selectionList.length > 0) {
            return BOrd.make((String)("station:|" + selectionList[0])).get();
        }
        if (selectionList.length > 1) {
            throw new IllegalStateException("only one subject allowed");
        }
        return null;
    }

    public static Object[] getSubjects(HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        Object[] objects = new BComplex[selectionList.length];
        for (int i = 0; i < selectionList.length; ++i) {
            BOrd ord = BOrd.make((String)("station:|" + selectionList[i]));
            objects[i] = (BComplex)ord.get();
        }
        return objects;
    }

    public SmartCommand getFilterCommand(HxOp op) {
        return this.filterCommand;
    }

    public class SortCommand
    extends Command {
        public SortCommand(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return "sortCommand";
        }

        public void handle(HxOp op) throws Exception {
            if (((BHxSmartTableView)this.getView()).isEnabled(op)) {
                this.sortByColumn(Integer.parseInt(op.getFormValue("sortBy")), op);
            }
        }

        public void sortByColumn(int newSortCol, HxOp op) throws Exception {
            BQuery query = BHxQueryTableView.this.getQuery(op);
            BQueryTableOptions options = (BQueryTableOptions)BHxQueryTableView.this.getOptionsManager(op).load(BQueryTableOptions.TYPE);
            int sortCol = options.getSortColumnIndex(query);
            options.setSortColumnIndex(query, newSortCol);
            boolean up = options.getSortColumnAscForIndex(query);
            BHxQueryTableView.this.getOptionsManager(op).save((BOptions)options);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"smartTable.sort('").w(newSortCol).w((Object)"','").w((Object)op.scope("")).w((Object)"',").w(up).w((Object)");");
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class RefreshCommand
    extends SmartCommand {
        public RefreshCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "refresh";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isTableCommand(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class RenameSubjectCommand
    extends RenameCommand {
        public RenameSubjectCommand(BHxView view) {
            super(view);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public BComponent getComponent(HxOp op) {
            return (BComponent)BHxQueryTableView.getSubject(op);
        }

        public void completeRename(BComponent renamed, HxOp op) throws Exception {
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class DeleteCommand
    extends SmartCommand {
        private ConfirmDialog dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);

        public DeleteCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void deleteCompleted(HxOp op) throws Exception {
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }

        public void checkDelete(BComponent subject, HxOp op) {
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            Object[] subjects = BHxQueryTableView.getSubjects(op);
            for (int i = 0; i < subjects.length; ++i) {
                BComponent subject = (BComponent)subjects[i];
                this.checkDelete(subject, op);
                Property p = subject.getPropertyInParent();
                if (p.isFrozen()) {
                    throw new IllegalStateException("Cannot Delete Frozen Property");
                }
                BValue value = subject.get(p);
                if (value instanceof BIProtected && !((BIProtected)value).getPermissions((Context)op).hasAdminWrite()) {
                    throw new IllegalStateException("Cannot Delete Readonly Property");
                }
                subject.getParent().asComponent().remove(p, (Context)op);
            }
            this.deleteCompleted(op);
        }
    }

    public class NonDefaultHyperlinkCommand
    extends HyperlinkCommand {
        public NonDefaultHyperlinkCommand(BHxView view) {
            super(view);
        }

        public NonDefaultHyperlinkCommand(BHxView view, Lexicon l) {
            super(view, l);
        }

        @Override
        public boolean isDefaultAction() {
            return false;
        }
    }

    public class HyperlinkCommand
    extends SmartCommand {
        public HyperlinkCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public HyperlinkCommand(BHxView view, Lexicon l) {
            super(view, LexiconModule.make((BModule)l.module));
        }

        public String getName(HxOp op) {
            return "hyperlink";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public BTypeSpec getViewTypeSpec(HxOp op) {
            return null;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            String rowId = selectionList[0];
            if (BHxQueryTableView.this.scopeRowIds(op)) {
                rowId = TextUtil.split((String)rowId, (char)'~')[1];
            }
            BOrd ord = BOrd.make((String)("station:|" + rowId));
            BTypeSpec viewTypeSpec = this.getViewTypeSpec(op);
            if (viewTypeSpec != null) {
                ord = BOrd.make((String)("" + ord.resolve().getOrdWithoutViewQuery() + "|view:" + viewTypeSpec));
            }
            this.redirect(op, op.toUri(ord));
        }
    }

    public static class AddCommand
    extends SmartCommand {
        public AddCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxAddQueryTableView.TYPE))));
        }
    }
}

