/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.job;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxJobTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQuery;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"baja:JobService"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxJobServiceView
extends BHxQueryTableView {
    @Generated
    public static final BHxJobServiceView INSTANCE = new BHxJobServiceView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxJobServiceView.class);
    public SmartCommand details = new DetailsCommand((BHxView)this);
    public SmartCommand showJobLog;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxJobServiceView() {
        this.registerEvent((Event)this.details);
        this.showJobLog = new ShowJobLog((BHxView)this);
        this.registerEvent((Event)this.showJobLog);
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BQuery query = QueryUtil.makeQuery((BTypeSpec)BJob.TYPE.getTypeSpec());
        query.add("base", (BValue)BOrd.make((String)"service:baja:JobService"));
        return QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.filterCommand, this.details, this.showJobLog, this.deleteCommand, this.exportCommand};
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    public boolean defaultAutoRefresh(HxOp op) {
        return true;
    }

    public String getPageTitle(HxOp op) throws Exception {
        return ((BINavNode)op.get()).getNavDisplayName((Context)op);
    }

    @Override
    public BImage getRowIcon(TableCursor<? extends BIObject> cursor, HxOp op) {
        BObject obj;
        Column jobStateCol = cursor.getTable().getColumns().get("jobState");
        if (jobStateCol != null && (obj = (BObject)cursor.cell(jobStateCol)) instanceof BJobState) {
            BJobState state = (BJobState)obj;
            return BHxAbstractJobView.getJobStateImage(state);
        }
        return null;
    }

    public static class ShowJobLog
    extends SmartCommand {
        public ShowJobLog(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showJobLog";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BJob job = (BJob)BHxQueryTableView.getSubject(op);
            BImage image = BHxAbstractJobView.getJobStateImage(job.getJobState());
            HxOp dialogOp = op.make("dialog", (OrdTarget)op);
            dialogOp.mergeFacets(ErrorDialog.forceDetailsFacets);
            new JobLogDialog((Command)this, job).open(dialogOp);
        }
    }

    public static class DetailsCommand
    extends SmartCommand {
        public DetailsCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "summary";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BHxAbstractJobView.openNextJobDialog();
            op.getRequest().getSession().setAttribute("info", BHxQueryTableView.getSubject(op));
            HxOp parentOp = (HxOp)op.getAttribute("parentOp");
            BHxJobTableView.INSTANCE.progressEvent.handle(parentOp);
        }
    }
}

