/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.fieldeditors;

import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"driver:TuningPolicyNameFE"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxTuningPolicyFE
extends BHxFieldEditor {
    @Generated
    public static final BHxTuningPolicyFE INSTANCE = new BHxTuningPolicyFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxTuningPolicyFE.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxTuningPolicyFE() {
    }

    public void write(HxOp op) throws Exception {
        super.write(op);
        this.writeTuningPolicies(op);
    }

    public BObject save(HxOp op) throws Exception {
        return BString.make((String)op.getFormValue("tuningPolicy"));
    }

    private void writeTuningPolicies(HxOp op) throws Exception {
        BTuningPolicy[] policies = this.getTuningPolicies(op);
        String currentPolicy = ((BString)op.get()).getString();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<select name='").w((Object)op.scope("tuningPolicy")).w((Object)"' ");
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        }
        out.w((Object)" >");
        for (int i = 0; i < policies.length; ++i) {
            out.w((Object)"<option ");
            out.attr("value", policies[i].getName());
            if (policies[i].getName().equals(currentPolicy)) {
                out.attr("selected", "selected");
            }
            out.w((Object)">");
            out.safe((Object)policies[i].getDisplayName((Context)op));
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    private BTuningPolicy[] getTuningPolicies(HxOp op) throws Exception {
        BDeviceNetwork network = this.getNetwork(op);
        if (network.get("tuningPolicies") == null) {
            throw new Exception("Tuning policies for network not found");
        }
        return ((BTuningPolicyMap)network.get("tuningPolicies")).getPolicies();
    }

    private BDeviceNetwork getNetwork(HxOp op) throws Exception {
        BComponent component = op.getComponent();
        while (!component.getType().is(BDeviceNetwork.TYPE)) {
            component = component.getParent();
        }
        if (component == null || !component.getType().is(BDeviceNetwork.TYPE)) {
            throw new Exception("Unable to find parent device network");
        }
        return (BDeviceNetwork)component;
    }
}

