/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.HxLocalizableExceptionTranslator;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BAddStationsJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BRemoteConfigJob;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BStationConnectJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationConnectJob.class);
    public boolean sslApprovalNeeded = false;
    public String remoteStation1 = null;
    public String certStationName = null;
    static Lexicon lex = Lexicon.make(BStationConnectJob.class);
    BNiagaraNetwork network;
    String stationName;
    boolean stationEnabled;
    String stationAddress;
    String stationUser;
    BPassword stationPassword;
    BClientCredentials stationUserCred;
    boolean useFoxs;
    int stationPort;
    boolean editExistingStation = false;
    Context context;
    BNiagaraStation remoteStation = null;
    BNiagaraStation[] pingStations = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationConnectJob(BNiagaraNetwork network, String stationName, boolean stationEnabled, String stationAddress, BClientCredentials stationUserCred, boolean useFoxs, int stationPort, boolean editExistingStation, Context context) {
        this.network = network;
        this.stationName = stationName;
        this.stationEnabled = stationEnabled;
        this.stationAddress = stationAddress;
        this.stationUserCred = stationUserCred;
        this.useFoxs = useFoxs;
        this.stationPort = stationPort;
        this.editExistingStation = editExistingStation;
        this.context = context;
    }

    public BStationConnectJob(BNiagaraStation[] pingStations, Context context) {
        this.pingStations = pingStations;
        if (pingStations == null) {
            this.pingStations = new BNiagaraStation[0];
        }
        this.context = context;
    }

    public BStationConnectJob() {
    }

    public boolean isCertApprovalNeeded() {
        return this.sslApprovalNeeded;
    }

    public String getRemoteStation() {
        return this.remoteStation1;
    }

    public String getCertStationName() {
        return this.certStationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.pingStations != null) {
            int len = this.pingStations.length;
            this.log().start("Pinging " + len + " stations");
            if (len > 0) {
                BAddStationsJob.Counter counter = new BAddStationsJob.Counter(len);
                PingStationWork[] workers = new PingStationWork[len];
                for (int i = 0; i < len; ++i) {
                    workers[i] = new PingStationWork(this, this.pingStations[i], counter, this.context);
                    this.pingStations[i].postAsync((Runnable)workers[i]);
                }
                BAddStationsJob.Counter i = counter;
                synchronized (i) {
                    while (counter.count > 0) {
                        counter.wait(20000L);
                    }
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    if (workers[i2].e == null) continue;
                    throw workers[i2].e;
                }
            }
            this.progress(100);
            return;
        }
        this.log().start("Station '" + this.stationName + "' connect");
        if (this.network == null) {
            throw new BajaRuntimeException(lex.getText("stationView.error.noNetwork"));
        }
        this.remoteStation1 = this.stationName;
        String displayStationName = null;
        BNiagaraStation station = (BNiagaraStation)this.network.getNiagaraStation(this.stationName);
        displayStationName = this.stationName;
        if (!this.editExistingStation && station != null) {
            throw new BajaRuntimeException(lex.getText("stationView.error.duplicateStation", new Object[]{this.stationName}));
        }
        if (station == null) {
            station = new BNiagaraStation();
        }
        if (station.getEnabled() != this.stationEnabled) {
            station.set(BNiagaraStation.enabled, (BValue)BBoolean.make((boolean)this.stationEnabled), this.context);
        }
        BOrd host = BOrd.make((String)("ip:" + this.stationAddress));
        if (!station.getAddress().equals((Object)host)) {
            station.set(BNiagaraStation.address, (BValue)host, this.context);
        }
        if (station.getClientConnection().getPort() != this.stationPort) {
            station.getClientConnection().set(BFoxClientConnection.port, (BValue)BInteger.make((int)this.stationPort), this.context);
        }
        if (!station.getClientConnection().getCredentialStore().equals((Object)this.stationUserCred)) {
            station.getClientConnection().set(BFoxClientConnection.credentialStore, (BValue)this.stationUserCred, this.context);
        }
        if (station.getClientConnection().getUseFoxs() != this.useFoxs) {
            station.getClientConnection().set(BFoxClientConnection.useFoxs, (BValue)BBoolean.make((boolean)this.useFoxs), this.context);
        }
        if (!this.editExistingStation) {
            this.network.add(this.stationName, (BValue)station, this.context);
        }
        RemoteUtil.jobSafePing((BNiagaraStation)station);
        if (station.isDisabled()) {
            this.log().failed(lex.getText("stationView.error.disableFailure", new Object[]{this.stationName}));
            throw new BajaRuntimeException(lex.getText("stationView.error.disableFailure", new Object[]{this.stationName}));
        }
        if (this.editExistingStation) {
            this.progress(50);
            BFoxSession remoteSession = null;
            String interest = "SecurityEditRemoteConfig" + System.identityHashCode((Object)this);
            try {
                displayStationName = this.stationName;
                BIpHost host2 = (BIpHost)station.getRemoteHost();
                InetAddress ipAddress = host2.getInetAddress();
                BUsernameAndPassword credentials = (BUsernameAndPassword)station.getClientConnection().getCredentialStore().getCredentials();
                remoteSession = BFoxSession.make((String)this.stationName, (BHost)host2, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
                remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                remoteSession.getConnection().setPort(station.getFoxPort());
                remoteSession.getConnection().setUseFoxs(station.getClientConnection().getUseFoxs());
                remoteSession.getConnection().setAuthenticationClient((AuthenticationClient)station.getClientConnection());
                remoteSession.getConnection().setCheckBrandCompatibility(false);
                RemoteUtil.jobSafeEngageNoRetry((BFoxSession)remoteSession, (String)interest);
                BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                this.remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, Sys.getStation().getStationName(), remoteSession.getConnection().session().isLegacyConnection());
                this.remoteStation.lease(5, 120000L);
                this.remoteStation.getClientConnection().lease(5, 120000L);
            }
            catch (Exception ee) {
                if (ee instanceof FoxAuthenticationException) {
                    this.log().failed(lex.getText("stationView.error.authentication", new Object[]{displayStationName}));
                    throw new AuthenticationException("FoxAuthenticationException: Authentication Failed ");
                }
                if (ee instanceof IOException) {
                    if (ee.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || ee.getClass().getName().equals("javax.net.ssl.SSLException") || ee.getClass().getName().equals("org.bouncycastle.tls.TlsFatalAlert")) {
                        this.sslApprovalNeeded = true;
                        this.certStationName = this.stationName;
                        this.log().failed(lex.getText("stationView.error.certificate", new Object[]{displayStationName}));
                        throw new IOException("SSLHandshakeException: Failed certificate validation ");
                    }
                    if (ee.getMessage().equals("Expected 'f', got '0x15'")) {
                        this.log().failed(lex.getText("stationView.error.foxs", new Object[]{displayStationName}));
                        throw new IOException("Fox/Foxs connection failed..");
                    }
                    if (ee instanceof ConnectException) {
                        this.log().failed(lex.getText("stationView.error.port", new Object[]{displayStationName}));
                        throw new ConnectException("Connection failed..");
                    }
                    if (ee instanceof UnknownHostException) {
                        this.log().failed(lex.getText("stationView.error.HostName", new Object[]{displayStationName}));
                        throw new UnknownHostException("UnknownHostException: Invalid HostName. ");
                    }
                    this.log().failed(lex.getText("stationView.error.connectFailure", new Object[]{displayStationName}), (Throwable)ee);
                    throw new IOException("Cannot connect to the remote station >" + this.stationName + " : " + ee.getMessage());
                }
                this.log().failed(lex.getText("stationView.error.connectFailure", new Object[]{displayStationName}), (Throwable)ee);
                throw new Exception("Cannot connect to the remote station >" + this.stationName + " : " + ee.getMessage());
            }
            finally {
                if (remoteSession != null) {
                    remoteSession.disengage(interest);
                }
                this.progress(100);
            }
        }
    }

    static class PingStationWork
    implements Runnable {
        BStationConnectJob job;
        BAddStationsJob.Counter counter;
        BNiagaraStation station;
        Context cx;
        Exception e = null;

        PingStationWork(BStationConnectJob job, BNiagaraStation station, BAddStationsJob.Counter counter, Context cx) {
            this.job = job;
            this.station = station;
            this.counter = counter;
            this.cx = cx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String stationName = null;
            String displayStationName = null;
            try {
                stationName = this.station.getStationName();
                this.job.log().message("Pinging station '" + stationName + "'...");
                this.station.doInvoke(BNiagaraStation.ping, null, this.cx);
                if (this.station.isDisabled()) {
                    this.job.log().failed(lex.getText("stationView.error.disableFailure", new Object[]{stationName}));
                    this.e = new BajaRuntimeException(lex.getText("stationView.error.disableFailure", new Object[]{stationName}));
                    return;
                }
                if (!this.job.isRunning()) {
                    return;
                }
                BNiagaraSysDefDeviceExt bNiagaraSysDefDeviceExt = (BNiagaraSysDefDeviceExt)this.station.get("sysDef");
                if (!bNiagaraSysDefDeviceExt.getRoleManager().getActualRole().equals((Object)BStationRole.peer)) {
                    bNiagaraSysDefDeviceExt.getRoleManager().doExecute();
                    this.job.log().message("Reverse Pinging back from station '" + stationName + "'...");
                    BFoxSession remoteSession = null;
                    String interest = "SecurityEditRemoteConfig.reverseConnect" + System.identityHashCode(this);
                    try {
                        this.job.remoteStation1 = stationName;
                        displayStationName = stationName;
                        BIpHost host = (BIpHost)this.station.getRemoteHost();
                        BUsernameAndPassword credentials = (BUsernameAndPassword)this.station.getClientConnection().getCredentialStore().getCredentials();
                        remoteSession = BFoxSession.make((String)stationName, (BHost)host, (int)this.station.getFoxPort(), (boolean)this.station.getClientConnection().getUseFoxs());
                        remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                        remoteSession.getConnection().setPort(this.station.getFoxPort());
                        remoteSession.getConnection().setUseFoxs(this.station.getClientConnection().getUseFoxs());
                        remoteSession.getConnection().setCheckBrandCompatibility(false);
                        remoteSession.getConnection().setAuthenticationClient((AuthenticationClient)this.station.getClientConnection());
                        if (!this.job.isRunning()) {
                            return;
                        }
                        remoteSession.engageNoRetry(interest);
                        if (!this.job.isRunning()) {
                            return;
                        }
                        BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                        BNiagaraStation remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, Sys.getStation().getStationName(), remoteSession.getConnection().session().isLegacyConnection());
                        remoteStation.lease();
                        if (!remoteStation.getEnabled()) {
                            throw new BajaRuntimeException(lex.getText("stationView.error.disableFailure", new Object[]{stationName}));
                        }
                        remoteStation.getClientConnection().lease();
                        if (!this.job.isRunning()) {
                            return;
                        }
                        displayStationName = remoteStation.getStationName();
                        remoteStation.getClientConnection().manualDisconnect();
                        remoteStation.getClientConnection().manualConnect();
                        if (this.job.isRunning()) return;
                        return;
                    }
                    catch (Exception ex) {
                        this.displayFailureMessage(ex, "stationView.error.remoteConnectFailure", displayStationName);
                        return;
                    }
                    finally {
                        if (remoteSession != null) {
                            remoteSession.disengage(interest);
                        }
                    }
                }
                this.job.remoteStation1 = this.station.getStationName();
                try {
                    this.station.doPing();
                    this.station.getClientConnection().manualConnect();
                    if (!this.station.isDown()) return;
                    this.job.log().failed(lex.getText("stationView.error.connectFailure", new Object[]{this.station.getStationName()}));
                    this.e = new BajaRuntimeException(lex.getText("stationView.error.connectFailure", new Object[]{this.station.getStationName()}));
                    return;
                }
                catch (Exception e1) {
                    if (e1 instanceof ActionInvokeException) {
                        Exception ee = (Exception)e1.getCause();
                        this.displayFailureMessage(ee, "stationView.error.remoteConnectFailure", this.station.getStationName());
                        return;
                    }
                    this.displayFailureMessage(e1, "stationView.error.remoteConnectFailure", this.station.getStationName());
                    return;
                }
            }
            catch (Exception exception) {
                this.displayFailureMessage(exception, "stationView.error.connectFailure", displayStationName);
                return;
            }
            finally {
                BAddStationsJob.Counter counter = this.counter;
                synchronized (counter) {
                    --this.counter.count;
                    if (this.counter.count < 1) {
                        this.counter.notifyAll();
                    } else {
                        this.job.progress((int)((float)(this.counter.length - this.counter.count) / (float)this.counter.length * 100.0f));
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void displayFailureMessage(Exception ex, String failureMsg, String stationName) {
            if (ex instanceof FoxAuthenticationException || ex instanceof AuthenticationException) {
                this.job.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof ConnectException) {
                this.job.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof UnknownHostException) {
                this.job.log().failed(lex.getText("stationView.error.HostName", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(new UnknownHostException("UnknownHostException: Invalid HostName. "));
                return;
            }
            if (ex instanceof IOException) {
                if (ex.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || ex.getClass().getName().equals("javax.net.ssl.SSLException") || ex.getClass().getName().equals("org.bouncycastle.tls.TlsFatalAlert")) {
                    this.job.sslApprovalNeeded = true;
                    this.job.certStationName = stationName;
                    this.job.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("SSLHandshakeException: Failed certificate validation "));
                    return;
                }
                if (ex.getMessage().equals("Expected 'f', got '0x15'")) {
                    this.job.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: fox/foxs connection failed.. "));
                    return;
                }
                this.job.log().failed(lex.getText(failureMsg));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof ActionInvokeException) {
                Throwable tExcep = ex.getCause();
                if (tExcep != null) {
                    if (tExcep.getMessage().indexOf("SSLHandshakeException") > -1) {
                        this.job.sslApprovalNeeded = true;
                        this.job.certStationName = stationName;
                        this.job.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize(new IOException("SSLHandshakeException: Failed certificate validation "));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("FoxAuthenticationException") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize((Exception)new FoxAuthenticationException("Authentication failed", null));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("Expected 'f', got '0x15'") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: fox/foxs connection failed.. "));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("java.net.ConnectException") <= -1) return;
                    this.job.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: Invalid Port "));
                    return;
                }
                this.job.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            this.job.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
            this.e = HxLocalizableExceptionTranslator.localize((Exception)((Object)new BajaRuntimeException("Failed")));
        }
    }
}

