/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridiumx.entsecHx.securityUtilHx.HxLocalizableExceptionTranslator;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.baja.job.BSimpleJob;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BPassword;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BAddStationsJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BAddStationsJob.class);
    public boolean sslApprovalNeeded = false;
    public String remoteStation = null;
    public String certStationName = null;
    static Lexicon lex = Lexicon.make(BAddStationsJob.class);
    BNiagaraNetwork network;
    BLearnStation[] addStations;
    boolean stationEnabled;
    BClientCredentials stationCred;
    String stationUser;
    BPassword stationPassword;
    boolean useFoxs;
    int foxPort;
    BClientCredentials remoteCred;
    boolean remoteUseFoxs;
    String remoteUser;
    BPassword remotePassword;
    int remoteFoxPort;
    boolean remoteStationEnabled;
    BStationRole stationRole;
    String interest;
    Context context;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAddStationsJob(BNiagaraNetwork network, BLearnStation[] addStations, boolean stationEnabled, BClientCredentials stationCred, boolean useFoxs, int foxPort, boolean remoteStationEnabled, BClientCredentials remoteCred, boolean remoteUseFoxs, int remoteFoxPort, BStationRole stationRole, Context context) {
        this.network = network;
        this.addStations = addStations;
        this.stationEnabled = stationEnabled;
        this.stationCred = stationCred;
        this.useFoxs = useFoxs;
        this.foxPort = foxPort;
        this.remoteCred = remoteCred;
        this.remoteUseFoxs = remoteUseFoxs;
        this.remoteFoxPort = remoteFoxPort;
        this.remoteStationEnabled = remoteStationEnabled;
        this.stationRole = stationRole;
        this.interest = "SecurityAddDiscoveredStations" + System.identityHashCode((Object)this);
        this.context = context;
    }

    public BAddStationsJob() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new BajaRuntimeException(lex.getText("stationView.error.noNetwork"));
        }
        int len = this.addStations != null ? this.addStations.length : 0;
        this.log().start("Adding/Configuring " + len + " stations");
        if (len > 0) {
            Counter counter = new Counter(len);
            AddStationWork[] workers = new AddStationWork[len];
            for (int i = 0; i < len; ++i) {
                workers[i] = new AddStationWork(this, this.addStations[i], counter, this.context);
                this.network.getWorkers().process((Object)workers[i]);
            }
            Counter i = counter;
            synchronized (i) {
                while (counter.count > 0) {
                    counter.wait(20000L);
                }
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if (workers[i2].e == null) continue;
                throw workers[i2].e;
            }
        }
        this.progress(100);
    }

    public boolean isCertApprovalNeeded() {
        return this.sslApprovalNeeded;
    }

    public String getRemoteStation() {
        return this.remoteStation;
    }

    public String getCertStationName() {
        return this.certStationName;
    }

    static class Counter {
        int count = 0;
        int length = 1;

        Counter(int count) {
            this.length = count > 0 ? count : 1;
            this.count = count;
        }
    }

    static class AddStationWork
    implements Runnable {
        BAddStationsJob job;
        Counter counter;
        BLearnStation addStation;
        Context cx;
        Exception e = null;

        AddStationWork(BAddStationsJob job, BLearnStation addStation, Counter counter, Context cx) {
            this.job = job;
            this.addStation = addStation;
            this.counter = counter;
            this.cx = cx;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[TRYBLOCK]], but top level block is 75[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void displayFailureMessage(Exception ex, String failureMsg, String stationName) {
            if (ex instanceof FoxAuthenticationException || ex instanceof AuthenticationException) {
                this.job.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof ConnectException) {
                this.job.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof UnknownHostException) {
                this.job.log().failed(lex.getText("stationView.error.HostName", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(new UnknownHostException("UnknownHostException: Invalid HostName. "));
                return;
            }
            if (ex instanceof IOException) {
                if (ex.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || ex.getClass().getName().equals("javax.net.ssl.SSLException") || ex.getClass().getName().equals("org.bouncycastle.tls.TlsFatalAlert")) {
                    this.job.sslApprovalNeeded = true;
                    this.job.certStationName = stationName;
                    this.job.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("SSLHandshakeException: Failed certificate validation "));
                    return;
                }
                if (ex.getMessage().equals("Expected 'f', got '0x15'")) {
                    this.job.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: fox/foxs connection failed.. "));
                    return;
                }
                this.job.log().failed(lex.getText(failureMsg));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof ActionInvokeException) {
                Throwable tExcep = ex.getCause();
                if (tExcep != null) {
                    if (tExcep.getMessage().indexOf("SSLHandshakeException") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                        this.job.sslApprovalNeeded = true;
                        this.job.certStationName = stationName;
                        this.e = HxLocalizableExceptionTranslator.localize(new IOException("SSLHandshakeException: Failed certificate validation "));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("FoxAuthenticationException") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize((Exception)new FoxAuthenticationException("Authentication failed", null));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("Expected 'f', got '0x15'") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: fox/foxs connection failed.. "));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("java.net.ConnectException") <= -1) return;
                    this.job.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: Invalid Port "));
                    return;
                }
                this.job.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            this.job.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
            this.e = HxLocalizableExceptionTranslator.localize((Exception)((Object)new BajaRuntimeException("Failed")));
        }
    }
}

