/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridiumx.entsec.securityUtil.alarm.BLayoutOptions;
import com.tridiumx.entsec.securityUtil.alarm.BSecurityAlarmConsoleOptions;
import com.tridiumx.entsec.securityUtil.alarm.BVideoAlarmAckOptions;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BLiveAlarmConsolePopupProfile;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BSecurityAlarmConsole;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.view.BWbComponentView;

public abstract class LayoutController {
    public static final int ALARM = 1;
    public static final int INSTR = 2;
    public static final int LIVE = 4;
    public static final int PLAYBACK = 8;

    public static LayoutController make(BSecurityAlarmConsole console) {
        return new ConcreteController(console);
    }

    public abstract void makeLayout(BLayoutOptions var1);

    public abstract void makeLayout(int var1, BOrientation var2, BOrientation var3, BOrientation var4);

    public abstract void setVideoPlayback(BVideoPlayback var1);

    private static class ConcreteController
    extends LayoutController {
        private BWidget consoleWidget;
        private BWidget instructionsWidget;
        private BWidget liveVideoWidget;
        private BWidget videoPlaybackWidget;
        private BLiveVideo liveVideo = new BLiveVideo();
        private BVideoPlayback videoPlayback = new BVideoPlayback("", BAbsTime.DEFAULT, false);
        private BConstrainedPane liveConstrainedPane;
        private BConstrainedPane playbackConstrainedPane;
        private boolean alarm;
        private boolean instr;
        private boolean live;
        private boolean playback;
        private BSecurityAlarmConsole console;
        private SourceTableModel model;
        private BOrientation vertical = BOrientation.vertical;
        private BOrientation horizontal = BOrientation.horizontal;
        private Dimension _800_x_600 = new Dimension(800, 600);
        private Dimension _1024_x_768 = new Dimension(1024, 768);
        private Dimension _1152_x_864 = new Dimension(1152, 864);
        private Dimension _1280_x_1024 = new Dimension(1280, 1024);
        private Lexicon lex = Lexicon.make(this.getClass());
        private Object monitor = new Object();
        BLayoutOptions lastLayout;

        public ConcreteController(BSecurityAlarmConsole console) {
            this.console = console;
            this.model = console.getModel();
        }

        @Override
        public synchronized void makeLayout(int flags, BOrientation orientation1, BOrientation orientation2, BOrientation orientation3) {
            this.alarm = ConcreteController.hasConsole(flags);
            this.consoleWidget = this.alarm ? this.getAlarmWidget() : new BNullWidget();
            this.instr = ConcreteController.hasInstructions(flags);
            this.instructionsWidget = this.instr ? this.getInstructionsWidget() : new BNullWidget();
            this.live = ConcreteController.hasLiveView(flags);
            this.liveVideoWidget = this.live ? this.getLiveViewWidget() : new BNullWidget();
            this.playback = ConcreteController.hasPlaybackView(flags);
            this.videoPlaybackWidget = this.playback ? this.getPlaybackViewWidget() : new BNullWidget();
            BWidget alarmPane = null;
            BWidget videoPane = null;
            if (this.alarm || this.instr) {
                alarmPane = this.makeAlarmPane(this.alarm, this.instr, orientation1);
            }
            if (this.live || this.playback) {
                videoPane = this.makeVideoPane(this.live, this.playback, orientation2);
            }
            BSplitPane splitPane = null;
            if (alarmPane != null && videoPane != null) {
                splitPane = new BSplitPane(alarmPane, videoPane);
                splitPane.setOrientation(orientation3);
            }
            this.console.setContent((BWidget)new BNullWidget());
            this.console.setContent((BWidget)(splitPane != null ? splitPane : (alarmPane != null ? alarmPane : (videoPane != null ? videoPane : new BNullWidget()))));
            if (splitPane != null) {
                BWbProfile profile = this.console.getWbShell().getProfile();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (profile instanceof BLiveAlarmConsolePopupProfile) {
                    if (screenSize.equals(this._800_x_600)) {
                        splitPane.setDividerPosition(45.0);
                    } else if (screenSize.equals(this._1024_x_768)) {
                        splitPane.setDividerPosition(35.0);
                    } else if (screenSize.equals(this._1152_x_864)) {
                        splitPane.setDividerPosition(30.0);
                    } else if (screenSize.equals(this._1280_x_1024)) {
                        splitPane.setDividerPosition(25.0);
                    } else {
                        splitPane.setDividerPosition(50.0);
                    }
                } else if (screenSize.equals(this._800_x_600)) {
                    splitPane.setDividerPosition(65.0);
                } else if (screenSize.equals(this._1024_x_768)) {
                    splitPane.setDividerPosition(45.0);
                } else if (screenSize.equals(this._1152_x_864)) {
                    splitPane.setDividerPosition(40.0);
                } else if (screenSize.equals(this._1280_x_1024)) {
                    splitPane.setDividerPosition(30.0);
                } else {
                    splitPane.setDividerPosition(50.0);
                }
            }
            if (videoPane != null && this.live && this.playback) {
                BSplitPane sp = (BSplitPane)((BEdgePane)videoPane).getCenter();
                sp.relayoutSync();
            }
            this.console.relayoutSync();
        }

        @Override
        public synchronized void makeLayout(BLayoutOptions layout) {
            if (this.lastLayout == null) {
                this.lastLayout = layout;
            } else if (this.lastLayout.equals((Object)layout)) {
                return;
            }
            BSecurityAlarmConsoleOptions options = this.console.getSecurityAlarmConsoleOptions();
            options.lease();
            int flags = 0;
            boolean alarm = false;
            boolean instructions = false;
            boolean live = false;
            boolean playback = false;
            if (options.getEnableVideoSettings()) {
                String tag = layout.getTag().toLowerCase();
                alarm = tag.indexOf("console") > -1;
                instructions = tag.indexOf("instructions") > -1;
                live = tag.indexOf("live") > -1;
                boolean bl = playback = tag.indexOf("playback") > -1;
                if (alarm) {
                    flags |= 1;
                }
                if (instructions) {
                    flags |= 2;
                }
                if (live) {
                    flags |= 4;
                }
                if (playback) {
                    flags |= 8;
                }
            } else {
                flags |= 1;
                alarm = true;
                if (options.getShowInstructions()) {
                    instructions = true;
                    flags |= 2;
                }
            }
            if (alarm && instructions && !live && !playback) {
                this.makeLayout(flags, this.vertical, this.horizontal, this.vertical);
            } else {
                this.makeLayout(flags, this.horizontal, this.horizontal, this.vertical);
            }
        }

        private synchronized BWidget makeAlarmPane(boolean alarmConsole, boolean instructions, BOrientation orientation) {
            if (alarmConsole && !instructions) {
                return this.consoleWidget;
            }
            if (!alarmConsole && instructions) {
                return this.instructionsWidget;
            }
            if (alarmConsole && instructions) {
                BSplitPane splitPane = new BSplitPane(this.consoleWidget, this.instructionsWidget);
                splitPane.setOrientation(orientation);
                return splitPane;
            }
            return new BNullWidget();
        }

        private synchronized BWidget makeVideoPane(boolean live, boolean playback, BOrientation orientation) {
            BEdgePane videoPane = new BEdgePane();
            if (this.alarm) {
                videoPane.setBottom(this.makeVideoToolbar());
            }
            if (live && !playback) {
                videoPane.setCenter(this.liveVideoWidget);
                return videoPane;
            }
            if (!live && playback) {
                videoPane.setCenter(this.videoPlaybackWidget);
                return videoPane;
            }
            if (live && playback) {
                videoPane.setCenter(this.makeVideoSplitPane(orientation));
                return videoPane;
            }
            return new BNullWidget();
        }

        private BWidget makeVideoToolbar() {
            BButtonPane commands = new BButtonPane();
            commands.add((Command)new PreviousVideoCmd((BWidget)commands, this.lex.getText("consoleLayoutController.previousVideoBtn.label")));
            commands.add((Command)new NextVideoCmd((BWidget)commands, this.lex.getText("consoleLayoutController.nextVideoBtn.label")));
            commands.add((Command)new MostRecentVideoCmd((BWidget)commands, this.lex.getText("consoleLayoutController.mostRecentVideoBtn.label")));
            AcknowledgeCmd acknowledge = new AcknowledgeCmd((BWidget)commands, this.lex.getText("consoleLayoutController.acknowledgeBtn.label"));
            commands.add((Command)acknowledge);
            if (!this.console.hasPermissions()) {
                acknowledge.setEnabled(false);
            }
            BBorderPane borderPane = new BBorderPane((BWidget)commands, BInsets.make((double)4.0));
            return borderPane;
        }

        private synchronized BWidget makeVideoSplitPane(BOrientation orientation) {
            BSplitPane splitPane = new BSplitPane(this.liveVideoWidget, this.videoPlaybackWidget);
            splitPane.setOrientation(orientation);
            return splitPane;
        }

        @Override
        public synchronized void setVideoPlayback(BVideoPlayback videoPlayback) {
            if (this.videoPlaybackWidget == null) {
                return;
            }
            BWidget parent = this.videoPlaybackWidget.getParentWidget();
            this.videoPlaybackWidget = this.makeVideoPlaybackView(videoPlayback);
            if (parent.getType().is(BEdgePane.TYPE)) {
                BEdgePane pane = (BEdgePane)parent;
                pane.setCenter((BWidget)new BNullWidget());
                pane.setCenter(this.videoPlaybackWidget);
            } else if (parent.getType().is(BSplitPane.TYPE)) {
                BSplitPane pane = (BSplitPane)parent;
                pane.setWidget2((BWidget)new BNullWidget());
                pane.setWidget2(this.videoPlaybackWidget);
            } else if (parent.getType().is(BWbComponentView.TYPE)) {
                BWbComponentView view = (BWbComponentView)parent;
                view.setContent((BWidget)new BNullWidget());
                view.setContent(this.videoPlaybackWidget);
            }
        }

        private synchronized BWidget getAlarmWidget() {
            BWidget alarmWidget = this.console.getAlarmPane();
            if (this.console.getDefaultOptions().getViewInstructions()) {
                BSplitPane splitPane = (BSplitPane)alarmWidget.getParent();
                if (splitPane != null) {
                    splitPane.setWidget1((BWidget)new BNullWidget());
                }
            } else {
                BWbPlugin plugin = (BWbPlugin)alarmWidget.getParent();
                plugin.setContent((BWidget)new BNullWidget());
            }
            return alarmWidget;
        }

        private synchronized BWidget getInstructionsWidget() {
            BWidget instructionswidget = this.console.getInstuctionsPane();
            if (this.console.getDefaultOptions().getViewInstructions()) {
                BSplitPane splitPane = (BSplitPane)instructionswidget.getParent();
                if (splitPane != null) {
                    splitPane.setWidget2((BWidget)new BNullWidget());
                }
                return instructionswidget;
            }
            return new BLabel(this.lex.getText("consoleLayoutController.viewingInstructionsDisabled.message"));
        }

        private BWidget getLiveViewWidget() {
            return this.makeLiveVideoView();
        }

        private BWidget getPlaybackViewWidget() {
            return this.makeVideoPlaybackView();
        }

        private synchronized BWidget makeLiveVideoView() {
            this.liveConstrainedPane = new BConstrainedPane((BWidget)this.liveVideo);
            this.console.liveVideo = this.liveVideo;
            return new BTitlePane(this.lex.getText("consoleLayoutController.liveVideoPane.label"), (BWidget)this.liveConstrainedPane);
        }

        private synchronized BWidget makeVideoPlaybackView() {
            this.playbackConstrainedPane = new BConstrainedPane((BWidget)this.videoPlayback);
            return new BTitlePane(this.lex.getText("consoleLayoutController.videoPlaybackPane.label"), (BWidget)this.playbackConstrainedPane);
        }

        private synchronized BWidget makeVideoPlaybackView(BVideoPlayback videoPlayback) {
            this.videoPlayback = videoPlayback;
            BConstrainedPane content = new BConstrainedPane((BWidget)this.videoPlayback);
            return new BTitlePane(this.lex.getText("consoleLayoutController.videoPlaybackPane.label"), (BWidget)content);
        }

        private static boolean hasConsole(int flags) {
            return (flags & 1) == 1;
        }

        private static boolean hasInstructions(int flags) {
            return (flags & 2) == 2;
        }

        private static boolean hasLiveView(int flags) {
            return (flags & 4) == 4;
        }

        private static boolean hasPlaybackView(int flags) {
            return (flags & 8) == 8;
        }

        private class AcknowledgeCmd
        extends Command {
            public AcknowledgeCmd(BWidget owner, String label) {
                super(owner, label);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CommandArtifact doInvoke() throws Exception {
                Object object = ConcreteController.this.monitor;
                synchronized (object) {
                    if (ConcreteController.this.model.getSelection().isEmpty()) {
                        return super.doInvoke();
                    }
                    int selectedRow = ConcreteController.this.model.getSelection().getRow();
                    if (selectedRow == -1) {
                        return super.doInvoke();
                    }
                    int alarmCount = 0;
                    try {
                        alarmCount = ConcreteController.this.model.getRecordCount(selectedRow);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Array alarms = new Array(BAlarmRecord.class);
                    for (int i = 0; i < alarmCount; ++i) {
                        alarms.add((Object)ConcreteController.this.model.getRecordAt(selectedRow, i));
                    }
                    ConcreteController.this.console.acknowledgeAlarms((BAlarmRecord[])alarms.trim());
                    if (ConcreteController.this.console.getSecurityAlarmConsoleOptions().getActionOnVideoAcknowledgement().equals((Object)BVideoAlarmAckOptions.loadNewestAlarm)) {
                        ConcreteController.this.console.selectAndLoadNewestAlarm();
                    }
                    return super.doInvoke();
                }
            }

            public BImage getIcon() {
                return BImage.make((String)"module://icons/x16/alarm/alarmAck.png");
            }
        }

        private class MostRecentVideoCmd
        extends Command {
            public MostRecentVideoCmd(BWidget owner, String label) {
                super(owner, label);
            }

            public CommandArtifact doInvoke() throws Exception {
                ConcreteController.this.console.selectAndLoadNewestAlarm();
                return super.doInvoke();
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"video.png"), (BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/badges/alarm.png"))));
            }
        }

        private class NextVideoCmd
        extends Command {
            public NextVideoCmd(BWidget owner, String label) {
                super(owner, label);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CommandArtifact doInvoke() throws Exception {
                Object object = ConcreteController.this.monitor;
                synchronized (object) {
                    int currentRow = ConcreteController.this.model.getSelection().getRow();
                    if (currentRow == ConcreteController.this.model.getRowCount() - 1 || currentRow == -1) {
                        return super.doInvoke();
                    }
                    int nextRow = currentRow + 1;
                    ConcreteController.this.model.getSelection().deselect(currentRow);
                    ConcreteController.this.model.getSelection().select(nextRow);
                    ConcreteController.this.console.loadVideoPanes(ConcreteController.this.console.getNextAlarm(true, true));
                    return super.doInvoke();
                }
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.std((String)"arrowDown.png"));
            }
        }

        private class PreviousVideoCmd
        extends Command {
            public PreviousVideoCmd(BWidget owner, String label) {
                super(owner, label);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CommandArtifact doInvoke() throws Exception {
                Object object = ConcreteController.this.monitor;
                synchronized (object) {
                    int currentRow = ConcreteController.this.model.getSelection().getRow();
                    if (currentRow < 1) {
                        return super.doInvoke();
                    }
                    int previousRow = currentRow - 1;
                    ConcreteController.this.model.getSelection().deselect(currentRow);
                    ConcreteController.this.model.getSelection().select(previousRow);
                    ConcreteController.this.console.loadVideoPanes(ConcreteController.this.console.getNextAlarm(true, true));
                    return super.doInvoke();
                }
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.std((String)"arrowUp.png"));
            }
        }
    }
}

