/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.ui.alarm.BAlarmConsoleVideoPlayerDialog;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridiumx.entsec.securityUtil.alarm.BSecurityAlarmConsoleOptions;
import com.tridiumx.entsec.securityUtil.alarm.BVideoViewingOptions;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BSecAlarmDetailsDialog;
import com.tridiumx.entsecHx.securityUtilHx.alarm.LayoutController;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"alarm:ConsoleRecipient"}, app="entsec", requiredPermissions="rR")})
public class BSecurityAlarmConsole
extends BAlarmConsole {
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityAlarmConsole.class);
    int lastRow = -1;
    LayoutController controller;
    BLiveVideo liveVideo;
    BVideoPlayback videoPlayback;
    Command showRecurringCommand;
    BFont font = BFont.make((String)"Arial", (double)14.0, (int)1);
    private Object monitor = new Object();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        super.deactivated();
        BSecurityAlarmConsole.deactivateView((BWbView)this.liveVideo);
        BSecurityAlarmConsole.deactivateView((BWbView)this.videoPlayback);
    }

    private static void deactivateView(BWbView view) {
        if (view == null) {
            return;
        }
        view.fw(402);
        view.deactivated();
    }

    public BAlarmConsoleOptions getDefaultOptions() {
        BAlarmConsoleOptions options = null;
        try {
            BSecurityAlarmConsoleOptions ac = this.getSecurityAlarmConsoleOptions();
            ac.lease();
            options = super.getDefaultOptions();
            options.setNotesRequiredOnAck(ac.getNotesRequiredOnAck());
            options.setViewInstructions(ac.getShowInstructions());
            options.setTimeZoneDisplay(ac.getUseSourceTimezone() ? BTimeZoneDisplay.source : BTimeZoneDisplay.console);
        }
        catch (Exception e) {
            options = super.getDefaultOptions();
        }
        try {
            if (options.getAlarmDataCols().get("badge") == null) {
                options.getAlarmDataCols().add("badge", (BValue)BString.make((String)"badge"));
            }
            Object[] alarmDataCols = options.getAlarmDataCols().getChildren(BString.class);
            int msgTextCol = 14;
            int badgeIdCol = 15;
            for (int i = 0; i < alarmDataCols.length; ++i) {
                if (alarmDataCols[i].toString().equals("badge")) {
                    badgeIdCol = i + 14;
                    continue;
                }
                if (!alarmDataCols[i].toString().equals("msgText")) continue;
                msgTextCol = i + 14;
            }
            options.setDisplayColumns("0,2,3,5,6,7,8,10," + msgTextCol + "," + badgeIdCol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    public BSecurityAlarmConsoleOptions getSecurityAlarmConsoleOptions() {
        BFoxSession session = (BFoxSession)this.getCurrentValueSession();
        BFoxClientConnection conn = session.getConnection();
        String userName = conn.getUsername();
        BUserService userSvc = (BUserService)BOrd.make((String)"service:baja:UserService").get(this.getCurrentValue());
        userSvc.lease();
        BUser user = (BUser)userSvc.get(userName);
        user.lease();
        BSecurityAlarmConsoleOptions ac = (BSecurityAlarmConsoleOptions)user.get("entsec_SecurityAlarmConsoleOptions");
        return ac;
    }

    BWidget getAlarmPane() {
        if (this.getDefaultOptions().getViewInstructions()) {
            return ((BSplitPane)this.getContent()).getWidget1();
        }
        return this.getContent();
    }

    BWidget getInstuctionsPane() {
        if (this.getDefaultOptions().getViewInstructions()) {
            return ((BSplitPane)this.getContent()).getWidget2();
        }
        return new BNullWidget();
    }

    SourceTableModel getModel() {
        return this.sourceModel;
    }

    boolean hasPermissions() {
        return this.getAlarmService().getPermissions(this.ctx).hasAdminWrite();
    }

    protected BAlarmConsole.Controller getController() {
        return new SecurityController();
    }

    public BGridPane makeToolBar() {
        BGridPane toolbar = super.makeToolBar();
        BButton button = (BButton)toolbar.get("hyp");
        this.showRecurringCommand = new ShowRecurringCmd((BWidget)button, this.getLexicon().getText("showRecurring.label"));
        button.setCommand(this.showRecurringCommand, true, true);
        button.setEnabled(false);
        return toolbar;
    }

    public void showDetailsDialog(BTable sourceTable, int row) {
        ConsoleTableModel tm = (ConsoleTableModel)((DynamicTableModel)sourceTable.getModel()).getRootModel();
        BAlarmRecord alarm = tm.getRecord(row);
        this.detailsDlg = new BSecAlarmDetailsDialog(this, alarm);
        this.detailsDlg.setBoundsCenteredOnOwner();
        this.detailsDlg.open();
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        super.doLoadValue(value, cx);
        try {
            this.performLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadComplete() {
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions();
        options.lease();
        if (options.getEnableVideoSettings() && this.hasVideoViews()) {
            this.selectAndLoadNewestAlarm();
        }
        super.loadComplete();
    }

    private synchronized void performLayout() {
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions();
        options.lease();
        if (this.controller == null) {
            this.controller = LayoutController.make(this);
        }
        this.controller.makeLayout(options.getLayout());
    }

    private boolean hasVideoViews() {
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions();
        options.lease();
        String tag = options.getLayout().getTag().toLowerCase();
        return tag.indexOf("live") > -1 || tag.indexOf("playback") > -1;
    }

    private boolean hasLiveView() {
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions();
        options.lease();
        String tag = options.getLayout().getTag().toLowerCase();
        return tag.indexOf("live") > -1;
    }

    private boolean hasVideoPlaybackView() {
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions();
        options.lease();
        String tag = options.getLayout().getTag().toLowerCase();
        return tag.indexOf("playback") > -1;
    }

    public void doProcessAlarm(BAlarmRecord alarm) {
        super.doProcessAlarm(alarm);
        BSecurityAlarmConsoleOptions options = this.getSecurityAlarmConsoleOptions();
        options.lease();
        if (!options.getEnableVideoSettings() || !this.hasVideoViews() || alarm.isNormal() || alarm.isAcknowledged() || alarm.isAckPending()) {
            return;
        }
        BVideoViewingOptions newVideoAlarmAction = options.getActionOnNewAlarm();
        if (newVideoAlarmAction.equals((Object)BVideoViewingOptions.loadNewestAlarm)) {
            this.selectAndLoadNewestAlarm();
        }
    }

    public synchronized void loadVideoPanes(BAlarmRecord record) {
        if (!this.hasVideoViews()) {
            return;
        }
        if (record == null) {
            record = new BAlarmRecord();
        }
        final BAlarmRecord alarm = record;
        Thread liveThread = new Thread(){

            @Override
            public void run() {
                BSecurityAlarmConsole.this.loadLiveVideo(alarm);
            }
        };
        Thread playbackThread = new Thread(){

            @Override
            public void run() {
                BSecurityAlarmConsole.this.loadVideoPlayback(alarm);
            }
        };
        if (this.hasLiveView()) {
            liveThread.start();
        }
        if (this.hasVideoPlaybackView()) {
            playbackThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLiveVideo(BAlarmRecord alarm) {
        BSecurityAlarmConsole.deactivateView((BWbView)this.liveVideo);
        BLiveVideo bLiveVideo = this.liveVideo;
        synchronized (bLiveVideo) {
            if (this.isVideoAlarm(alarm)) {
                BComponent camera = this.getCameraForAlarm(alarm);
                if (camera == null) {
                    this.liveVideo.setContent((BWidget)new BLabel(this.getLexicon().getText("secAlarmConsole.errorResolvingCamera"), this.font));
                } else {
                    camera.lease();
                    if (this.hasAgent(camera, BLiveVideo.TYPE)) {
                        this.liveVideo.loadValue((BObject)camera);
                    } else {
                        this.liveVideo.setContent((BWidget)new BLabel(this.getLexicon().getText("secAlarmConsole.liveVideoUnsupported"), this.font));
                    }
                }
            } else {
                this.liveVideo.setContent((BWidget)new BLabel(this.getLexicon().getText("secAlarmConsole.noVideoAvailable"), this.font));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVideoPlayback(BAlarmRecord alarm) {
        BSecurityAlarmConsole.deactivateView((BWbView)this.videoPlayback);
        BVideoPlayback bVideoPlayback = this.videoPlayback = new BVideoPlayback();
        synchronized (bVideoPlayback) {
            if (this.isVideoAlarm(alarm)) {
                BComponent camera = this.getCameraForAlarm(alarm);
                if (camera == null) {
                    this.videoPlayback.setContent((BWidget)new BLabel(this.getLexicon().getText("secAlarmConsole.errorResolvingCamera"), this.font));
                    this.controller.setVideoPlayback(this.videoPlayback);
                } else {
                    camera.lease();
                    if (this.hasAgent(camera, BVideoPlayback.TYPE)) {
                        BAbsTime alarmTime = (BAbsTime)alarm.getAlarmData().get("videoEventTimestamp");
                        String alarmSummary = this.toSummaryString(alarm, alarmTime);
                        if (alarmTime == null || alarmTime.isNull()) {
                            alarmTime = alarm.getTimestamp();
                            alarmSummary = VideoDriverLexicon.LEX.getText("AlarmRecallTimeApproximate", new Object[]{alarmSummary});
                        }
                        this.videoPlayback = new BVideoPlayback(alarmSummary, alarmTime, false);
                        this.controller.setVideoPlayback(this.videoPlayback);
                        BAlarmConsoleVideoPlayerDialog.hookViewToCamera((BObject)camera, (BAlarmRecord)alarm, (BVideoPlayback)this.videoPlayback);
                    } else {
                        this.videoPlayback.setContent((BWidget)new BLabel(this.getLexicon().getText("secAlarmConsole.videoPlaybackUnsupported"), this.font));
                        this.controller.setVideoPlayback(this.videoPlayback);
                    }
                }
            } else {
                this.videoPlayback.setContent((BWidget)new BLabel(this.getLexicon().getText("secAlarmConsole.noVideoAvailable"), this.font));
                this.controller.setVideoPlayback(this.videoPlayback);
            }
        }
    }

    protected String toSummaryString(BAlarmRecord record, BAbsTime alarmTime) {
        StringBuffer s = new StringBuffer(record.getAlarmData().gets("msgText", ""));
        if (s.toString().trim().length() > 0) {
            s.append(" <-> ");
        }
        if (alarmTime == null) {
            s.append(record.getTimestamp().toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        } else {
            s.append(alarmTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        }
        s.append(": (").append(record.getAckState()).append(':').append(record.getSourceState()).append(") ");
        return s.toString();
    }

    private boolean isVideoAlarm(BAlarmRecord alarm) {
        try {
            BOrd cameraOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)this.getCurrentValue(), (BAlarmRecord)alarm);
            return cameraOrd != null && !cameraOrd.isNull();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private BComponent getCameraForAlarm(BAlarmRecord alarm) {
        try {
            BOrd cameraOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)this.getCurrentValue(), (BAlarmRecord)alarm);
            if (cameraOrd != null && !cameraOrd.isNull()) {
                BComponent camera = cameraOrd.get(this.getCurrentValue()).asComponent();
                return camera;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean hasAgent(BComponent component, Type agentType) {
        AgentList agents = component.getAgents();
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(agentType)) continue;
            return true;
        }
        return false;
    }

    public synchronized BAlarmRecord getNextAlarm(boolean useSelectedRow, boolean mostRecentAlarm) {
        if (useSelectedRow) {
            return this.getNextAlarmForRow(this.sourceModel.getSelection().getRow());
        }
        return this.getNextAlarm(mostRecentAlarm);
    }

    private synchronized BAlarmRecord getNextAlarm(boolean mostRecentAlarm) {
        BAbsTime timestamp = null;
        timestamp = mostRecentAlarm ? BAbsTime.DEFAULT : BAbsTime.END_OF_TIME;
        BAlarmRecord record = new BAlarmRecord();
        int row = this.sourceModel.getRowCount();
        for (int i = 0; i < row; ++i) {
            BAlarmRecord alarm = this.sourceModel.getRecord(i);
            if (mostRecentAlarm) {
                if (!alarm.isOpen() && alarm.isAcknowledged() || !alarm.getTimestamp().isAfter(timestamp) || alarm.getPriority() < record.getPriority()) continue;
                record = alarm;
                timestamp = alarm.getTimestamp();
                continue;
            }
            if (!alarm.isOpen() && alarm.isAcknowledged() || !alarm.getTimestamp().isBefore(timestamp) || alarm.getPriority() < record.getPriority()) continue;
            record = alarm;
            timestamp = alarm.getTimestamp();
        }
        return record;
    }

    private synchronized BAlarmRecord getNextAlarmForRow(int selectedRow) {
        if (selectedRow == -1) {
            return this.getNextAlarm(true);
        }
        int recordCount = 0;
        try {
            recordCount = this.sourceModel.getRecordCount(selectedRow);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < recordCount; ++i) {
            BAlarmRecord alarm = this.sourceModel.getRecordAt(selectedRow, i);
            if (!alarm.isOpen() && alarm.isAcknowledged()) continue;
            return alarm;
        }
        return this.getNextAlarm(true);
    }

    synchronized void selectAndLoadNewestAlarm() {
        this.sourceModel.getSelection().deselectAll();
        BAlarmRecord alarm = this.getNextAlarm(true);
        int alarmSourceCount = this.sourceModel.getRowCount();
        block0: for (int i = 0; i < alarmSourceCount; ++i) {
            int recordCountPerSource = this.sourceModel.getRecordCount(i);
            for (int j = 0; j < recordCountPerSource; ++j) {
                BAlarmRecord record = this.sourceModel.getRecordAt(i, j);
                if (!record.getUuid().equals((Object)alarm.getUuid())) continue;
                this.sourceModel.getSelection().select(i);
                this.lastRow = i;
                continue block0;
            }
        }
        this.loadVideoPanes(alarm);
    }

    public static boolean isVideoDriverAvailable() {
        BModule videoDriverModule = null;
        try {
            videoDriverModule = Sys.loadModule((String)"videoDriver");
        }
        catch (ModuleNotFoundException e) {
            videoDriverModule = null;
        }
        catch (ModuleException e) {
            videoDriverModule = null;
        }
        return videoDriverModule != null;
    }

    protected class SecurityController
    extends BAlarmConsole.Controller {
        protected SecurityController() {
            super((BAlarmConsole)BSecurityAlarmConsole.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(BMouseEvent event) {
            super.mouseReleased(event);
            Object object = BSecurityAlarmConsole.this.monitor;
            synchronized (object) {
                if (BSecurityAlarmConsole.this.sourceModel.getSelection().getRowCount() == 1) {
                    BSecurityAlarmConsole.this.showRecurringCommand.setEnabled(true);
                } else {
                    BSecurityAlarmConsole.this.showRecurringCommand.setEnabled(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cellPressed(BMouseEvent event, int row, int col) {
            super.cellPressed(event, row, col);
            Object object = BSecurityAlarmConsole.this.monitor;
            synchronized (object) {
                if ((row == BSecurityAlarmConsole.this.lastRow || row == -1) && BSecurityAlarmConsole.this.sourceModel.getRowCount() > 1) {
                    return;
                }
                BSecurityAlarmConsole.this.lastRow = row;
                BSecurityAlarmConsole.this.loadVideoPanes(BSecurityAlarmConsole.this.getNextAlarm(true, true));
            }
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 38 || event.getKeyCode() == 40) {
                BSecurityAlarmConsole.this.lastRow = BSecurityAlarmConsole.this.sourceModel.getSelection().getRow();
                BSecurityAlarmConsole.this.loadVideoPanes(BSecurityAlarmConsole.this.getNextAlarm(true, true));
            }
        }

        protected void cellPopup(BMouseEvent event, int x, int y) {
            BTable sourceTable = this.getTable();
            BMenu menu = new BMenu();
            menu.add("ack", BSecurityAlarmConsole.this.ackCommand);
            menu.add("ackAll", BSecurityAlarmConsole.this.ackRecentCommand);
            menu.add("showRecurring", BSecurityAlarmConsole.this.showRecurringCommand);
            menu.add("notes", BSecurityAlarmConsole.this.notesCommand);
            menu.add("details", BSecurityAlarmConsole.this.detailsCommand);
            if (BSecurityAlarmConsole.this.getRecipientForAlarm(null) == null || BSecurityAlarmConsole.this.getRecipientForAlarm(null).getPermissions(BSecurityAlarmConsole.this.ctx).hasAdminInvoke()) {
                menu.add("forceClear", BSecurityAlarmConsole.this.forceClear);
            }
            menu.open((BWidget)sourceTable, event.getX(), event.getY());
        }
    }

    private class ShowRecurringCmd
    extends Command {
        public ShowRecurringCmd(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSecurityAlarmConsole.this.sourceModel.getSelection().isEmpty()) {
                return super.doInvoke();
            }
            BSecurityAlarmConsole.this.viewAll();
            return super.doInvoke();
        }

        public BImage getIcon() {
            return BImage.make((String)BSecurityAlarmConsole.this.getLexicon().getText("showRecurring.icon"));
        }
    }
}

