/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.securityUtilHx.alarm.EditAlarmClass;
import com.tridiumx.entsecHx.securityUtilHx.alarm.TableVideoCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.consolidated.BHxConsolidatedQueryView;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"entsec:AlarmSourceExts"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxAlarmExtManager
extends BHxConsolidatedQueryView {
    @Generated
    public static final BHxAlarmExtManager INSTANCE = new BHxAlarmExtManager();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxAlarmExtManager.class);
    private static BImage videoImg = BImage.make((String)"module://icons/x16/animate.png");
    private static BImage blankImg = BImage.make((String)"module://icons/x16/blank.png");
    protected SmartCommand editAlarmClass;
    protected SmartCommand editInstructions;
    protected SmartCommand videoSetup;
    protected SmartCommand relativeHyperlink = new BHxConsolidatedQueryView.StationHyperlinkCommand((BHxView)this);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxAlarmExtManager() {
        this.registerEvent((Event)this.relativeHyperlink);
        this.editAlarmClass = new EditAlarmClass((BHxView)this);
        this.registerEvent((Event)this.editAlarmClass);
        if (BEnterpriseSecurityService.isVideoDriverAvailable()) {
            this.videoSetup = new TableVideoCommand((BHxView)this);
            this.registerEvent((Event)this.videoSetup);
        }
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BQuery query = super.getQuery(op);
        query.lease(4);
        BProjection projection = query.getProjection();
        if (projection == null || projection.get("metaData") == null) {
            String path = "metaData";
            TypeSpecPath typeSpecPath = new TypeSpecPath(BFacets.TYPE.getTypeSpec(), path, TextUtil.toFriendly((String)"metaData"));
            QueryUtil.addHiddenColumn((BQuery)query, (TypeSpecPath)typeSpecPath);
        }
        return query;
    }

    @Override
    public String getRowKey(Type rowType, TableCursor<? extends BIObject> cursor, HxOp op) {
        StringBuffer sb = new StringBuffer();
        sb.append(SlotPath.escape((String)cursor.cell(cursor.getTable().getColumns().get("entsec:ConsolidatedColumnsProvider.getStationName()")).toString()));
        sb.append(";");
        Column keyColumn = cursor.getTable().getColumns().get(TypeSpecPath.PARENT_COMPONENT_SLOT_PATH.path);
        sb.append(cursor.cell(keyColumn).toString());
        return sb.toString();
    }

    @Override
    public BImage getRowIcon(TableCursor<? extends BIObject> cursor, HxOp op) {
        try {
            Column keyColumn = cursor.getTable().getColumns().get("metaData");
            String metaData = cursor.cell(keyColumn).toString();
            if (metaData.indexOf("cameraOrd") > -1) {
                return videoImg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return blankImg;
    }

    @Override
    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://entsecHx/rc/securityUtilHx/select.js"));
        super.write(op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        if (BEnterpriseSecurityService.isVideoDriverAvailable()) {
            return new SmartCommand[]{this.relativeHyperlink, this.editAlarmClass, this.videoSetup, this.filterCommand, this.columnsCommand, this.reportCommand, this.exportCommand};
        }
        return new SmartCommand[]{this.relativeHyperlink, this.editAlarmClass, this.filterCommand, this.columnsCommand, this.reportCommand, this.exportCommand};
    }
}

