/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.hx.ErrorDialog;
import com.tridium.hx.fieldeditors.BHxEnumFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DialogWizardCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.export.BExportData;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsecHx.orionToolsHx.BScheduledExport;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.util.LexiconText;

public abstract class ReportCommand
extends DialogWizardCommand {
    public ReportCommand(BHxView view) {
        super(view, LexiconModule.make(ReportCommand.class));
    }

    public DialogWizardCommand.Step[] makeSteps() {
        return new DialogWizardCommand.Step[]{new ManageDialog("manageReports", (Command)this), new AddDialog("addReport", (Command)this), new DeleteDialog("deleteReport", (Command)this), new ViewDialog("viewReport", (Command)this), new EditDialog("editReport", (Command)this), new EditDialog2("editReport2", (Command)this), new ScheduleDialog("scheduleReport", (Command)this), new ScheduleDialog2("scheduleReport2", (Command)this), new ScheduleDialog3("scheduleReport3", (Command)this)};
    }

    public String getFirstStepName(HxOp op) {
        return "manageReports";
    }

    public String getName(HxOp op) {
        return "report";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean isTableCommand(HxOp op) {
        return true;
    }

    public boolean readonlyEnablePolicy(HxOp op) {
        BComponent container = this.getContainer(op);
        if (container.getPermissions((Context)op).hasAdminWrite()) {
            return true;
        }
        return container.getChildren(container.getType().getTypeClass()).length > 0;
    }

    public BComponent getContainer(HxOp op) {
        BComponent currentReport = (BComponent)op.get();
        if (Flags.isUserDefined4((BComplex)currentReport.getParent(), (Slot)currentReport.getPropertyInParent())) {
            return currentReport.getParent().asComponent();
        }
        return currentReport;
    }

    public BComponent getSubject(HxOp op) {
        return op.get().asComponent();
    }

    public abstract BComponent getNewReport(HxOp var1) throws Exception;

    public abstract String handleAdd(HxOp var1) throws Exception;

    public abstract String handleEdit(HxOp var1) throws Exception;

    public abstract String handleDelete(HxOp var1) throws Exception;

    public abstract Tab getReportTab(String var1, HxOp var2);

    public Tab getScheduleTab(String reportName, HxOp op) {
        BScheduledExport scheduledExport = new BScheduledExport();
        if (reportName != null) {
            BScheduledExport[] children;
            BComponent container;
            BComponent report = container = this.getContainer(op);
            if (!reportName.equals(container.getName())) {
                report = (BComponent)container.get(reportName);
            }
            if ((children = (BScheduledExport[])report.getChildren(BScheduledExport.class)).length > 0) {
                scheduledExport = children[0];
            }
        }
        if (scheduledExport.isMounted()) {
            if (!scheduledExport.getPermissions((Context)op).hasAdminWrite()) {
                op.setReadonly(true);
            }
        } else {
            scheduledExport.setUserHandle((Context)op);
        }
        BFacets facets = BHxFieldSheet.getTypesExcludedFacets((String[])new String[]{BExportData.TYPE.toString()});
        facets = BFacets.make((BFacets)facets, (String)"noTableStart", (BIDataValue)BBoolean.TRUE);
        HxOp tabOp = op.make("fields", (BObject)scheduledExport, facets);
        tabOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, tabOp, op);
    }

    public Tab getExportTab(String report, HxOp op) throws Exception {
        BExportData exportData = new BExportData(SlotPath.unescape((String)report));
        exportData.setFlags((Slot)BExportData.exportRange, 4);
        Tab scheduleTab = this.getScheduleTab(report, op);
        BScheduledExport export = (BScheduledExport)scheduleTab.op.get();
        BExportData[] exportDatas = (BExportData[])export.getChildren(BExportData.class);
        if (exportDatas.length > 0) {
            exportData = exportDatas[0];
        }
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, op.make("exportData", (BObject)exportData, BFacets.make((String)"noTableStart", (boolean)true)), op);
    }

    public BFilterSet hardenFilterSet(BFilterSet set) {
        if (set == null) {
            return null;
        }
        set = (BFilterSet)set.newCopy();
        BFilterEntry[] entries = (BFilterEntry[])set.getChildren(BFilterEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getActive()) continue;
            set.setFlags((Slot)entries[i].getPropertyInParent(), 1);
        }
        return set;
    }

    class ScheduleDialog3
    extends DialogWizardCommand.Step {
        public ScheduleDialog3(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        protected String getTitle(HxOp op) {
            return ReportCommand.this.lexModule.getText(this.getLexName(op) + ".title", (Context)op, new Object[]{TextUtil.capitalize((String)SlotPath.unescape((String)op.getFormValue("report")))});
        }

        public boolean requiresOpen(HxOp op) {
            return false;
        }

        public String handle(HxOp op) throws Exception {
            String report = op.getFormValue("report");
            try {
                BScheduledExport export = (BScheduledExport)ReportCommand.this.getScheduleTab((String)report, (HxOp)op).op.get();
                String name = export.getEmailAccount();
                BEmailService service = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
                BOutgoingAccount outgoingAccount = (BOutgoingAccount)service.get(name);
                if (outgoingAccount == null) {
                    throw new IllegalStateException("No Outgoing Email Account:" + name);
                }
                export.doSendReport((Context)op);
                BAbsTime now = BAbsTime.now();
                outgoingAccount.poll();
                if (outgoingAccount.getLastDiscard().compareTo((Object)now) >= 0) {
                    throw new IllegalStateException(outgoingAccount.getLastDiscardCause());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                new ErrorDialog("Error Sending Email", (Command)ReportCommand.this, (Throwable)e).open(op);
                return null;
            }
            new ErrorDialog.SuccessDialog("Email Sending Complete", (Command)ReportCommand.this, "Email Sending Complete", null).open(op);
            return null;
        }
    }

    class ScheduleDialog2
    extends DialogWizardCommand.Step {
        public ScheduleDialog2(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        protected String getTitle(HxOp op) {
            return ReportCommand.this.lexModule.getText(this.getLexName(op) + ".title", (Context)op, new Object[]{TextUtil.capitalize((String)SlotPath.unescape((String)op.getFormValue("report")))});
        }

        public String handle(HxOp op) throws Exception {
            String sendNow;
            BExportData exportData;
            String delete;
            BComponent container;
            String reportForm = op.getFormValue("report");
            BComponent editReport = container = ReportCommand.this.getContainer(op);
            if (!reportForm.equals(container.getName())) {
                editReport = container.get(reportForm).asComponent();
            }
            if ((delete = op.getFormValue("delete")) != null) {
                BScheduledExport[] exports = (BScheduledExport[])editReport.getChildren(BScheduledExport.class);
                for (int i = 0; i < exports.length; ++i) {
                    editReport.remove(exports[i].getName(), (Context)op);
                }
                return null;
            }
            BScheduledExport save = (BScheduledExport)ReportCommand.this.getScheduleTab(reportForm, op).save();
            if (!save.isMounted()) {
                editReport.add(null, (BValue)save);
            }
            if (!(exportData = (BExportData)ReportCommand.this.getExportTab(reportForm, op).save()).isMounted()) {
                Tab scheduleTab = ReportCommand.this.getScheduleTab(reportForm, op);
                BScheduledExport export = (BScheduledExport)scheduleTab.op.get();
                export.add(null, (BValue)exportData);
            }
            if ((sendNow = op.getFormValue("sendNow")) == null || sendNow.equals("false")) {
                return null;
            }
            return "scheduleReport3";
        }

        public boolean process(HxOp op) throws Exception {
            if (ReportCommand.this.getScheduleTab(null, op).process()) {
                return true;
            }
            return super.process(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            String report = op.getFormValue("report");
            BHxSmartTableView.writeFormValue((String)"report", (String)report, (HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            Tab scheduleTab = ReportCommand.this.getScheduleTab(report, op);
            Tab exportTab = ReportCommand.this.getExportTab(report, op);
            exportTab.write();
            scheduleTab.write();
            out.w((Object)"</table>");
            HxTabUtil.addEvent((String)"change", (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)exportTab.op.scope(BExportData.fileType.getName() + ".value"), (String)exportTab.op.scope(BExportData.alignment.getName()), (String)"0", (HxOp)op);
            HxTabUtil.addEvent((String)"change", (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)exportTab.op.scope(BExportData.fileType.getName() + ".value"), (String)exportTab.op.scope(BExportData.style.getName()), (String)"0", (HxOp)op);
        }

        public Command[] getCommands(HxOp op) {
            try {
                String report = op.getFormValue("report");
                BHxSmartTableView.writeFormValue((String)"report", (String)report, (HxOp)op);
                if (ReportCommand.this.getScheduleTab((String)report, (HxOp)op).op.get().asComponent().isMounted() && op.canWrite()) {
                    return new Command[]{new SendNow(), new Delete("delete", LexiconText.make((String)"smartTableHx", (String)"delete")), new Dialog.Cancel((Dialog)this)};
                }
                return new Command[]{new SendNow(), new Dialog.Cancel((Dialog)this)};
            }
            catch (Exception e) {
                e.printStackTrace();
                return super.getCommands(op);
            }
        }

        public class SendNow
        extends Dialog.Submit {
            public SendNow() {
                super((Dialog)ScheduleDialog2.this);
            }

            public String getInvokeCode(HxOp op) {
                try {
                    String text = Lexicon.make((String)"smartTableHx").getText("sendNowQuestion");
                    return "if(confirm(&quot;" + text + "&quot;)) {hx.setFormValue(&quot;" + op.scope("sendNow") + "&quot;,&quot;true&quot;);}else{hx.setFormValue(&quot;" + op.scope("sendNow") + "&quot;,&quot;false&quot;);}" + super.getInvokeCode(op);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.getInvokeCode(op);
                }
            }
        }

        public class Delete
        extends Dialog.Submit {
            public Delete(String string, LexiconText text) {
                super((Dialog)ScheduleDialog2.this, string, text);
            }

            public String getInvokeCode(HxOp op) {
                String text = Lexicon.make((String)"smartTableHx").getText("areYouSureDeleteScheduleExport");
                return "if(confirm(&quot;" + text + "&quot;)) {" + super.getInvokeCode(op) + "};";
            }
        }
    }

    class ScheduleDialog
    extends DialogWizardCommand.Step {
        public ScheduleDialog(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        public String handle(HxOp op) throws Exception {
            return "scheduleReport2";
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BComponent container = ReportCommand.this.getContainer(op);
            Array choices = new Array((Object[])((BComponent[])container.getChildren(container.getType().getTypeClass())));
            choices.add((Object)container);
            if (choices.size() == 0) {
                op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            }
            DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)false, (String)"report", (HxOp)op);
        }
    }

    class ViewDialog
    extends DialogWizardCommand.Step {
        public ViewDialog(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        public String handle(HxOp op) throws Exception {
            BComponent container;
            String reportForm = op.getFormValue("report");
            BComponent report = container = ReportCommand.this.getContainer(op);
            if (!container.getName().equals(reportForm)) {
                report = container.get(reportForm).asComponent();
            }
            ReportCommand.this.redirect(op, BOrd.make((String)("station:|" + report.getSlotPathOrd())));
            return null;
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BComponent container = ReportCommand.this.getContainer(op);
            Array choices = new Array(BComponent.class);
            if (ReportCommand.this.getSubject(op) != container) {
                choices.add((Object)container);
            }
            choices.addAll((Object[])((BComponent[])container.getChildren(container.getType().getTypeClass())));
            if (choices.size() == 0) {
                op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            }
            DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)false, (String)"report", (HxOp)op);
        }
    }

    class DeleteDialog
    extends DialogWizardCommand.Step {
        public DeleteDialog(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        public String handle(HxOp op) throws Exception {
            return ReportCommand.this.handleDelete(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BComponent container = ReportCommand.this.getContainer(op);
            Array choices = new Array(container.getChildren(container.getType().getTypeClass()));
            if (choices.size() == 0) {
                op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            }
            DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)true, (String)"report", (HxOp)op);
        }
    }

    class EditDialog2
    extends DialogWizardCommand.Step {
        public EditDialog2(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        protected String getTitle(HxOp op) {
            return ReportCommand.this.lexModule.getText(this.getLexName(op) + ".title", (Context)op, new Object[]{TextUtil.capitalize((String)SlotPath.unescape((String)op.getFormValue("report")))});
        }

        public String handle(HxOp op) throws Exception {
            return ReportCommand.this.handleEdit(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            String report = op.getFormValue("report");
            BHxSmartTableView.writeFormValue((String)"report", (String)report, (HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            ReportCommand.this.getReportTab(report, op).write();
        }
    }

    class EditDialog
    extends DialogWizardCommand.Step {
        public EditDialog(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        public String handle(HxOp op) throws Exception {
            return "editReport2";
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BComponent container = ReportCommand.this.getContainer(op);
            Array choices = new Array(container.getChildren(container.getType().getTypeClass()));
            if (choices.size() == 0) {
                op.addOnload(SmartCommand.disableInvokeCode((String)op.scope("submit"), (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op));
            }
            DialogWizardCommand.writeChoices((Object[])choices.trim(), null, (boolean)false, (String)"report", (HxOp)op);
        }
    }

    class AddDialog
    extends DialogWizardCommand.Step {
        public AddDialog(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        public String handle(HxOp op) throws Exception {
            return ReportCommand.this.handleAdd(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            BComponent container = ReportCommand.this.getContainer(op);
            HtmlWriter out = op.getHtmlWriter();
            ReportCommand.this.getReportTab(null, op).write();
        }
    }

    class ManageDialog
    extends DialogWizardCommand.Step {
        public ManageDialog(String title, Command handler) {
            super((DialogWizardCommand)ReportCommand.this, title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            boolean hasReports;
            BComponent container = ReportCommand.this.getContainer(op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            String comment = ReportCommand.this.lexModule.getText("manageReportsQuestion", (Context)op, new Object[]{this.getDisplayName(op)});
            Array a = new Array(DialogWizardCommand.Step.class);
            boolean bl = hasReports = container.getChildren(container.getType().getTypeClass()).length > 0;
            if (hasReports) {
                a.add((Object)ReportCommand.this.getStep("viewReport", op));
            }
            if (container.getPermissions((Context)op).hasAdminWrite()) {
                a.add((Object)ReportCommand.this.getStep("addReport", op));
                if (hasReports) {
                    a.add((Object)ReportCommand.this.getStep("editReport", op));
                    a.add((Object)ReportCommand.this.getStep("deleteReport", op));
                }
                try {
                    BEmailService emailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
                    emailService.getLicenseFeature().check();
                    a.add((Object)ReportCommand.this.getStep("scheduleReport", op));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DialogWizardCommand.writeChoices((Object[])a.trim(), (String)comment, (boolean)false, (String)"nextStep", (HxOp)op);
        }
    }
}

