/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.hx.stub.StubHxOp;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.export.BExportData;
import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.export.ExportCommand;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="username", type="String", defaultValue="", flags=1), @NiagaraProperty(name="userHandle", type="BOrd", defaultValue="BOrd.DEFAULT", flags=5), @NiagaraProperty(name="exportSchedule", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=-2147483648, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:SmartScheduleLinkFE\"")}), @NiagaraProperty(name="emailAccount", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"email:OutgoingAccountFE\"))")}), @NiagaraProperty(name="email", type="BEmail", defaultValue="new BEmail()", flags=8)})
@NiagaraAction(name="sendReport", flags=16)
public class BScheduledExport
extends BComponent {
    @Generated
    public static final Property username = BScheduledExport.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property userHandle = BScheduledExport.newProperty((int)5, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Property exportSchedule = BScheduledExport.newProperty((int)Integer.MIN_VALUE, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    @Generated
    public static final Property emailAccount = BScheduledExport.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"email:OutgoingAccountFE")));
    @Generated
    public static final Property email = BScheduledExport.newProperty((int)8, (BValue)new BEmail(), null);
    @Generated
    public static final Action sendReport = BScheduledExport.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduledExport.class);
    private static String UNKNOWN_USER = "Unknown User";
    public static Logger LOG = Logger.getLogger("scheduledExport");
    private boolean scheduleActive = false;
    private static Object staticLock = new Object();

    @Generated
    public String getUsername() {
        return this.getString(username);
    }

    @Generated
    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Generated
    public BOrd getUserHandle() {
        return (BOrd)this.get(userHandle);
    }

    @Generated
    public void setUserHandle(BOrd v) {
        this.set(userHandle, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getExportSchedule() {
        return (BStatusBoolean)this.get(exportSchedule);
    }

    @Generated
    public void setExportSchedule(BStatusBoolean v) {
        this.set(exportSchedule, (BValue)v, null);
    }

    @Generated
    public String getEmailAccount() {
        return this.getString(emailAccount);
    }

    @Generated
    public void setEmailAccount(String v) {
        this.setString(emailAccount, v, null);
    }

    @Generated
    public BEmail getEmail() {
        return (BEmail)this.get(email);
    }

    @Generated
    public void setEmail(BEmail v) {
        this.set(email, (BValue)v, null);
    }

    @Generated
    public void sendReport() {
        this.invoke(sendReport, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.scheduleActive = this.getExportSchedule().getValue();
        if (Sys.getStation() != null && !Sys.isStationStarted() && this.getUserHandle().equals((Object)BOrd.NULL) && this.getUsername().length() == 0) {
            BUserService user = (BUserService)Sys.getService((Type)BUserService.TYPE);
            this.setUserHandle(user.getAdmin().getHandleOrd());
            this.setUsername(user.getAdmin().getName());
        } else if (Sys.getStation() != null && Sys.isStationStarted() && this.getUserHandle().equals((Object)BOrd.NULL) && this.getUsername().length() == 0) {
            this.setUsername(UNKNOWN_USER);
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(exportSchedule)) {
            if (this.getExportSchedule().getValue() != this.scheduleActive) {
                this.scheduleActive = this.getExportSchedule().getValue();
                if (this.scheduleActive) {
                    this.sendReport();
                }
            }
        } else if (prop.equals(userHandle) && cx != null && cx.getUser() != null && !cx.getUser().getHandleOrd().equals((Object)this.getUserHandle())) {
            this.setUserHandle(cx);
        }
    }

    public void setUserHandle(Context cx) {
        if (cx != null && cx.getUser() != null) {
            this.setUserHandle(cx.getUser().getHandleOrd());
            this.setUsername(cx.getUser().getUsername());
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        final Invocation invocation = new Invocation((BComponent)this, action, argument, cx);
        new Thread(){

            @Override
            public void run() {
                invocation.run();
            }
        }.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSendReport(Context cx) throws Exception {
        Object object = staticLock;
        synchronized (object) {
            if (((BExportData[])this.getChildren(BExportData.class)).length == 0) {
                return;
            }
            BExportData data = ((BExportData[])this.getChildren(BExportData.class))[0];
            try {
                BComponent service = Sys.getService((Type)BEmailService.TYPE);
                BOutgoingAccount emailAcount = (BOutgoingAccount)service.loadSlots().get(this.getEmailAccount());
                BOrd ord = BOrd.make((String)("station:|" + this.getParent().asComponent().getSlotPathOrd()));
                if (this.getUsername().length() == 0 || this.getUsername().equals(UNKNOWN_USER)) {
                    LOG.severe("sendReport: No User Assigned, removing Scheduled Export: " + this.getSlotPathOrd());
                    this.getParent().asComponent().remove(this.getName());
                    return;
                }
                if (emailAcount == null) {
                    LOG.severe("sendReport: cannot find email account '" + this.getEmailAccount() + ".");
                    return;
                }
                BUser user = this.getStoredUser();
                if (user == null) {
                    LOG.severe("sendReport: User " + this.getUsername() + " is no longer available, removing Scheduled Export: " + this.getSlotPathOrd());
                    this.getParent().asComponent().remove(this.getName());
                    return;
                }
                StubHxOp stubOp = new StubHxOp(ord.resolve(), user);
                stubOp = (StubHxOp)stubOp.mergeFacets(BHxSmartTableView.exportTableFacets);
                BHxSmartTableView view = (BHxSmartTableView)HxHyperlinkInfo.getView(null, (HxOp)stubOp);
                ExportCommand.validate((BExportData)data, (BHxSmartTableView)view, (HxOp)stubOp);
                BExportFileWrapper wrapper = ExportCommand.makeExportFile((BExportData)data, (HxOp)stubOp);
                byte[] bytes = wrapper.getBytes();
                wrapper.closeInput();
                String filename = data.getFileName();
                String mimeType = data.getMimeType();
                BBlobPart blobPart = new BBlobPart(filename, BBlob.make((byte[])bytes));
                blobPart.setMimeType(mimeType);
                BEmail email = (BEmail)this.getEmail().newCopy();
                email.getAttachments().add(filename.split("\\.")[0], (BValue)blobPart);
                emailAcount.send(email);
            }
            finally {
                if (data != null) {
                    data.removeTableContents();
                }
            }
            return;
        }
    }

    public BPermissions getPermissions(Context cx) {
        BPermissions permissions = super.getPermissions(cx);
        if (cx == null || cx.getUser() == null || !permissions.hasAdminWrite() || this.getUserHandle().equals((Object)BOrd.NULL)) {
            return permissions;
        }
        if (this.isMounted() && this.isRunning()) {
            try {
                if (this.getUsername().equals(UNKNOWN_USER)) {
                    return permissions;
                }
                BUser user = this.getStoredUser();
                if (user == null) {
                    return permissions;
                }
                if (user == cx.getUser()) {
                    return permissions;
                }
                return user.getPermissions(cx);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Error getting permissions", e);
            }
        }
        return permissions;
    }

    private BUser getStoredUser() {
        try {
            BUser user = (BUser)BOrd.make((String)("station:|" + this.getUserHandle())).get();
            if (!user.getName().equals(this.getUsername())) {
                this.setUsername(user.getName());
            }
            return user;
        }
        catch (Exception e) {
            try {
                if (this.getUsername().equals(UNKNOWN_USER)) {
                    return null;
                }
                BUser user = (BUser)BOrd.make((String)("station:|service:baja:UserService|slot:" + this.getUsername())).get();
                if (!user.getHandleOrd().equals((Object)this.getUserHandle())) {
                    this.setUserHandle(user.getHandleOrd());
                }
                return user;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

