/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionHx;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.ErrorDialog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableReportType;
import com.tridium.orion.priv.dt.DynamicTableResultModel;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.priv.ui.BDynamicTableView;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.FinishTableThread;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridiumx.entsec.orionTools.SecDynamicTableResultModel;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableConfig;
import com.tridiumx.entsecHx.orionHx.FilterCommand;
import com.tridiumx.entsecHx.securityUtilHx.RedirectCommand;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.Funcs;
import javax.baja.security.BIProtected;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"orion:DynamicTable"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxDynamicTableView
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxDynamicTableView.class);
    @Generated
    public static final BHxDynamicTableView INSTANCE = new BHxDynamicTableView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxDynamicTableView.class);
    public static final BImage moveUp = BImage.make((BIcon)BIcon.make((String)"module://icons/x16/arrowUp.png"));
    public static final BImage moveDown = BImage.make((BIcon)BIcon.make((String)"module://icons/x16/arrowDown.png"));
    private CommandBindings bindings = null;
    private OrionType dynamicRowType;
    private Command sortCommand = new SortCommand((BHxView)this);
    protected SmartCommand columnsCommand;
    protected FilterCommand filterCommand;
    protected SmartCommand hyperlinkCommand;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxDynamicTableView() {
        this.registerEvent((Event)this.sortCommand);
        this.columnsCommand = new ColumnsCommand((BHxView)this);
        this.registerEvent((Event)this.columnsCommand);
        this.filterCommand = new FilterCommand((BHxView)this);
        this.registerEvent((Event)this.filterCommand);
        this.hyperlinkCommand = new HyperlinkCommand((BHxView)this);
        this.registerEvent((Event)this.hyperlinkCommand);
    }

    public boolean supportsPagination(HxOp op) {
        return true;
    }

    public boolean supportsPaginatedQuery(HxOp op) {
        BDynamicTable dt = (BDynamicTable)op.get();
        return dt.supportsPaginatedQuery((Context)op) && dt.getWorkingReportType((Context)op) == BDynamicTableReportType.optimized;
    }

    public boolean requiresPrefiltering(HxOp op) {
        if (op.getPath().length() > 0) {
            return false;
        }
        BDynamicTable dt = (BDynamicTable)op.get();
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        return options.getPrefiltering(dt);
    }

    public void loadTable(HxOp op) throws Exception {
        FinishTableThread finishTableThread = this.makeTableThread(false, op);
        if (finishTableThread == null) {
            return;
        }
        if (this.requiresPrefiltering(op)) {
            op.addOnload(this.filterCommand.getInvokeCode(op));
            String quote = HxUtil.getInnerQuote((HxOp)op);
            op.addOnload("smartTable.pause($$(" + quote + op.scope("loading") + quote + "));");
        } else {
            op.addOnload(this.finishTableCommand.getInvokeCode(op));
        }
    }

    public void write(HxOp op) throws Exception {
        BDynamicTable dt = (BDynamicTable)op.get();
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        try {
            BFilterSet filterSet = options.getFilterSet(dt);
            if (dt.hasDefaultFilters((Context)op) && filterSet == null || !BDynamicTableOptions.isFilterSetValid((BDynamicTable)dt, (BFilterSet)filterSet, (Context)op)) {
                filterSet = BDynamicTableOptions.rebuildFilterSet((BDynamicTable)dt, (BFilterSet)filterSet, (Context)op);
                options.setFilterSet(dt, filterSet);
                new HxOptionsManager(op).save((BOptions)options);
            }
            BHxDynamicTableView.writeFormValue((String)"dynamicTableType", (String)dt.getRowType().toString(), (HxOp)op);
            super.write(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            HtmlWriter out = op.getHtmlWriter();
            out.println("<script type='text/javascript'>");
            new ErrorDialog("Error", (Command)this.filterCommand, (Throwable)e).open(op);
            out.println("</script>");
        }
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.columnsCommand, this.filterCommand, this.hyperlinkCommand, this.exportCommand};
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BDynamicTable dt = (BDynamicTable)op.get();
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        int sortCol = options.getSortColumnIndex(dt, (Context)op);
        boolean asc = options.getSortColumnAscForIndex(dt, (Context)op);
        BDynamicTableColumn[] columns = dt.getWorkingColumns((Context)op);
        int visibleColumnCount = 0;
        boolean sortColumnFound = false;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getHiddenKey()) continue;
            out.w((Object)"<th ");
            out.attr(" id", op.scope("" + visibleColumnCount));
            out.w((Object)(" onclick='hx.setFormValue(&quot;" + op.scope("sortBy") + "&quot;,&quot;" + visibleColumnCount + "&quot;);" + this.sortCommand.getInvokeCode(op)));
            out.w((Object)"'>");
            out.safe((Object)columns[i].getAlias().format((Object)dt, (Context)op));
            if (sortCol == visibleColumnCount && this.isEnabled(op)) {
                BHxDynamicTableView.writeSortColumnHeader(sortCol, asc, op);
                sortColumnFound = true;
            }
            out.w((Object)"</th>");
            ++visibleColumnCount;
        }
        if (!sortColumnFound) {
            BHxDynamicTableView.writeSortColumnHeader(-1, false, op);
        }
    }

    public static void writeSortColumnHeader(int sortCol, boolean asc, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)" ");
        out.w((Object)"<span ");
        out.attr("id", op.scope("upArrow"));
        if (sortCol == -1 || !asc) {
            out.attr(" style", "display: none;");
        }
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)moveUp, (HxOp)op);
        out.w((Object)"</span>");
        out.w((Object)"<span ");
        out.attr("id", op.scope("downArrow"));
        if (sortCol == -1 || asc) {
            out.attr(" style", "display: none;");
        }
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)moveDown, (HxOp)op);
        out.w((Object)"</span>");
    }

    public TableContents writeContents(HxOp op) throws Exception {
        BDynamicTable dt = (BDynamicTable)op.get();
        BOrionDatabase db = dt.getOrionDatabase();
        BOrd dbOrd = db.getOrdInSpace();
        BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
        int sortCol = options.getSortColumnIndex(dt, (Context)op);
        boolean asc = options.getSortColumnAscForIndex(dt, (Context)op);
        BFilterSet filterSet = options.getFilterSet(dt);
        if (filterSet == null) {
            filterSet = BDynamicTableOptions.rebuildFilterSet((BDynamicTable)dt, (BFilterSet)filterSet, (Context)op);
        }
        BDynamicTableOptions.updateFilterSet((BFilterSet)filterSet);
        BOrionTypeId orionTypeId = dt.getRowType();
        Property[] rowKeys = db.getType(orionTypeId).getKey();
        String handle = dbOrd + "/" + orionTypeId.getModuleName() + "/" + orionTypeId.getTypeName() + "/key:";
        BPage page = new BPage(0, this.getMaxResultSize((Context)op));
        if (this.supportsPaginatedQuery(op)) {
            int pageSize = this.getPageSize(op);
            int pageNo = this.getPage(op) - 1;
            int pageCount = this.getPageCount(op);
            if (this.knownPageCount(op) && pageNo > pageCount) {
                pageNo = pageCount;
            }
            page = new BPage(pageNo * pageSize, pageSize);
        }
        DynamicTableResultModel model = this.runQuery(dt, sortCol, asc, page, filterSet, (Context)op);
        BCommandBoundTable table = new BCommandBoundTable((TableModel)model);
        table.sortByColumn(sortCol, asc);
        TableContents tableContents = this.writeRows((BTable)table, handle, rowKeys, op);
        if (model.getReachedMax()) {
            tableContents.warning = Lexicon.make(BDynamicTableView.class).getText("onlyTopWarning", new Object[]{BInteger.make((int)this.getMaxResultSize((Context)op))});
        }
        return tableContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String calculatePageCountForQuery(HxOp op) throws Exception {
        if (!this.supportsPaginatedQuery(op)) {
            return BHxSmartTableView.getManyText((HxOp)op);
        }
        BDynamicTable dt = (BDynamicTable)op.get();
        BOrionDatabase db = dt.getOrionDatabase();
        OrionSession session = null;
        try {
            String returnValue;
            session = dt.getOrionDatabase().createSession((Context)op);
            BOrd dbOrd = db.getOrdInSpace();
            BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
            int sortCol = options.getSortColumnIndex(dt, (Context)op);
            boolean asc = options.getSortColumnAscForIndex(dt, (Context)op);
            BFilterSet filterSet = options.getFilterSet(dt);
            if (filterSet == null) {
                filterSet = BDynamicTableOptions.rebuildFilterSet((BDynamicTable)dt, (BFilterSet)filterSet, (Context)op);
            }
            BQuery query = dt.getQuery(sortCol, asc, null, filterSet, (Context)op);
            int count = BHxDynamicTableView.getCount((BQuery)query.newCopy(), session) + this.getPageSize(op) - 1;
            int pageCount = count / this.getPageSize(op);
            String string = returnValue = "" + pageCount;
            return string;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public static int getCount(BQuery q, OrionSession session) {
        q.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((String)"*"))));
        if (q.hasOrdering()) {
            q.remove((BComplex)q.getOrdering());
        }
        OrionCursor c = session.select(q);
        c.next();
        BDynamicOrionObject result = (BDynamicOrionObject)c.get();
        OrionType type = result.getOrionType();
        Property[] dps = type.getProperties();
        int count = ((BInteger)result.get(dps[0])).getInt();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicTableResultModel runQuery(BDynamicTable dt, int sortCol, boolean asc, BPage page, BFilterSet filterSet, Context cx) throws Exception {
        OrionCursor c = null;
        OrionSession session = null;
        try {
            session = dt.getOrionDatabase().createSession(cx);
            BQuery query = dt.getQuery(sortCol, asc, page, filterSet, cx);
            c = dt.resolve(session, query);
            OrionType dynamicRowType = c.getOrionType();
            SecDynamicTableResultModel model = new SecDynamicTableResultModel(dynamicRowType, dt.getWorkingColumns(cx), null, dt, cx);
            model.calculateResults(dt, query, dynamicRowType, c, this.getMaxResultSize(cx), session, cx, filterSet);
            SecDynamicTableResultModel secDynamicTableResultModel = model;
            return secDynamicTableResultModel;
        }
        finally {
            if (c != null) {
                c.close();
            }
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public BImage[] getRowIcons(BTable table, int i, HxOp op) {
        BImage image = this.getRowIcon(table, i, op);
        if (image == null) {
            return null;
        }
        return new BImage[]{image};
    }

    public BImage getRowIcon(BTable table, int i, HxOp op) {
        return null;
    }

    public String getRowKey(BTable table, int i, String handle, Property[] rowKeys, HxOp op) {
        BIOrionObject o = (BIOrionObject)table.getModel().getSubject(i);
        return handle + BOrionScheme.encodePropertiesToString((BIOrionObject)o, (Property[])rowKeys);
    }

    public TableContents writeRows(BTable table, String handle, Property[] rowKeys, HxOp op) {
        int i;
        BDynamicTable dt = (BDynamicTable)op.get();
        TableContents contents = new TableContents(op.scope("records"));
        String[] columnNames = table.getModel().getColumnNames();
        for (i = 0; i < columnNames.length; ++i) {
            contents.columns.td.add(new TableContents.Td(columnNames[i]));
        }
        for (i = 0; i < table.getModel().getRowCount(); ++i) {
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = this.getRowKey(table, i, handle, rowKeys, op);
            if (this.scopeRowIds(op)) {
                tr.id = BHxDynamicTableView.scopeId((String)tr.id, (HxOp)op);
            }
            tr.icons = this.getRowIcons(table, i, op);
            for (int k = 0; k < table.getModel().getColumnCount(); ++k) {
                tr.td.add(new TableContents.Td(table.getModel().getValueAt(i, k).toString()));
            }
            contents.tr.add(tr);
        }
        return contents;
    }

    public static OrionType getRowType(HxOp op) {
        String formValue = op.getFormValue("dynamicTableType");
        BOrionTypeId typeId = BOrionTypeId.make((String)formValue);
        BDynamicTable dt = (BDynamicTable)op.get();
        OrionType type = dt.getOrionDatabase().getType(typeId);
        return type;
    }

    public static BIOrionObject getNewSubject(HxOp op) {
        return BHxDynamicTableView.getNewSubject(false, op);
    }

    public static BIOrionObject getNewSubject(boolean reset, HxOp op) {
        try {
            BDynamicTable dt = (BDynamicTable)op.get();
            BOrionTypeId typeId = dt.getRowType();
            OrionType type = dt.getOrionDatabase().getType(typeId);
            BIOrionObject subject = (BIOrionObject)type.getInstance();
            Property[] key = type.getKey();
            for (int i = 0; i < key.length; ++i) {
                if (!key[i].getType().equals(BUuid.TYPE)) continue;
                BUuid uuid = null;
                String formName = "uuid-" + SlotPath.escape((String)key[i].getName());
                String formUuid = null;
                String method = op.getRequest().getMethod().toLowerCase();
                if (!method.equals("get")) {
                    formUuid = op.getFormValue(formName);
                }
                if (reset || formUuid == null || formUuid.length() == 0) {
                    uuid = BUuid.make();
                    if (!method.equals("get")) {
                        op.addOnload("hx.setFormValue('" + op.scope(formName) + "', '" + uuid.encodeToString() + "');");
                    } else {
                        BHxDynamicTableView.writeFormValue((String)formName, (String)uuid.encodeToString(), (HxOp)op);
                    }
                } else {
                    uuid = (BUuid)BUuid.DEFAULT.decodeFromString(formUuid);
                }
                subject.set(key[i], (BValue)uuid);
            }
            subject.setOrionDatabase(dt.getOrionDatabase());
            return subject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getSubject(HxOp op) {
        return this.getSubject(false, op);
    }

    public Object getSubject(boolean allowMultipleSelect, HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList.length == 1 || allowMultipleSelect && selectionList.length > 0) {
            String rowId = selectionList[0];
            if (this.scopeRowIds(op)) {
                rowId = TextUtil.split((String)rowId, (char)'~')[1];
            }
            BDynamicTable dt = (BDynamicTable)op.get();
            return BOrd.make((String)rowId).get((BObject)dt.getOrionDatabase());
        }
        if (selectionList.length > 1) {
            throw new IllegalStateException("only one subject allowed");
        }
        return null;
    }

    public Object[] getSubjects(HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        Object[] orionObjects = new BIOrionObject[selectionList.length];
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = selectionList[i];
            if (this.scopeRowIds(op)) {
                rowId = TextUtil.split((String)rowId, (char)'~')[1];
            }
            BOrd ord = BOrd.make((String)rowId);
            BDynamicTable dt = (BDynamicTable)op.get();
            orionObjects[i] = (BIOrionObject)ord.get((BObject)dt.getOrionDatabase());
        }
        return orionObjects;
    }

    public class SortCommand
    extends Command {
        public SortCommand(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return "sortCommand";
        }

        public void handle(HxOp op) throws Exception {
            if (((BHxSmartTableView)this.getView()).isEnabled(op)) {
                this.sortByColumn(Integer.parseInt(op.getFormValue("sortBy")), op);
            }
        }

        public void sortByColumn(int newSortCol, HxOp op) throws Exception {
            BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
            BDynamicTable dt = (BDynamicTable)op.get();
            int sortCol = options.getSortColumnIndex(dt, (Context)op);
            options.setSortColumnIndex(dt, newSortCol, (Context)op);
            boolean up = options.getSortColumnAscForIndex(dt, (Context)op);
            new HxOptionsManager(op).save((BOptions)options);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"smartTable.sort('").w(newSortCol).w((Object)"','").w((Object)op.scope("")).w((Object)"',").w(up).w((Object)");");
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public class NonDefaultHyperlinkCommand
    extends HyperlinkCommand {
        public NonDefaultHyperlinkCommand(BHxView view) {
            super(view);
        }

        @Override
        public boolean isDefaultAction() {
            return false;
        }
    }

    public class HyperlinkCommand
    extends RedirectCommand {
        public HyperlinkCommand(BHxView view) {
            super(view);
        }

        public HyperlinkCommand(BHxView view, Lexicon lex) {
            super(view, LexiconModule.make((BModule)lex.module));
        }

        @Override
        public String getName(HxOp op) {
            return "hyperlink";
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        @Override
        public boolean isDefaultAction() {
            return true;
        }

        @Override
        public String getPath(HxOp op) {
            BIOrionObject o = (BIOrionObject)BHxDynamicTableView.this.getSubject(op);
            return op.toUri((BOrd)o.getHandle());
        }

        @Override
        public String getStationName(HxOp op) {
            BDynamicTable dt = (BDynamicTable)op.get();
            BOrionDatabase db = dt.getOrionDatabase();
            if (db instanceof BLocalOrionDatabase) {
                return null;
            }
            if (db instanceof BFoxOrionDatabase) {
                BFoxOrionDatabase foxDb = (BFoxOrionDatabase)db;
                BFoxOrionSpace space = (BFoxOrionSpace)foxDb.getOrionSpace();
                BFoxSession foxSession = space.getChannel().getFoxSession();
                return foxSession.getStationName();
            }
            throw new IllegalStateException("No Orion Database available");
        }

        @Override
        public String getHostName(HxOp op) {
            String stationName = this.getStationName(op);
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
            return station.getRemoteHost().getHostname();
        }
    }

    public static class ColumnsCommand
    extends SmartCommand {
        public ColumnsCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "columns";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isTableCommand(HxOp op) {
            return true;
        }

        public boolean startsEnabled(HxOp op) {
            BObject obj = op.get();
            if (obj instanceof BIProtected && ((BIProtected)obj).getPermissions((Context)op).hasOperatorRead()) {
                return true;
            }
            return super.startsEnabled(op);
        }

        public boolean isVisible(HxOp op) {
            BComponent c = (BComponent)op.get();
            if (c.getParent() != null && Flags.isReadonly((BComplex)c.getParent(), (Slot)c.getPropertyInParent())) {
                return false;
            }
            return c.getParent() == null || !Flags.isUserDefined4((BComplex)c.getParent(), (Slot)c.getPropertyInParent()) || c.getPermissions((Context)op).hasOperatorWrite();
        }

        public void handle(HxOp op) throws Exception {
            this.redirect(op, op.toUri(BOrd.make((String)(op.getOrd().toString() + "|view:" + BHxDynamicTableConfig.TYPE))));
        }
    }
}

