/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device.handlers.command;

import com.tridium.hx.ErrorDialog;
import com.tridium.nrio.components.BUIPointEntry;
import com.tridium.nrio.conv.BNrioThermistorType3Conversion;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.ext.BLinearCalibrationExt;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrioBooleanInputProxyExt;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.points.BNrioRelayOutputProxyExt;
import com.tridium.nrio.points.BNrioResistiveInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.nrio.ui.BNrio16PointManager;
import com.tridiumx.entsecHx.factory.handlers.CommandHandler;
import com.tridiumx.entsecHx.nrio.util.INrioPointCategories;
import com.tridiumx.entsecHx.nrio.util.NrioUtil;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.units.BUnit;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ConfigureIoPointCommandHandler
extends CommandHandler
implements INrioPointCategories {
    private static final String COMMAND_LABEL = "Add Point";

    public ConfigureIoPointCommandHandler(BHxView view) {
        super(view);
        this.setCommandLabel(COMMAND_LABEL);
    }

    @Override
    public void handle(HxOp op) {
        if (op.getFormValue("learnPoint") == null) {
            return;
        }
        String[] tokens = this.parse(op.getFormValue("learnPoint"));
        String name = op.getFormValue("ioName");
        BNrioIoTypeEnum type = BNrioIoTypeEnum.make((String)tokens[1]);
        int instance = Integer.parseInt(tokens[2]);
        this.addNrioPoint(name, type, instance, op);
    }

    private String[] parse(String formValue) {
        return TextUtil.split((String)formValue, (char)':');
    }

    private void addNrioPoint(String name, BNrioIoTypeEnum type, int instance, HxOp op) {
        NrioUtil util = NrioUtil.make(op);
        BUIPointEntry entry = new BUIPointEntry(type, instance);
        BNrio16PointManager pointManager = (BNrio16PointManager)util.getPointManager();
        MgrLearn learn = pointManager.getLearn();
        try {
            MgrTypeInfo[] typeInfo = learn.toTypes((Object)entry);
            BPointDeviceExt pointDeviceExtension = util.getPointDeviceExtension();
            for (int i = 0; i < typeInfo.length; ++i) {
                String escapedName;
                BControlPoint newPoint = (BControlPoint)typeInfo[i].newInstance();
                BNrio16ProxyExt proxyExt = (BNrio16ProxyExt)newPoint.getProxyExt();
                proxyExt.setFlags((Slot)BNrio16ProxyExt.deviceFacets, proxyExt.getFlags((Slot)BNrio16ProxyExt.deviceFacets) | 4);
                if (!this.checkProxyExt(proxyExt, op)) continue;
                proxyExt.setInstance(instance);
                pointDeviceExtension.add(null, (BValue)newPoint);
                String ioCategory = op.getFormValue("ioType");
                if (ioCategory.equals("temperatureInput") && proxyExt.getType().is(BNrioResistiveInputProxyExt.TYPE)) {
                    BLinearCalibrationExt linearCalibrationExt = (BLinearCalibrationExt)newPoint.get("linearCalibration");
                    linearCalibrationExt.setUnits(BUnit.getUnit((String)"fahrenheit"));
                }
                if (SlotPath.isValidName((String)(escapedName = SlotPath.escape((String)name)))) {
                    BComponent parent = newPoint.getParent().asComponent();
                    parent.rename(newPoint.getPropertyInParent(), escapedName);
                    if (newPoint.getType().is(BBooleanWritable.TYPE)) {
                        BBooleanWritable bw = (BBooleanWritable)newPoint;
                        bw.setFallback(new BStatusBoolean());
                    } else if (newPoint.getType().is(BNumericWritable.TYPE)) {
                        BNumericWritable nw = (BNumericWritable)newPoint;
                        nw.setFallback(new BStatusNumeric());
                    }
                } else {
                    new ErrorDialog("Add Point Error", (Throwable)new Exception("The name '" + name + "' is an invalid component name")).open(op);
                }
                this.refresh(op);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.refresh(op);
        }
    }

    private boolean checkProxyExt(BNrio16ProxyExt ext, HxOp op) {
        String ioCategory = op.getFormValue("ioType");
        BControlPoint parent = ext.getParentPoint();
        BFacets existingFacets = parent.getFacets();
        BFacets voltageRangeFacet = BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)10));
        BFacets temperatureFacet = BFacets.makeInt((BUnit)BUnit.getUnit((String)"fahrenheit"));
        if (ioCategory.equals("voltageInput")) {
            parent.setFacets(BFacets.make((BFacets)existingFacets, (BFacets)voltageRangeFacet));
            return ext.getType().is(BNrioVoltageInputProxyExt.TYPE);
        }
        if (ioCategory.equals("temperatureInput") && ext.getType().is(BNrioResistiveInputProxyExt.TYPE)) {
            ext.setConversion((BProxyConversion)BNrioThermistorType3Conversion.DEFAULT);
            parent.setFacets(BFacets.make((BFacets)existingFacets, (BFacets)temperatureFacet));
            return true;
        }
        if (ioCategory.equals("resistiveInput")) {
            return ext.getType().is(BNrioResistiveInputProxyExt.TYPE);
        }
        if (ioCategory.equals("digitalInput")) {
            return ext.getType().is(BNrioBooleanInputProxyExt.TYPE);
        }
        if (ioCategory.equals("highSpeedCounter") && ext.getType().is(BNrioCounterInputProxyExt.TYPE)) {
            ext.setFlags((Slot)BNrioCounterInputProxyExt.rateCalc, ext.getFlags((Slot)BNrioCounterInputProxyExt.rateCalc) & 0xFFFFFFFE);
            return true;
        }
        if (ioCategory.equals("relayOutput")) {
            return ext.getType().is(BNrioRelayOutputProxyExt.TYPE);
        }
        if (ioCategory.equals("voltageOutput")) {
            parent.setFacets(BFacets.make((BFacets)existingFacets, (BFacets)voltageRangeFacet));
            return ext.getType().is(BNrioVoltageOutputProxyExt.TYPE);
        }
        return false;
    }
}

