/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui.searchfilter.util;

import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static final String OPEN_BRACE = "(";
    public static final String CLOSE_BRACE = ")";
    private static final List<String> OPERATORS = new ArrayList<String>();
    private static final List<String> UNARY_OPERATORS;

    public static List<String> getOperatorKeys() {
        return OPERATORS;
    }

    public static boolean isOperator(String searchFilterString) {
        return OPERATORS.contains(searchFilterString);
    }

    public static boolean isUnaryOperator(String searchFilterString) {
        return UNARY_OPERATORS.contains(searchFilterString);
    }

    public static String clearEnclosingBraces(String searchFilter) {
        if (searchFilter.startsWith(OPEN_BRACE) && searchFilter.endsWith(CLOSE_BRACE)) {
            searchFilter = searchFilter.substring(1, searchFilter.length() - 1);
        }
        return searchFilter;
    }

    public static List<String> getImmediateSubFilters(String searchFilterString) {
        if (searchFilterString == null || searchFilterString.length() == 0) {
            return null;
        }
        char openBrace = OPEN_BRACE.toCharArray()[0];
        char closeBrace = CLOSE_BRACE.toCharArray()[0];
        ArrayList<String> searchFiltersList = new ArrayList<String>();
        if (searchFilterString.indexOf(openBrace) == -1 && searchFilterString.indexOf(closeBrace) == -1) {
            searchFiltersList.add(searchFilterString);
            return searchFiltersList;
        }
        int beginIndex = 0;
        int endIndex = searchFilterString.indexOf(OPEN_BRACE);
        String tempString = searchFilterString.substring(beginIndex, endIndex);
        if (tempString != null && tempString.length() > 0) {
            searchFiltersList.add(tempString);
            tempString = searchFilterString.substring(endIndex, searchFilterString.length());
            Utils.checkEmptyAndAddAllElements(searchFiltersList, Utils.getImmediateSubFilters(tempString));
        } else if (searchFilterString.indexOf(OPEN_BRACE) == -1 || searchFilterString.lastIndexOf(OPEN_BRACE) == 0) {
            searchFiltersList.add(searchFilterString);
        } else if (searchFilterString.lastIndexOf(OPEN_BRACE) > searchFilterString.indexOf(CLOSE_BRACE) || searchFilterString.indexOf(OPEN_BRACE) == 0) {
            int i;
            int openBracesCount = 0;
            int closeBracesCount = 0;
            tempString = searchFilterString;
            for (i = 0; i < tempString.length(); ++i) {
                if (tempString.charAt(i) == openBrace) {
                    ++openBracesCount;
                    continue;
                }
                if (tempString.charAt(i) != closeBrace) continue;
                ++closeBracesCount;
                if (openBracesCount != closeBracesCount) continue;
            }
            searchFiltersList.add(searchFilterString.substring(0, i));
            Utils.checkEmptyAndAddAllElements(searchFiltersList, Utils.getImmediateSubFilters(searchFilterString.substring(i)));
        }
        return searchFiltersList;
    }

    private static void checkEmptyAndAddAllElements(List<String> searchFiltersList, List<String> immediateSubFilters) {
        if (immediateSubFilters != null && immediateSubFilters.size() > 0) {
            searchFiltersList.addAll(immediateSubFilters);
        }
    }

    public static List<String> getComparisionOperators() {
        ArrayList<String> comparisionOperators = new ArrayList<String>();
        comparisionOperators.add("=");
        comparisionOperators.add(">");
        comparisionOperators.add(">=");
        comparisionOperators.add("<");
        comparisionOperators.add("<=");
        return comparisionOperators;
    }

    static {
        OPERATORS.add("!");
        OPERATORS.add("&");
        OPERATORS.add("|");
        UNARY_OPERATORS = new ArrayList<String>();
        UNARY_OPERATORS.add("!");
    }
}

