/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui.searchbase;

import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsecHx.ldapHx.ui.searchbase.BLdapSearchBaseContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

@NiagaraType
@NiagaraSingleton
public class BHxLdapSearchBaseView
extends BHxView {
    @Generated
    public static final BHxLdapSearchBaseView INSTANCE = new BHxLdapSearchBaseView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxLdapSearchBaseView.class);
    public Command print;
    public Command showAll = new ShowAll(this);
    public static final Lexicon lex = Lexicon.make(BHxLdapSearchBaseView.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapSearchBaseView() {
        this.registerEvent((Event)this.showAll);
        this.print = new PrintCommand(this);
        this.registerEvent((Event)this.print);
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table height='100%' width='100%' cellspacing='0' cellpadding='0'>");
        out.w((Object)"<tr><td ><div id='contextContents'>Loading...</div></td></tr>");
        out.w((Object)"</table>");
        this.writeHiddenField(op, "selectionList");
        this.writeHiddenField(op, "previousSelectionRowId");
        this.writeHiddenField(op, "previousSelectionStyle");
        op.addOnload(this.print.getInvokeCode(op));
    }

    private String printRows(HxOp op, List<BLdapSearchBaseContext> contexts) throws Exception {
        String style = "smartTable-row2";
        StringBuilder divContent = new StringBuilder();
        divContent.append("<div id='contextContentsList' style='overflow: scroll ;max-height: 350px; width: 400px;'>");
        divContent.append("<table>");
        for (int i = 0; i < contexts.size(); ++i) {
            style = style.equals("smartTable-row1") ? "smartTable-row2" : "smartTable-row1";
            divContent.append(this.makeTableRow(op, contexts.get(i), style));
        }
        divContent.append("</table>");
        divContent.append("</div>");
        return divContent.toString();
    }

    private void writeHiddenField(HxOp op, String id) throws IOException {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("id", id);
        out.attr("type", "hidden");
        HxTabUtil.scope((String)id, (HtmlWriter)out, (HxOp)op);
        out.attr("value", "");
        out.w((Object)"/>");
    }

    private String makeTableRow(HxOp op, BLdapSearchBaseContext context, String style) throws Exception {
        String[] indices = context.getDepthIndexId().split("\\.");
        double widthQuotient = 2.0;
        StringBuilder divContent = new StringBuilder();
        divContent.append("<tr>");
        divContent.append("<td id='" + context.getDepthIndexId() + "'  nowrap class='" + style + "'>");
        divContent.append("<span style='padding-left: " + widthQuotient * (double)indices.length + "em;'>");
        divContent.append(context.getDepthIndexId());
        divContent.append("&nbsp;>&nbsp;&nbsp;&nbsp;");
        divContent.append("<a style='text-decoration: none; color: black; cursor:pointer;' ");
        divContent.append("onclick='" + this.getOnClickHandler(context, style, op) + "'");
        divContent.append(" >");
        divContent.append(context.getContextName());
        divContent.append("</a>");
        divContent.append("</span>");
        divContent.append("</td>");
        divContent.append("</tr>");
        List<BLdapSearchBaseContext> children = context.fetchChildren();
        if (children != null && children.size() != 0) {
            for (BLdapSearchBaseContext childContext : children) {
                if (childContext.getContextName().toLowerCase().startsWith("cn=")) continue;
                style = style.equals("smartTable-row1") ? "smartTable-row2" : "smartTable-row1";
                divContent.append(this.makeTableRow(op, childContext, style));
            }
        }
        return divContent.toString();
    }

    private String getOnClickHandler(BLdapSearchBaseContext context, String style, HxOp op) {
        String newStyle = style.equals("smartTable-row1") ? "smartTable-row1-selected" : "smartTable-row2-selected";
        StringBuilder onClick = new StringBuilder();
        onClick.append("(                                                                                           ");
        onClick.append("  function(){                                                                               ");
        onClick.append("    var previousSelectionRowIdVar                                                           ");
        onClick.append("            = document.getElementById(&quot;previousSelectionRowId&quot;).value;            ");
        onClick.append("    if (previousSelectionRowIdVar != null && previousSelectionRowIdVar != &quot;&quot;) {   ");
        onClick.append("        document.getElementById(previousSelectionRowIdVar).className                        ");
        onClick.append("                = document.getElementById(&quot;previousSelectionStyle&quot;).value;        ");
        onClick.append("    }                                                                                       ");
        onClick.append("     document.getElementById(&quot;selectionList&quot;).value                               ");
        onClick.append("            = &quot;" + context.getContextNameWithParentName() + "&quot;;                   ");
        onClick.append("    document.getElementById(&quot;previousSelectionRowId&quot;).value                       ");
        onClick.append("            = &quot;" + context.getDepthIndexId() + "&quot;;                                ");
        onClick.append("    document.getElementById(&quot;previousSelectionStyle&quot;).value                       ");
        onClick.append("            = &quot;" + style + "&quot;;                                                    ");
        onClick.append("    document.getElementById(&quot;" + context.getDepthIndexId() + "&quot;).className        ");
        onClick.append("            = &quot;" + newStyle + "&quot;;                                                 ");
        onClick.append("  }                                                                                         ");
        onClick.append(")                                                                                           ");
        onClick.append("()                                                                                          ");
        return onClick.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BLdapSearchBaseContext> getSearchBaseContexts(HxOp op) throws NamingException {
        ArrayList<BLdapSearchBaseContext> returnValue = new ArrayList<BLdapSearchBaseContext>();
        try (Context dirContext = null;){
            String ldapServerName = (String)op.getRequest().getSession().getAttribute("ldapServerName");
            ldapServerName = SlotPath.escape((String)ldapServerName);
            dirContext = ExportPersonsDataUtility.getSelectedLdapServer((String)ldapServerName).connect();
            Attributes attributes = dirContext.getAttributes("", new String[]{"namingContexts"});
            Attribute attribute = attributes.get("namingContexts");
            NamingEnumeration<?> all = attribute.getAll();
            int i = 0;
            while (all.hasMore()) {
                String next = (String)all.next();
                BLdapSearchBaseContext cnt = BLdapSearchBaseContext.getInstance(next);
                cnt.setLdapServerName(ldapServerName);
                cnt.setDepthIndexId(++i);
                returnValue.add(cnt);
            }
        }
        return returnValue;
    }

    class PrintCommand
    extends Command {
        public PrintCommand(BHxView view) {
            super(view);
        }

        public String getInvokeCode(HxOp op) {
            return "hx.fireEvent(\"" + op.getPath() + "\",\"" + this.getId() + "\");";
        }

        public String getDisplayName(HxOp op) {
            return "sortCommand";
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)" if (document.getElementById('contextContents') != null)                               ");
            out.w((Object)("   document.getElementById('contextContents').innerHTML=\"" + this.getContextList(op) + "\" "));
            op.getRequest().getSession().setAttribute("contextLoadStatus", (Object)"loaded");
        }

        private String getContextList(HxOp op) throws Exception {
            List contexts = BHxLdapSearchBaseView.this.getSearchBaseContexts(op);
            return BHxLdapSearchBaseView.this.printRows(op, contexts);
        }
    }

    class ShowAll
    extends Command {
        public ShowAll(BHxView view) {
            super(view);
        }
    }
}

