/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.discover;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessRightLdapGroupJoin;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.ldap.BLdapGroupProperties;
import com.tridiumx.entsecHx.ldapHx.BHxLdapGroupsView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.groups.BLdapGroupsDeviceExt;
import com.tridiumx.ldapDriver.groups.BLdapGroupsDiscoveryLeaf;
import java.util.ArrayList;
import java.util.List;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxLdapGroupsDiscoverView
extends BHxAbstractDiscoverView {
    static final Lexicon entsecHxLex = Lexicon.make(BHxLdapGroupsDiscoverView.class);
    @Generated
    public static final BHxLdapGroupsDiscoverView INSTANCE = new BHxLdapGroupsDiscoverView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxLdapGroupsDiscoverView.class);
    private static String[] LEARN_FIELDS = new String[]{"displayName", "distinguishedName"};
    private static String[] DEVICE_FIELDS = new String[]{"groupName", "description", "accessRight"};
    private final List<String> accessRghtList = new ArrayList<String>();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapGroupsDiscoverView() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAccessRightsList() {
        this.accessRghtList.clear();
        OrionSession orionSession = null;
        try {
            BSqlQuery sqlQuery = BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE);
            orionSession = this.getOrionSession();
            OrionCursor orionCursor = orionSession.select((BQuery)sqlQuery);
            while (orionCursor.next()) {
                BOrionObject orionObject = (BOrionObject)orionCursor.get();
                BValue val = orionObject.get(BAccessRight.accessRightName);
                if (val == null) continue;
                this.accessRghtList.add(SlotPath.escape((String)val.toString()).trim());
            }
            this.closeOrionSession(orionSession);
        }
        catch (Throwable throwable) {
            this.closeOrionSession(orionSession);
            throw throwable;
        }
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.add, this.match, this.filterCommand, this.exportCommand};
    }

    @Override
    public BHxAbstractManagerView getAbstractManagerView(HxOp op) {
        return BHxLdapGroupsView.INSTANCE;
    }

    @Override
    public void loadTable(HxOp op) throws Exception {
        super.loadTable(op);
        this.fetchAccessRightsList();
    }

    @Override
    public BComponent getDeviceSubject(HxOp op) {
        BLdapGroupsDiscoveryLeaf entry = (BLdapGroupsDiscoveryLeaf)this.getLearnEntrySubject(op);
        if (entry == null) {
            throw new IllegalStateException("No Group Selected");
        }
        BLdapGroupProperties group = new BLdapGroupProperties();
        group.setGroupName(entry.getDistinguishedName());
        group.setDescription(entry.getCn());
        if (this.accessRghtList.isEmpty()) {
            this.accessRghtList.add(SlotPath.escape((String)" ").trim());
        }
        BDynamicEnum accessRightValue = BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])this.accessRghtList.toArray(new String[this.accessRghtList.size()])));
        group.setAccessRight(accessRightValue);
        op.getRequest().getSession().setAttribute(op.scope("distinguishedName"), (Object)entry.getDistinguishedName());
        return group;
    }

    @Override
    public Tab getAddTab(HxOp op) {
        Tab tab = super.getAddTab(op);
        if (tab != null) {
            tab.op = tab.op.mergeFacets(BHxFieldSheet.noMissingLog);
        }
        return tab;
    }

    @Override
    public String getDefaultAddName(BComponent newDevice, HxOp op) throws Exception {
        String name = (String)op.getRequest().getSession().getAttribute(op.scope("distinguishedName"));
        return SlotPath.unescape((String)name);
    }

    @Override
    public boolean readonlyAddName(HxOp op) {
        return true;
    }

    @Override
    public String getDeviceTypeDisplayName(BComponent newDevice, HxOp op) throws Exception {
        return com.tridiumx.ldapDriver.groups.BLdapGroup.TYPE.getDisplayName((Context)op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAdd(BComponent newDevice, String addName, HxOp op) throws Exception {
        BLdapGroupsDeviceExt component = (BLdapGroupsDeviceExt)this.getComponent(op);
        BLdapGroupProperties data = (BLdapGroupProperties)newDevice;
        OrionSession session = null;
        try {
            session = this.getOrionSession();
            BLdapGroup ldapGroup = this.makeLdapGroupEntry(op, data, session);
            this.makeLdapGroupAccessRightJoinEntry(op, data, ldapGroup, session);
            session.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            session.rollback();
        }
        finally {
            this.closeOrionSession(session);
        }
        HxOp parentOp = null;
        String parentOpOrdFromValue = op.getFormValue("parentOp");
        String parentOpOrdStr = op.getBaseOrdTarget().getBaseOrdTarget().getOrd().encodeToString();
        if (parentOpOrdStr.equals(parentOpOrdFromValue)) {
            parentOp = (HxOp)op.getBase().getBase();
        }
        this.getAbstractManagerView(op).reloadTables(parentOp);
    }

    private BLdapGroup makeLdapGroupEntry(HxOp op, BLdapGroupProperties data, OrionSession session) {
        BRef ldapServerRef = BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.TYPE.getTypeSpec(), (BSimple)this.getLDAPServerReference(op));
        BLdapGroup ldapGroup = this.ldapGroupByName(session, data.getGroupName(), ldapServerRef);
        if (ldapGroup == null) {
            ldapGroup = new BLdapGroup();
            ldapGroup.setGroupName(data.getGroupName());
            ldapGroup.setDescription(data.getDescription());
            ldapGroup.setLdapServer(ldapServerRef);
            ldapGroup.setLastModified(BAbsTime.now());
            session.insert((BIOrionObject)ldapGroup);
        }
        return ldapGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BLdapGroup ldapGroupByName(OrionSession session, String groupName, BRef ldapServerRef) {
        BLdapGroup ldapGroup = null;
        try (OrionCursor c = null;){
            OrionType orionType = BLdapGroup.ORION_TYPE;
            BSqlQuery query = BSqlQuery.make((OrionType)orionType);
            BExpression exp1 = Predicates.eq((String)"groupName", (BSimple)BString.make((String)groupName));
            BExpression exp2 = Predicates.eq((String)"ldapServer", (BSimple)ldapServerRef);
            query = (BSqlQuery)query.where(Predicates.and((BExpression)exp1, (BExpression)exp2));
            c = session.select((BQuery)query);
            if (c.next()) {
                ldapGroup = (BLdapGroup)c.get();
            }
        }
        return ldapGroup;
    }

    private BAccessRightLdapGroupJoin makeLdapGroupAccessRightJoinEntry(HxOp op, BLdapGroupProperties data, BLdapGroup ldapGroup, OrionSession session) {
        BRef accessRightRef = BRef.make((BTypeSpec)BAccessRight.TYPE.getTypeSpec(), (BSimple)this.getAccessRightReference(data));
        BRef ldapGroupRef = BRef.make((BTypeSpec)BLdapGroup.TYPE.getTypeSpec(), (BSimple)ldapGroup.getLdapGroupId());
        BAccessRightLdapGroupJoin map = new BAccessRightLdapGroupJoin();
        map.setLastModified(BAbsTime.now());
        if (this.accessRightLdapGroupMappingExist(accessRightRef, ldapGroupRef, session)) {
            session.update((BIOrionObject)map);
        } else {
            map.setAccessRight(accessRightRef);
            map.setLdapGroup(ldapGroupRef);
            session.insert((BIOrionObject)map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accessRightLdapGroupMappingExist(BRef accessRightRef, BRef ldapGroupRef, OrionSession session) {
        boolean recordExist = false;
        try (OrionCursor c = null;){
            OrionType orionType = BAccessRightLdapGroupJoin.ORION_TYPE;
            BSqlQuery query = BSqlQuery.make((OrionType)orionType);
            BExpression exp1 = Predicates.eq((String)"accessRight", (BSimple)accessRightRef);
            BExpression exp2 = Predicates.eq((String)"ldapGroup", (BSimple)ldapGroupRef);
            query = (BSqlQuery)query.where(Predicates.and((BExpression)exp1, (BExpression)exp2));
            c = session.select((BQuery)query);
            if (c.next()) {
                recordExist = true;
            }
        }
        return recordExist;
    }

    @Override
    public void match(BComplex learnEntry, BComponent databaseDevice, HxOp op) {
        throw new UnsupportedOperationException("BHxLdapGroupsDiscoverView.match() should not be used");
    }

    @Override
    public String[] getDeviceFields(HxOp op) {
        return DEVICE_FIELDS;
    }

    @Override
    public String[] getLearnFields(HxOp op) {
        return LEARN_FIELDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BUuid getLDAPServerReference(HxOp op) {
        String ldapServerName = (String)op.getRequest().getSession().getAttribute("ldapServerName");
        BLdapNetwork ldapNetwork = (BLdapNetwork)Sys.getService((Type)BLdapNetwork.TYPE);
        BUuid uuid = BUuid.DEFAULT;
        ldapNetwork.lease();
        BLdapServer server = (BLdapServer)ldapNetwork.get(SlotPath.escape((String)ldapServerName));
        if (server != null) {
            server.lease();
            BOrd ord = server.getSlotPathOrd();
            OrionSession session = null;
            try {
                session = this.getOrionSession();
                BSqlQuery query = BSqlQuery.make((OrionType)com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE);
                BQuery q = query.where(Predicates.eq((String)"ord", (BSimple)BOrd.make((String)("station:|" + ord.encodeToString()))));
                OrionCursor cursor = session.select(q);
                if (cursor.next()) {
                    com.tridiumx.entsec.access.orion.BLdapServer ldapServer = (com.tridiumx.entsec.access.orion.BLdapServer)cursor.get();
                    uuid = ldapServer.getLdapServerId();
                }
            }
            finally {
                this.closeOrionSession(session);
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BUuid getAccessRightReference(BLdapGroupProperties data) {
        String accessRightName = data.getAccessRight().getTag();
        BUuid uuid = BUuid.DEFAULT;
        OrionSession session = null;
        try {
            session = this.getOrionSession();
            BSqlQuery query = BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE);
            BQuery q = query.where(Predicates.eq((String)"accessRightName", (BSimple)BString.make((String)SlotPath.unescape((String)accessRightName))));
            OrionCursor cursor = session.select(q);
            if (cursor.next()) {
                BAccessRight aR = (BAccessRight)cursor.get();
                uuid = aR.getAccessRightId();
            }
        }
        finally {
            this.closeOrionSession(session);
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BUuid getGroupReference(BLdapGroupProperties data) {
        String grpName = data.getGroupName();
        BUuid uuid = BUuid.DEFAULT;
        OrionSession session = null;
        try {
            session = this.getOrionSession();
            BSqlQuery query = BSqlQuery.make((OrionType)BLdapGroup.ORION_TYPE);
            query.where(Predicates.eq((String)"groupName", (BSimple)BString.make((String)grpName)));
            OrionCursor cursor = session.select((BQuery)query);
            if (cursor.next()) {
                BLdapGroup aR = (BLdapGroup)cursor.get();
                uuid = aR.getLdapGroupId();
            }
        }
        finally {
            this.closeOrionSession(session);
        }
        return uuid;
    }

    private OrionSession getOrionSession() {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(null);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    private void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }
}

