/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.discover;

import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.ldap.BLdapAttributeProperties;
import com.tridiumx.entsecHx.ldapHx.BHxLdapAttributesView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.ldapDriver.attributes.BLdapAttribute;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDiscoveryLeaf;
import java.util.HashMap;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxLdapAttributesDiscoverView
extends BHxAbstractDiscoverView {
    static final Lexicon entsecHxLex = Lexicon.make(BHxLdapAttributesDiscoverView.class);
    @Generated
    public static final BHxLdapAttributesDiscoverView INSTANCE = new BHxLdapAttributesDiscoverView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxLdapAttributesDiscoverView.class);
    protected static HashMap<String, BOrd> autoFillHelper = new HashMap();
    private static String[] LEARN_FIELDS;
    private static String[] DEVICE_FIELDS;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapAttributesDiscoverView() {
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.add, this.match, this.filterCommand, this.exportCommand};
    }

    @Override
    public BHxAbstractManagerView getAbstractManagerView(HxOp op) {
        return BHxLdapAttributesView.INSTANCE;
    }

    @Override
    public BComponent getDeviceSubject(HxOp op) {
        BLdapAttributesDiscoveryLeaf entry = (BLdapAttributesDiscoveryLeaf)this.getLearnEntrySubject(op);
        if (entry == null) {
            throw new IllegalStateException("No Attribute Selected");
        }
        BLdapAttributeProperties attr = new BLdapAttributeProperties();
        attr.setAttrName(entry.getAttrName());
        attr.setIsMandatory(entry.getIsMandatory());
        attr.setParentClass(entry.getParentClass());
        attr.setDataType(entry.getDataType());
        attr.setDescription(entry.getDescription());
        String name = entry.getAttrName();
        name = name.toLowerCase();
        name = TextUtil.replace((String)name, (String)"$20", (String)"");
        name = TextUtil.replace((String)name, (String)"_", (String)"");
        BOrd ord = autoFillHelper.get(name);
        if (ord != null) {
            attr.setMappedORD(ord);
        }
        attr.setIsRDN(false);
        op.getRequest().getSession().setAttribute(op.scope("attrName"), (Object)entry.getAttrName());
        return attr;
    }

    @Override
    public String getDefaultAddName(BComponent newDevice, HxOp op) throws Exception {
        String name = (String)op.getRequest().getSession().getAttribute(op.scope("attrName"));
        return SlotPath.unescape((String)name);
    }

    @Override
    public boolean readonlyAddName(HxOp op) {
        return true;
    }

    @Override
    public String getDeviceTypeDisplayName(BComponent newDevice, HxOp op) throws Exception {
        return BLdapAttribute.TYPE.getDisplayName((Context)op);
    }

    @Override
    public Tab getAddTab(HxOp op) {
        Tab tab = super.getAddTab(op);
        if (tab != null) {
            tab.op = tab.op.mergeFacets(BHxFieldSheet.noMissingLog);
        }
        return tab;
    }

    @Override
    public void handleAdd(BComponent newDevice, String addName, HxOp op) throws Exception {
        BLdapAttributesDeviceExt component = (BLdapAttributesDeviceExt)this.getComponent(op);
        BLdapAttributeProperties data = (BLdapAttributeProperties)newDevice;
        Property p = component.add(SlotPath.escape((String)addName), (BValue)newDevice);
        HxOp parentOp = null;
        String parentOpOrdFromValue = op.getFormValue("parentOp");
        String parentOpOrdStr = op.getBaseOrdTarget().getBaseOrdTarget().getOrd().encodeToString();
        if (parentOpOrdStr.equals(parentOpOrdFromValue)) {
            parentOp = (HxOp)op.getBase().getBase();
        }
        this.getAbstractManagerView(op).reloadTables(parentOp);
    }

    @Override
    public void match(BComplex learnEntry, BComponent databaseDevice, HxOp op) {
        throw new UnsupportedOperationException("BHxLdapAttributesDiscoverView.match() should not be used");
    }

    @Override
    public String[] getDeviceFields(HxOp op) {
        return DEVICE_FIELDS;
    }

    @Override
    public String[] getLearnFields(HxOp op) {
        return LEARN_FIELDS;
    }

    static {
        autoFillHelper.put("lastname", BOrd.make((String)"entsecref:/owner/lastName"));
        autoFillHelper.put("firstname", BOrd.make((String)"entsecref:/owner/firstName"));
        autoFillHelper.put("credential", BOrd.make((String)"entsecref:/credential"));
        autoFillHelper.put("facilitycode", BOrd.make((String)"entsecref:/facilityCode"));
        autoFillHelper.put("status", BOrd.make((String)"entsecref:/status"));
        autoFillHelper.put("issuedate", BOrd.make((String)"entsecref:/issueDate"));
        autoFillHelper.put("expirationdate", BOrd.make((String)"entsecref:/expirationDate"));
        autoFillHelper.put("photo", BOrd.make((String)"entsecref:/owner/entsec_PersonPortrait/image"));
        autoFillHelper.put("portrait", BOrd.make((String)"entsecref:/owner/entsec_PersonPortrait/image"));
        autoFillHelper.put("employeeid", BOrd.make((String)"entsecref:/owner/employeeId"));
        autoFillHelper.put("middleinitial", BOrd.make((String)"entsecref:/owner/middleInitial"));
        autoFillHelper.put("department", BOrd.make((String)"entsecref:/owner/department"));
        autoFillHelper.put("persontype", BOrd.make((String)"entsecref:/owner/personType"));
        autoFillHelper.put("tenant", BOrd.make((String)"entsecref:/owner/tenant/tenantName"));
        LEARN_FIELDS = new String[]{"displayName", "dataType", "isRDN"};
        DEVICE_FIELDS = new String[]{"dataType", "MappedORD", "isRDN"};
    }
}

