/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.ldap.BLdapGroupProperties;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsec.ldap.util.LdapValidationUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.ldapHx.LdapUtil;
import com.tridiumx.entsecHx.ldapHx.discover.BHxLdapGroupsDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxLdapGroupsView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxLdapGroupsView.class);
    @Generated
    public static final BHxLdapGroupsView INSTANCE = new BHxLdapGroupsView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxLdapGroupsView.class);
    protected SmartCommand delete = new Delete((BHxView)this);
    public DiscoverCommand discoverCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapGroupsView() {
        this.registerEvent((Event)this.delete);
        this.discoverCommand = new DiscoverCommand((BHxView)this);
        this.registerEvent((Event)this.discoverCommand);
    }

    @Override
    public String getPageTitle(HxOp op) {
        return secUtilLex.getText("LdapGroupsMgr");
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BLdapGroupProperties.TYPE.getTypeSpec();
    }

    public Type getQueryType(HxOp op) {
        return com.tridiumx.ldapDriver.groups.BLdapGroup.TYPE;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BComponent component = (BComponent)op.get();
        BQuery query = QueryUtil.makeQuery((BTypeSpec)this.getDeviceTypeSpec(op));
        query.select(new BProjection());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "groupName", secUtilLex.getText("groupName")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "accessRight", secUtilLex.getText("accessRight")));
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public TableContents writeContents(HxOp op) throws Exception {
        TableContents table = new TableContents(op.scope("records"));
        table.columns.td.add(new TableContents.Td(secUtilLex.getText("groupName")));
        table.columns.td.add(new TableContents.Td(secUtilLex.getText("accessRight")));
        this.writeRows(table, op);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRows(TableContents table, HxOp op) {
        OrionSession orionSession = null;
        BUuid ldapServerId = null;
        try {
            orionSession = this.getOrionSession();
            String ldapServerName = (String)op.getRequest().getSession().getAttribute("ldapServerName");
            BLdapServer selectedLdapServer = ExportPersonsDataUtility.getSelectedLdapServer((String)SlotPath.escape((String)ldapServerName));
            ldapServerId = ExportPersonsDataUtility.getLDAPServerReference((BLdapServer)selectedLdapServer);
            OrionCursor ldapGroupCursor = orionSession.select(BSqlQuery.make((OrionType)BLdapGroup.ORION_TYPE).where(Predicates.eq((Property)BLdapGroup.ldapServer, (BSimple)ldapServerId)));
            while (ldapGroupCursor.next()) {
                BLdapGroup ldapGroup = (BLdapGroup)ldapGroupCursor.get();
                BLdapGroup.AccessRightsCursor accessRightCursor = ldapGroup.getAccessRights(orionSession);
                while (accessRightCursor.next()) {
                    BAccessRight accessRight = accessRightCursor.getAccessRight();
                    TableContents.Tr tableRow = new TableContents.Tr();
                    tableRow.id = ldapGroup.getLdapGroupId().toString();
                    tableRow.td.add(new TableContents.Td(ldapGroup.getGroupName()));
                    tableRow.td.add(new TableContents.Td(accessRight.getAccessRightName()));
                    table.tr.add(tableRow);
                }
            }
        }
        finally {
            this.closeOrionSession(orionSession);
        }
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        BObject o;
        BOrd jobOrd;
        Type newType = this.getQueryType(op);
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getLearnRowTypeSpec(op)));
        query.select(new BProjection());
        LdapUtil.addLdapAttrDiscoveryQuery(query, newType);
        QueryUtil.addSlotFacetColumn((BQuery)query, (Type)BBoolean.TYPE, (String)"dbExistence", (String)secUtilLex.getText("GroupExists"));
        QueryUtil.addHiddenColumns((BQuery)query);
        String jobOrdStr = op.getFormValue("discover.discoverJobOrd");
        if (jobOrdStr != null && (jobOrd = BOrd.make((String)jobOrdStr)) != null && (o = jobOrd.get()) instanceof BJob) {
            BJob job = (BJob)o;
            this.updateExistenceFacets(job, op);
            query.add("base", (BValue)job.getAbsoluteOrd());
        }
        return query;
    }

    public String[] getLearnFields(HxOp op) {
        Type newType = this.getQueryType(op);
        BComponent instance = newType.getInstance().asComponent();
        BComplex c = BTypeSpec.make((String)"ldapDriver:LdapGroupsDiscoveryLeaf").getInstance().asComplex();
        Property[] props = c.getPropertiesArray();
        String[] fields = new String[props.length + 1];
        for (int i = 0; i < props.length; ++i) {
            fields[i] = "" + props[i].getName();
        }
        return fields;
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return BHxLdapGroupsDiscoverView.INSTANCE;
    }

    public BComponent getContainer(HxOp op) {
        return (BComponent)op.get();
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        BComponent container = this.getContainer(op);
        return LdapUtil.getLeafType((BComplex)container).getTypeSpec();
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        BComponent deviceSys = this.getContainer(op);
        BOrd ord = ((BINDiscoveryHost)deviceSys).submitDiscoveryJob((BNDiscoveryPreferences)deviceSys.get("discoveryPreferences"));
        return (BJob)ord.get((BObject)deviceSys);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.discoverCommand, this.delete, this.filterCommand, this.refresh, this.exportCommand, this.learnMode};
    }

    public BComponent[] getAllDevices(Type deviceType, HxOp op) {
        ArrayList<BComponent> list = new ArrayList<BComponent>();
        this.getAllDevices(this.getContainer(op), deviceType, list);
        if (list.size() > 0) {
            return list.toArray(new BComponent[list.size()]);
        }
        return new BComponent[0];
    }

    private void getAllDevices(BComponent comp, Type deviceType, ArrayList<BComponent> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(deviceType)) {
                list.add(kid);
                continue;
            }
            this.getAllDevices(kid, deviceType, list);
        }
    }

    void updateExistenceFacets(BJob job, HxOp op) {
        BComponent[] deviceArr = this.getAllDevices(this.getQueryType(op), op);
        SlotCursor c = job.getProperties();
        while (c.next(BINDiscoveryLeaf.class)) {
            Property prop = c.property();
            BFacets facets = job.getSlotFacets((Slot)prop);
            BINDiscoveryLeaf device = (BINDiscoveryLeaf)job.get(prop);
            BBoolean exists = BBoolean.FALSE;
            for (int i = 0; i < deviceArr.length; ++i) {
                if (!device.isExisting(deviceArr[i])) continue;
                exists = BBoolean.TRUE;
                break;
            }
            job.setFacets((Slot)prop, BFacets.make((BFacets)facets, (String)"dbExistence", (BIDataValue)exists));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessRightName(BUuid uid) {
        String accessRightName = "";
        OrionSession session = null;
        try {
            session = this.getOrionSession();
            BSqlQuery query = BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE);
            BQuery q = query.where(Predicates.eq((String)"accessRightId", (BSimple)uid));
            OrionCursor cursor = session.select(q);
            if (cursor.next()) {
                BAccessRight aR = (BAccessRight)cursor.get();
                accessRightName = aR.getAccessRightName();
            }
        }
        finally {
            this.closeOrionSession(session);
        }
        return accessRightName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroupName(BUuid uuid) {
        String grpName = "";
        OrionSession session = null;
        try {
            session = this.getOrionSession();
            BSqlQuery query = BSqlQuery.make((OrionType)BLdapGroup.ORION_TYPE);
            query.where(Predicates.eq((String)"ldapGroupId", (BSimple)uuid));
            OrionCursor cursor = session.select((BQuery)query);
            if (cursor.next()) {
                BLdapGroup aR = (BLdapGroup)cursor.get();
                grpName = aR.getGroupName();
            }
        }
        finally {
            this.closeOrionSession(session);
        }
        return grpName;
    }

    private OrionSession getOrionSession() {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(null);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    private void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }

    @Override
    public boolean showDiscoveryDialog(HxOp op) {
        BValue preferences = this.getContainer(op).get("discoveryPreferences");
        if (!(preferences instanceof BNDiscoveryPreferences)) {
            return false;
        }
        return !((BNDiscoveryPreferences)preferences).getDoNotAskAgain();
    }

    @Override
    public Tab getDiscoveryPreferencesTab(HxOp op) {
        BValue preferences = this.getContainer(op).get("discoveryPreferences");
        HxOp tabOp = op.make("additionalFields", (BObject)preferences, null);
        SmartCommand.matchReadonly((HxOp)tabOp, (HxOp)op);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, tabOp);
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        if (this.getDiscoveryPreferencesTab(op).process()) {
            return true;
        }
        return super.process(op);
    }

    public class Delete
    extends SmartCommand {
        private Dialog confirm;

        public Delete(BHxView view) {
            super(view, smartTableHxLexModule);
            this.confirm = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.confirm.isSubmit(op)) {
                this.confirm.open(op);
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            Array groupsList = new Array(BSimple.class);
            for (int i = 0; i < selectionList.length; ++i) {
                String ldapGroup = selectionList[i];
                groupsList.add((Object)BUuid.make((String)ldapGroup));
            }
            ExportPersonsDataUtility.deleteLdapGroupDetails((Array)groupsList);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }
    }

    public class DiscoverCommand
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        private Dialog discoverDialog;

        public DiscoverCommand(BHxView view) {
            super(view);
            this.discoverDialog = BHxLdapGroupsView.this.getDiscoverDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "discover";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return LdapValidationUtil.hasImportPrivileges((BUser)op.getUser());
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, Lexicon.make(BHxAbstractManagerView.class).getText("discoveryError"), op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxLdapGroupsView.this.learnMode.update(true, op);
                op.removeCookie(SmartCommand.scopeWithOrd((String)"learnMode", (HxOp)op));
            }
            BHxLdapGroupsView.this.reloadTables(op);
        }

        public void handle(HxOp op) throws Exception {
            if (BHxLdapGroupsView.this.showDiscoveryDialog(op) && this.discoverDialog != null) {
                if (!this.discoverDialog.isSubmit(op)) {
                    this.discoverDialog.open(op);
                    return;
                }
                BHxLdapGroupsView.this.handleDiscoverDialog(op);
            }
            BHxLdapGroupsView.this.discoveryEvent.handle(op);
        }
    }
}

