/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.help;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.help.BHelpDoc;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.baja.file.BIFile;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"entsecHx:HelpDoc"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxHelpDocView
extends BHxView {
    @Generated
    public static final BHxHelpDocView INSTANCE = new BHxHelpDocView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxHelpDocView.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxHelpDocView() {
    }

    public String getPageTitle(HxOp op) {
        String title = (String)op.getRequest().getSession().getAttribute("helpTitle");
        if (title != null) {
            op.getRequest().getSession().removeAttribute("helpTitle");
            return title;
        }
        return BEnterpriseSecurityService.lex.getText("help");
    }

    public void write(HxOp op) throws Exception {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        String module = service.getBrandingManager().getHelpModule().toString();
        op.addStyleSheet(BOrd.make((String)(module + "/document.css")));
        op.addStyleSheet(BOrd.make((String)(module + "/vsaHelp.css")));
        op.addStyleSheet(BOrd.make((String)(module + "/dmc.css")));
        op.addStyleSheet(BOrd.make((String)(module + "/styler.css")));
        String fileName = ((BHelpDoc)op.get()).getFileName();
        try {
            this.writeHelpFile(module, fileName, op.getHtmlWriter(), op);
        }
        catch (UnresolvedException e) {
            BEnterpriseSecurityService.LOG.warning("Can't resolve help file " + fileName);
            this.writeHelpFile(module, "TOC.html", op.getHtmlWriter(), op);
        }
    }

    private void writeHelpFile(String module, String fileName, HtmlWriter out, HxOp op) throws Exception {
        String ordstr = module + "/" + fileName;
        BIFile file = (BIFile)BOrd.make((String)ordstr).get();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            out.w((Object)"<span class='help'>").nl();
            boolean inBody = false;
            String line = in.readLine();
            while (line != null) {
                if (inBody) {
                    if (line.trim().equals("</body>")) break;
                    line = TextUtil.replace((String)line, (String)" src=\"images/", (String)(" src=\"" + module + "/images/"));
                    line = TextUtil.replace((String)line, (String)" src=\"graphics/", (String)(" src=\"" + module + "/graphics/"));
                    line = TextUtil.replace((String)line, (String)" href=\"", (String)" href=\"accessHelp:/");
                    out.w((Object)line).nl();
                } else if (line.trim().startsWith("<body")) {
                    inBody = true;
                }
                if (line.trim().startsWith("<title>")) {
                    int start = line.trim().indexOf("<title>") + 7;
                    int end = line.trim().indexOf("</title>");
                    String title = line.trim().substring(start, end);
                    op.getRequest().getSession().setAttribute("helpTitle", (Object)title);
                }
                line = in.readLine();
            }
            out.w((Object)"</span>").nl();
        }
    }
}

