/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.filter;

import com.tridium.hx.util.HxUtils;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsecHx.filter.BHxSmartOrdListTable;
import com.tridiumx.entsecHx.filter.SummaryCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQuery;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxSmartOrdListFE
extends BHxFieldEditor {
    @Generated
    public static final BHxSmartOrdListFE INSTANCE = new BHxSmartOrdListFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSmartOrdListFE.class);
    public static char SUBSTITUTE = (char)32;
    public static final String UPDATE = "update";
    public static final String SHOW_CHOOSER = "showChooser";
    protected SmartCommand chooser = new Chooser((BHxView)this);
    protected SmartCommand clear;
    protected SmartCommand summary;
    protected SmartCommand hyperlink;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSmartOrdListFE() {
        this.registerEvent((Event)this.chooser);
        this.summary = new Summary((BHxView)this);
        this.registerEvent((Event)this.summary);
        this.clear = new Clear((BHxView)this);
        this.registerEvent((Event)this.clear);
        this.hyperlink = new Hyperlink((BHxView)this);
        this.registerEvent((Event)this.hyperlink);
    }

    public Type getTargetType(HxOp op) {
        String targetType = op.getFacets().gets("targetType", BComponent.TYPE.toString());
        return BTypeSpec.make((String)targetType).getResolvedType();
    }

    public BOrd getQueryBase(HxOp op) {
        String queryBase = op.getFacets().gets("base", null);
        if (queryBase != null) {
            return BOrd.make((String)queryBase);
        }
        return null;
    }

    public void write(HxOp op) throws Exception {
        boolean canReadOrd = true;
        BOrdList ordList = (BOrdList)op.get();
        boolean showPreview = op.getFacets().getb("showPreview", true);
        boolean showChooser = op.getFacets().getb(SHOW_CHOOSER, true);
        int width = ((BInteger)op.getFacets().get("fieldWidth", (BObject)BInteger.make((int)36))).getInt();
        HtmlWriter out = op.getHtmlWriter();
        Type type = this.getTargetType(op);
        BHxSmartTableView.writeFormValue((String)"value", (String)BHxSmartOrdListFE.encodeToSafeString(ordList, op), (HxOp)op);
        if (!showPreview) {
            out.w((Object)"<span style='display:none;'>");
        }
        HxTabUtil.writeImageCommand((SmartCommand)this.hyperlink, (HxOp)op);
        out.w((Object)" <input ");
        out.attr("type", "text");
        out.attr("size", "" + width);
        out.attr("readonly", "readonly");
        out.attr("locked", "locked");
        HxTabUtil.scope((String)"preview", (HtmlWriter)out, (HxOp)op);
        if (!canReadOrd) {
            out.attr("value", "--not privileged--");
        } else {
            out.attr("value", this.getPreview(ordList, op));
        }
        out.w((Object)"/>");
        if (!showPreview) {
            out.w((Object)"</span>");
        }
        if (op.canWrite() && showChooser) {
            HxTabUtil.writeImageCommand((SmartCommand)this.chooser, (HxOp)op);
        }
        if (canReadOrd) {
            out.w((Object)"<span ");
            HxTabUtil.scope((String)"summary", (HtmlWriter)out, (HxOp)op);
            out.attr("title", this.summary.getDisplayName(op));
            if (ordList.isNull()) {
                out.attr("style", "display:none;cursor:pointer");
            } else {
                out.attr("style", "cursor:pointer;");
            }
            out.w((Object)("onclick='" + this.summary.getInvokeCode(op)));
            out.w((Object)"'> ");
            HxUtil.makeImageJS((BImage)this.summary.getIcon(op), (HxOp)op);
            out.w((Object)"</span>");
        }
        if (showPreview) {
            out.w((Object)"<span ");
            HxTabUtil.scope((String)"clear", (HtmlWriter)out, (HxOp)op);
            if (ordList.isNull() || !op.canWrite()) {
                out.attr("style", "display:none;cursor:pointer");
            } else {
                out.attr("style", "cursor:pointer;");
            }
            out.attr("title", this.clear.getDisplayName(op));
            out.attr("style", "cursor:pointer;");
            out.w((Object)("onclick='" + this.clear.getInvokeCode(op)));
            out.w((Object)"'> ");
            HxUtil.makeImageJS((BImage)this.clear.getIcon(op), (HxOp)op);
            out.w((Object)"</span>");
        }
    }

    public String getPreview(BOrdList ordList, HxOp op) {
        int size = ordList.size();
        if (size > 0) {
            return "" + ordList.size() + " " + HxTabUtil.getPluralDisplayName((Type)this.getTargetType(op), (Context)op);
        }
        return HxTabUtil.getNoneText((Context)op);
    }

    public static String encodeToSafeString(BOrdList ordList, HxOp op) throws Exception {
        String encoding = ordList.encodeToString();
        encoding = TextUtil.replace((String)encoding, (String)"\n", (String)("" + SUBSTITUTE));
        return encoding;
    }

    public static BOrdList decodeFromSafeString(String encoding, HxOp op) throws Exception {
        encoding = TextUtil.replace((String)encoding, (String)("" + SUBSTITUTE), (String)"\n");
        return (BOrdList)BOrdList.DEFAULT.decodeFromString(encoding);
    }

    public BObject save(HxOp op) throws Exception {
        String ordForm = op.getFormValue("value");
        BOrdList ordList = BHxSmartOrdListFE.decodeFromSafeString(ordForm, op);
        return ordList;
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        if (this.chooser.process(op)) {
            return true;
        }
        if (this.summary.process(op)) {
            return true;
        }
        return this.clear.process(op);
    }

    public static BOrdList makeOrdList(BOrdList list, BComplex[] complexes) {
        Array a = new Array((Object[])list.toArray());
        for (int i = 0; i < complexes.length; ++i) {
            a.add((Object)complexes[i].asComponent().getSlotPathOrd());
        }
        return BOrdList.make((BOrd[])((BOrd[])a.trim()));
    }

    public static BOrdList makeRemoveOrdList(BOrdList list, BComplex[] complexes) {
        Array a = new Array((Object[])list.toArray());
        for (int i = 0; i < complexes.length; ++i) {
            a.remove((Object)complexes[i].asComponent().getSlotPathOrd());
        }
        return BOrdList.make((BOrd[])((BOrd[])a.trim()));
    }

    public static void setModified(HxOp op) throws Exception {
        SaveCommand.setModified((HxOp)op);
        if (op.getFacets().getb(UPDATE, false)) {
            HxUtils.forceUpdate((HxOp)op);
        }
    }

    public Tab getDialogTab(HxOp op) {
        BQuery table = QueryUtil.makeQuery((BTypeSpec)this.getTargetType(op).getTypeSpec());
        BOrd queryBase = this.getQueryBase(op);
        if (queryBase != null) {
            table.add("base", (BValue)queryBase);
        }
        HxOp fieldOp = op.make("ordChooser", (BObject)table, BHxSmartTableView.makeHeightFacets((int)300));
        op.getRequest().setAttribute(fieldOp.scope("parentOp"), (Object)op);
        op.getRequest().setAttribute(fieldOp.scope("parentView"), (Object)this);
        return new Tab((BHxView)BHxSmartOrdListTable.INSTANCE, fieldOp);
    }

    public Tab getTestTab(HxOp op) throws Exception {
        BOrdList list = (BOrdList)this.save(op);
        HxOp ordChooserOp = op.make("ordChooser", (OrdTarget)op);
        BFacets facets = BFacets.make((BFacets)op.getFacets(), (String)"showPreview", (BIDataValue)BBoolean.TRUE);
        facets = BFacets.make((BFacets)facets, (String)SHOW_CHOOSER, (BIDataValue)BBoolean.FALSE);
        HxOp fieldOp = ordChooserOp.make("test", (BObject)list, facets);
        return new Tab((BHxView)INSTANCE, fieldOp);
    }

    public class Chooser
    extends ToggleCommand {
        private ChooserDialog dlg;

        public Chooser(BHxView view) {
            super(view);
            this.dlg = new ChooserDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "ordChooser";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            if (BHxSmartOrdListFE.this.getDialogTab(op).process()) {
                return true;
            }
            return BHxSmartOrdListFE.this.getTestTab(op).process();
        }

        public boolean isSelected(HxOp op) {
            BOrdList ordList = (BOrdList)op.get();
            try {
                ordList = (BOrdList)BHxSmartOrdListFE.this.save(op);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return !ordList.isNull();
        }

        public boolean handle(boolean selected, HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return selected;
            }
            Tab tab = BHxSmartOrdListFE.this.getDialogTab(op);
            BHxSmartOrdListTable sView = (BHxSmartOrdListTable)tab.view;
            BComplex[] o = (BComplex[])BHxQueryTableView.getSubjects(tab.op);
            Tab testTab = BHxSmartOrdListFE.this.getTestTab(op);
            boolean isBound = false;
            if (o.length == 0) {
                if (!testTab.op.getFormValue("preview").equals(HxTabUtil.getNoneText((Context)op))) {
                    isBound = true;
                }
                SmartCommand.setFormValue((String)op.scope("preview"), (Object)testTab.op.getFormValue("preview"), (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("value"), (Object)testTab.op.getFormValue("value"), (HxOp)op);
            } else {
                BOrdList ordList = (BOrdList)testTab.save();
                isBound = !(ordList = BHxSmartOrdListFE.makeOrdList(ordList, o)).isNull();
                SmartCommand.setFormValue((String)op.scope("preview"), (Object)((BHxSmartOrdListFE)this.getView()).getPreview(ordList, op), (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("value"), (Object)BHxSmartOrdListFE.encodeToSafeString(ordList, op), (HxOp)op);
            }
            if (isBound) {
                SmartCommand.show((String)op.scope("summary"), (HxOp)op);
            } else {
                SmartCommand.hide((String)op.scope("summary"), (HxOp)op);
            }
            SmartCommand.tryException((HxOp)op);
            SmartCommand.show((String)op.scope("clear"), (HxOp)op);
            SmartCommand.catchException((HxOp)op);
            BHxSmartOrdListFE.setModified(op);
            return isBound;
        }

        class ChooserDialog
        extends Dialog {
            public ChooserDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BHxSmartOrdListFE.this.getTestTab(op).write();
                Tab tab = BHxSmartOrdListFE.this.getDialogTab(op);
                tab.write();
            }
        }
    }

    public class Hyperlink
    extends SmartCommand {
        public Hyperlink(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public String getName(HxOp op) {
            return "hyperlink";
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public BImage getIcon(HxOp op) {
            try {
                return BImage.make((BIcon)BHxSmartOrdListFE.this.getTargetType(op).getInstance().getIcon());
            }
            catch (Throwable e) {
                return BImage.make((BIcon)BIcon.std((String)"object.png"));
            }
        }

        public void handle(HxOp op) throws Exception {
            String value = op.getFormValue("value");
            BOrdList ordList = BHxSmartOrdListFE.decodeFromSafeString(value, op);
            if (ordList.isNull()) {
                return;
            }
            BOrd ord = BOrd.make((String)("station:|" + ordList.get(0)));
            this.redirect(op, op.toUri(ord));
        }
    }

    public class Summary
    extends SummaryCommand {
        public Summary(BHxView view) {
            super(view);
        }

        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            String value = op.getFormValue("value");
            BOrdList ordList = BHxSmartOrdListFE.decodeFromSafeString(value, op);
            return ordList;
        }
    }

    public class Clear
    extends SmartCommand {
        private ConfirmDialog dlg;

        public Clear(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this, Lexicon.make(((Object)((Object)this)).getClass()).getText("clearOrdQuestion"));
        }

        public String getName(HxOp op) {
            return "clear";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            boolean confirm = op.getFacets().getb("confirmClear", false);
            if (confirm && !this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BOrdList ordList = (BOrdList)op.get();
            BOrdList nullOrd = BOrdList.DEFAULT;
            SmartCommand.setFormValue((String)op.scope("preview"), (Object)HxTabUtil.getNoneText((Context)op), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("value"), (Object)nullOrd.encodeToString(), (HxOp)op);
            SmartCommand.hide((String)op.scope("summary"), (HxOp)op);
            SmartCommand.hide((String)op.scope("clear"), (HxOp)op);
            BHxSmartOrdListFE.setModified(op);
        }
    }
}

