/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.factory.network;

import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsecHx.factory.network.BHxDeviceManagerView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import javax.baja.sys.Type;

public abstract class AbstractNetworkBuilder {
    protected BHxDeviceManagerView deviceManagerView;
    protected boolean discoverySupported = false;
    protected Type deviceType;
    protected Type deviceLearnEntryType;
    protected Type restrictToDeviceType;
    protected SmartCommand[] networkCommands;
    protected SmartCommand[] learnCommands;
    protected String uniqueProperty;

    public void buildNetwork() {
        this.buildDeviceManagerView();
    }

    public static AbstractNetworkBuilder make() {
        return new ConcreteNetworkBuilder();
    }

    protected abstract void buildDeviceManagerView();

    public BHxAbstractManagerView getDeviceManagerView() {
        return this.deviceManagerView;
    }

    public AbstractNetworkBuilder supportsDeviceDiscovery(boolean discoverySupported) {
        this.discoverySupported = discoverySupported;
        return this;
    }

    public AbstractNetworkBuilder networkDeviceType(Type deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public AbstractNetworkBuilder learnedDeviceType(Type deviceLearnEntryType) {
        this.deviceLearnEntryType = deviceLearnEntryType;
        return this;
    }

    public AbstractNetworkBuilder restrictToDeviceType(Type restrictedDeviceType) {
        this.restrictToDeviceType = restrictedDeviceType;
        return this;
    }

    public AbstractNetworkBuilder uniqueProperty(String propertyName) {
        this.uniqueProperty = propertyName;
        return this;
    }

    public AbstractNetworkBuilder networkCommands(SmartCommand[] networkCommands) {
        this.networkCommands = networkCommands;
        return this;
    }

    public AbstractNetworkBuilder learnCommands(SmartCommand[] learnCommands) {
        this.learnCommands = learnCommands;
        return this;
    }

    private static class ConcreteNetworkBuilder
    extends AbstractNetworkBuilder {
        @Override
        protected void buildDeviceManagerView() {
            this.deviceManagerView = BHxDeviceManagerView.INSTANCE;
            this.deviceManagerView.setSupportsDiscovery(this.discoverySupported);
            this.deviceManagerView.setDeviceType(this.deviceType);
            this.deviceManagerView.setDeviceLearnType(this.deviceLearnEntryType);
            this.deviceManagerView.setRestrictedDeviceType(this.restrictToDeviceType);
            this.deviceManagerView.setUniqueProperty(this.uniqueProperty);
            this.deviceManagerView.setNetworkCommands(this.networkCommands);
            this.deviceManagerView.setLearnCommands(this.learnCommands);
        }
    }
}

