/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.backup;

import com.tridium.backup.BBackupRecord;
import com.tridium.hx.ErrorDialog;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.export.BExportFileScheme;
import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.backup.BBackupFileTable;
import com.tridiumx.entsec.backup.BLocalBackupJob;
import com.tridiumx.entsec.backup.BSystemBackupJob;
import com.tridiumx.entsec.backup.BSystemBackups;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsecHx.backup.BHxBackupFileTableView;
import com.tridiumx.entsecHx.backup.BHxBackupRecordsView;
import com.tridiumx.entsecHx.securityUtilHx.RedirectCommand;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:SystemBackups"}, app="entsec", requiredPermissions="W")})
@NiagaraSingleton
public class BHxSystemBackupsView
extends BHxAbstractJobView {
    static final Lexicon lex = Lexicon.make(BHxSystemBackupsView.class);
    @Generated
    public static final BHxSystemBackupsView INSTANCE = new BHxSystemBackupsView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSystemBackupsView.class);
    public SmartCommand systemBackupCommand = new SystemBackupCommand((BHxView)this);
    public SmartCommand localBackupCommand;
    public SmartCommand restoreCommand;
    public SmartCommand restoreFromFileCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSystemBackupsView() {
        this.registerEvent((Event)this.systemBackupCommand);
        this.localBackupCommand = new LocalBackupCommand((BHxView)this);
        this.registerEvent((Event)this.localBackupCommand);
        this.restoreCommand = new RestoreCommand((BHxView)this);
        this.registerEvent((Event)this.restoreCommand);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        if (BEnterpriseSecurityService.isWorkstation()) {
            return new SmartCommand[]{this.save, this.systemBackupCommand, this.localBackupCommand, this.restoreCommand};
        }
        return new SmartCommand[]{this.localBackupCommand, this.restoreCommand};
    }

    public String getPageTitle(HxOp op) throws Exception {
        return Lexicon.make(BSystemBackups.class).getText("nav.systemBackups");
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        if (op.getRequest().getSession().getAttribute("backupJob") != null) {
            return super.save(op);
        }
        if (BEnterpriseSecurityService.isWorkstation()) {
            return this.getTab(op).save();
        }
        return op.get();
    }

    @Override
    public void saved(HxOp op) throws Exception {
        this.save.refresh(op);
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        Object backupJob = op.getRequest().getSession().getAttribute("backupJob");
        if (backupJob == null) {
            return null;
        }
        op.getRequest().getSession().setAttribute("backupJob", null);
        BComponent c = this.getSavedComponent(op);
        BJob job = (BJob)backupJob;
        BOrd jobOrd = job.submit((Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    @Override
    public void jobSuccess(BJob job, Command progressCommand, HxOp op) throws Exception {
        if (job.get("displayed") != null) {
            return;
        }
        job.add("displayed", (BValue)BBoolean.TRUE, 4);
        BExportFileWrapper[] wrappers = (BExportFileWrapper[])job.getChildren(BExportFileWrapper.class);
        if (wrappers.length == 0) {
            super.jobSuccess(job, progressCommand, op);
            return;
        }
        if (wrappers.length == 1) {
            BExportFileScheme.addWrapper((BExportFileWrapper)wrappers[0]);
            if (BHxSystemBackupsView.shouldOpenDialog(job)) {
                new JobLogDialogDownload(progressCommand, job, null, wrappers[0].getNavOrd()).open(op);
            }
            job.remove(wrappers[0].getPropertyInParent());
        }
    }

    @Override
    public String getJobTitle() {
        return lex.getText("job");
    }

    @Override
    public Tab getTab(HxOp op) throws Exception {
        return this.getPropertyTab(op);
    }

    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab tab = super.getPropertyTab(op);
        tab.title = lex.getText("backupSchedule");
        return tab;
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Array a = new Array(Tab.class);
        if (BEnterpriseSecurityService.isWorkstation()) {
            a.add((Object)new Tab((BHxView)BHxBackupFileTableView.INSTANCE, lex.getText("backupArchive"), op.make("files", (BObject)new BBackupFileTable(), null)));
            a.add((Object)this.getPropertyTab(op));
        }
        BQuery query = QueryUtil.makeQuery((BTypeSpec)BBackupRecord.TYPE.getTypeSpec());
        query.add("base", (BValue)BOrd.make((String)"service:backup:BackupService"));
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        a.add((Object)new Tab((BHxView)BHxBackupRecordsView.INSTANCE, lex.getText("recentBackupHistory"), op.make("history", (BObject)query, null)));
        return (Tab[])a.trim();
    }

    public class RestoreCommand
    extends RedirectCommand {
        public RestoreCommand(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxSystemBackupsView.lex.module));
        }

        @Override
        public String getName(HxOp op) {
            return "restore";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public String getPath(HxOp op) {
            return op.toUri(BOrd.make((String)"service:entsec:EnterpriseSecurityService|slot:systemBackups|view:entsecHx:HxRestoreFromFile"));
        }

        @Override
        public String getStationName(HxOp op) {
            return null;
        }

        @Override
        public String getHostName(HxOp op) {
            return null;
        }
    }

    public class LocalBackupCommand
    extends BHxTabbedView.Save {
        private SystemBackupDialog dlg;

        public LocalBackupCommand(BHxView view) {
            super((BHxTabbedView)BHxSystemBackupsView.this, view);
            this.dlg = new SystemBackupDialog(this.getDisplayName(null), (Command)this);
            this.lexModule = LexiconModule.make((String)"entsecHx");
        }

        public String getName(HxOp op) {
            return "localBackup";
        }

        public boolean startsEnabled(HxOp op) {
            return true;
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getHtmlElementName(HxOp op) {
            return "localBackup";
        }

        public void onHandle(HxOp op) throws Exception {
            boolean archive = false;
            boolean download = true;
            if (BEnterpriseSecurityService.isWorkstation()) {
                if (!this.dlg.isSubmit(op)) {
                    this.dlg.open(op);
                    return;
                }
                if (op.getFormValue("archive") == null && op.getFormValue("download") == null) {
                    new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception("Please Select at least 1 backup option."), null).open(op);
                    return;
                }
                archive = op.getFormValue("archive") != null;
                download = op.getFormValue("download") != null;
            }
            BLocalBackupJob job = new BLocalBackupJob(false, false, archive, download);
            op.getRequest().getSession().setAttribute("backupJob", (Object)job);
            super.onHandle(op);
        }
    }

    public class SystemBackupDialog
    extends Dialog {
        public SystemBackupDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<input ").attr("name", op.scope("archive")).w((Object)" ").attr("id", op.scope("archive")).w((Object)" ").attr("type", "checkbox").w((Object)" ").attr("checked", "checked").w((Object)" ").w((Object)"/> ");
            out.safe((Object)lex.getText("archiveQuestion"));
            out.w((Object)"<br/>");
            out.w((Object)"<input ").attr("name", op.scope("download")).w((Object)" ").attr("id", op.scope("download")).w((Object)" ").attr("type", "checkbox").w((Object)" ").attr("checked", "checked").w((Object)" ").w((Object)"/> ");
            out.safe((Object)lex.getText("downloadQuestion"));
        }
    }

    public class SystemBackupCommand
    extends BHxTabbedView.Save {
        private SystemBackupDialog dlg;

        public SystemBackupCommand(BHxView view) {
            super((BHxTabbedView)BHxSystemBackupsView.this, view);
            this.dlg = new SystemBackupDialog(this.getDisplayName(null), (Command)this);
            this.lexModule = LexiconModule.make((String)"entsecHx");
        }

        public String getName(HxOp op) {
            return "systemBackup";
        }

        public boolean startsEnabled(HxOp op) {
            return true;
        }

        public boolean registerOnInputs() {
            return false;
        }

        public String getHtmlElementName(HxOp op) {
            return "systemBackup";
        }

        public void onHandle(HxOp op) throws Exception {
            if (!BEnterpriseSecurityService.isWorkstation()) {
                throw new IllegalStateException("Must run System Backup on Workstation.");
            }
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            if (op.getFormValue("archive") == null && op.getFormValue("download") == null) {
                new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception("Please Select at least 1 backup option."), null).open(op);
                return;
            }
            boolean archive = op.getFormValue("archive") != null;
            boolean download = op.getFormValue("download") != null;
            BSystemBackupJob job = new BSystemBackupJob(false, true, archive, download);
            op.getRequest().getSession().setAttribute("backupJob", (Object)job);
            super.onHandle(op);
        }
    }

    public static class JobLogDialogDownload
    extends JobLogDialog {
        private BOrd redirect;

        public JobLogDialogDownload(Command command, BJob job, String title, BOrd redirect) {
            super(command, job, title);
            this.redirect = redirect;
        }

        public Command[] getCommands() {
            return new Command[]{new DoneRefresh()};
        }

        protected class DoneRefresh
        extends Dialog.Cancel {
            public DoneRefresh() {
                super((Dialog)JobLogDialogDownload.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("download");
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                if (JobLogDialogDownload.this.redirect == null) {
                    b.append("window.location.reload(true);");
                } else {
                    b.append("window.location=&quot;").append(op.toUri(JobLogDialogDownload.this.redirect)).append("&quot;;");
                }
                return b.toString();
            }
        }
    }
}

