/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.schedule;

import com.tridium.schedule.ScheduleUtil;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsecHx.access.schedule.BHxSpecialEventsTable;
import com.tridiumx.entsecHx.access.schedule.BHxWeeklyScheduler;
import com.tridiumx.entsecHx.access.schedule.ViewUtil;
import java.util.logging.Logger;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxSpecialEventsView
extends BHxView {
    @Generated
    public static final BHxSpecialEventsView INSTANCE = new BHxSpecialEventsView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSpecialEventsView.class);
    protected static final Logger LOG = Logger.getLogger("schedule");
    protected SmartCommand delete;
    protected SmartCommand allDay = new ViewUtil.AllDay(this);
    protected SmartCommand clearDay;
    protected SmartCommand copyDay;
    protected SmartCommand pasteDay;
    protected Command fixEvents;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSpecialEventsView() {
        this.registerEvent((Event)this.allDay);
        this.clearDay = new ViewUtil.ClearDay(this);
        this.registerEvent((Event)this.clearDay);
        this.delete = new ViewUtil.Delete(this);
        this.registerEvent((Event)this.delete);
        this.copyDay = new ViewUtil.CopyDay(this);
        this.registerEvent((Event)this.copyDay);
        this.pasteDay = new ViewUtil.PasteDay(this);
        this.registerEvent((Event)this.pasteDay);
        this.fixEvents = new FixEvents(this);
        this.registerEvent((Event)this.fixEvents);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.delete, this.allDay, this.clearDay, this.copyDay, this.pasteDay};
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        return this.getTab(op).process();
    }

    public Tab getTab(HxOp op) {
        HxOp tableOp = op.make("table", (OrdTarget)op);
        SmartCommand.matchReadonly((HxOp)tableOp, (HxOp)op);
        return new Tab((BHxView)BHxSpecialEventsTable.INSTANCE, tableOp);
    }

    public void write(HxOp op) throws Exception {
        Lexicon lex = ViewUtil.getScheduleLexicon(op);
        BWeeklySchedule opSchedule = (BWeeklySchedule)op.get();
        if (opSchedule.isMounted() && Flags.isReadonly((BComplex)opSchedule.getParent(), (Slot)opSchedule.getPropertyInParent())) {
            op.setReadonly(true);
        }
        BWeeklySchedule schedule = (BWeeklySchedule)opSchedule.newCopy();
        op.getRequest().getSession().setAttribute(op.scope("working"), (Object)schedule);
        op.mergeFacets(schedule.getFacets());
        ViewUtil.addHeaders(op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table style='width:80%'><tr valign='top'><td style='width:80%'>");
        Tab tab = this.getTab(op);
        tab.write();
        String quote = "'";
        BHxSmartTableView.writeFormValue((String)"fixCommandEvent", (String)SmartCommand.getInvokeCode((Command)this.fixEvents, (String)quote, (HxOp)op), (HxOp)tab.op);
        out.w((Object)"</td><td>");
        op.mergeFacets(BFacets.make((String)"noTitle", (boolean)true));
        ViewUtil.addOnloadReadOnly(op);
        ViewUtil.addOnloadInit(op);
        ViewUtil.addOnloadNullStatus(op, lex);
        ViewUtil.writeCommands(this.getButtonCommands(op), op, out);
        ViewUtil.writeTemplateDiv(schedule, op, out);
        ViewUtil.writeScheduleTableStart(op, out);
        out.w((Object)"<td>");
        ViewUtil.writeDayGridBoxStart("7", lex.getText("events"), op, out);
        out.w((Object)"</div>");
        out.w((Object)"</div>");
        out.w((Object)"</td>");
        SmartCommand.setFormValue((String)op.scope("day7"), (Object)"", (boolean)true, (boolean)false, (boolean)true, (HxOp)op);
        ViewUtil.writeScheduleTableEnd(true, op, out, lex);
        out.w((Object)"</td></tr></table>");
    }

    public BObject save(HxOp op) throws Exception {
        Tab tab = this.getTab(op);
        BWeeklySchedule schedule = (BWeeklySchedule)op.getRequest().getSession().getAttribute(op.scope("working"));
        if (schedule == null) {
            return op.get();
        }
        String lastSpecialEvent = tab.op.getFormValue("lastSpecialEvent");
        if (lastSpecialEvent != null && !lastSpecialEvent.isEmpty()) {
            BDailySchedule dailySchedule = (BDailySchedule)schedule.getSpecialEvents().get(lastSpecialEvent);
            BStatusValue defaultStatusValue = schedule.getDefaultOutput();
            defaultStatusValue.setStatus(BStatus.ok);
            BHxWeeklyScheduler.saveEvents(dailySchedule.getDay(), op.getUnsafeFormValue("day7"), defaultStatusValue, op);
        }
        BWeeklySchedule opSchedule = (BWeeklySchedule)op.get();
        ScheduleUtil.validateSchedule((BAbstractSchedule)opSchedule, (Context)op);
        if (opSchedule != null && opSchedule.getSpecialEvents() != null && schedule != null) {
            try {
                ScheduleUtil.stationSideAuditableCopyFrom((BAbstractSchedule)opSchedule.getSpecialEvents(), (BAbstractSchedule)schedule.getSpecialEvents(), (Context)op);
            }
            catch (Exception e) {
                opSchedule.getSpecialEvents().copyFrom((BAbstractSchedule)schedule.getSpecialEvents(), (Context)op);
                LOG.warning("Schedule saved, but detailed audit is not available");
            }
        }
        op.getRequest().getSession().setAttribute(op.scope("working"), (Object)opSchedule.newCopy());
        return opSchedule;
    }

    public class FixEvents
    extends Command {
        public FixEvents(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            Tab tab = BHxSpecialEventsView.this.getTab(op);
            String[] propNames = SmartCommand.getSelectionList((HxOp)tab.op);
            BWeeklySchedule schedule = (BWeeklySchedule)op.getRequest().getSession().getAttribute(op.scope("working"));
            op.mergeFacets((BFacets)schedule.get("facets"));
            HtmlWriter out = op.getHtmlWriter();
            String lastSpecialEvent = tab.op.getFormValue("lastSpecialEvent");
            if (lastSpecialEvent != null && !lastSpecialEvent.isEmpty()) {
                BDailySchedule dailySchedule = (BDailySchedule)schedule.getSpecialEvents().get(lastSpecialEvent);
                BHxWeeklyScheduler.saveEvents(dailySchedule.getDay(), op.getUnsafeFormValue("day7"), schedule.getDefaultOutput(), op);
            }
            out.w((Object)("schedule.clearDayNoModify(smartTable.$$('" + op.scope("7") + "'), null, '" + op.getPath() + "');"));
            if (propNames.length == 1) {
                String simpleName = propNames[0].substring(tab.op.getPath().length() + 1);
                BDailySchedule dailySchedule = (BDailySchedule)schedule.getSpecialEvents().get(simpleName);
                StringBuilder formValue = new StringBuilder();
                for (BTimeSchedule time : (BTimeSchedule[])dailySchedule.getDay().getChildren(BTimeSchedule.class)) {
                    BTime start = time.getStart();
                    BTime finish = time.getFinish();
                    float top = ViewUtil.calcTop(start);
                    float height = ViewUtil.calcHeight(finish, top);
                    BStatusValue statusValue = time.getEffectiveValue();
                    boolean isStatusNull = statusValue.getStatus().isNull();
                    BValue valueValue = statusValue.getValueValue();
                    String valueWithoutUnits = ViewUtil.getValueWithoutUnits(valueValue, op);
                    out.w((Object)("schedule.createDiv(smartTable.$$('" + op.scope("7") + "'), '" + op.getPath() + "', " + top + ", " + height + ", " + isStatusNull + ", '" + HxUtil.escapeJsStringLiteral((String)valueWithoutUnits) + "', '" + HxUtil.escapeJsStringLiteral((String)valueValue.toString((Context)op)) + "');"));
                    ViewUtil.appendFormValue(formValue, start, finish, isStatusNull, valueWithoutUnits);
                }
                SmartCommand.setFormValue((String)op.scope("day7"), (Object)formValue.toString(), (HxOp)op);
                SmartCommand.setFormValue((String)tab.op.scope("lastSpecialEvent"), (Object)simpleName, (HxOp)op);
            } else {
                SmartCommand.setFormValue((String)tab.op.scope("lastSpecialEvent"), (Object)"", (HxOp)op);
            }
        }
    }
}

