/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.PermissionsUtil;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.access.orion.BHxAccessRightJoinFE;
import com.tridiumx.entsecHx.access.orion.BHxBadgeJoinFE;
import com.tridiumx.entsecHx.access.orion.BHxEnrollBadgeView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAddAppView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import com.tridiumx.entsecHx.orionToolsHx.DuplicateCommand;
import com.tridiumx.entsecHx.orionToolsHx.DynamicTableCommand;
import com.tridiumx.entsecHx.photoID.BHxPortraitFE;
import com.tridiumx.entsecHx.photoID.PrintBadgeWizard;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"entsec:Person"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxPersonView
extends BHxAppView
implements BHxAccessProfile.IFullHeight {
    @Generated
    public static final BHxPersonView INSTANCE = new BHxPersonView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxPersonView.class);
    protected SmartCommand addCommand = new AddCommand((BHxView)this);
    protected SmartCommand enrollCommand;
    protected SmartCommand addBadgeCommand;
    protected SmartCommand printBadge;
    protected SmartCommand duplicateCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxPersonView() {
        this.registerEvent((Event)this.addCommand);
        this.addBadgeCommand = new AddBadgeCommand((BHxView)this);
        this.registerEvent((Event)this.addBadgeCommand);
        this.enrollCommand = new EnrollCommand((BHxView)this);
        this.registerEvent((Event)this.enrollCommand);
        this.printBadge = new PrintBadgeWizard((BHxView)this);
        this.registerEvent((Event)this.printBadge);
        this.duplicateCommand = new PersonDuplicateCommand((BHxView)this);
        this.registerEvent((Event)this.duplicateCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        a.add((Object)this.addCommand);
        a.add((Object)this.duplicateCommand);
        a.add((Object)this.addBadgeCommand);
        a.add((Object)this.enrollCommand);
        if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
            a.add((Object)this.printBadge);
        }
        return (SmartCommand[])a.trim();
    }

    public BObject getPropertyObject(HxOp op) throws Exception {
        Property[] copyProps = new Property[]{BPerson.department, BPerson.personType, BPerson.tenant, BPerson.supervisor, BPerson.traceCard};
        return DuplicateCommand.getDuplicatePropertyObject(copyProps, op);
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BPerson person = (BPerson)op.get();
        BHxPersonView.addExtraPersonInfo(person, op);
        BHxTabbedView.PropertyTab propTab = super.getPropertyTab(op);
        Property[] props = person.getPropertiesArray();
        Array a = new Array(String.class);
        for (int i = 0; i < props.length; ++i) {
            if (Flags.isHidden((BComplex)person, (Slot)props[i]) || props[i].getType().is(BUuid.TYPE)) continue;
            if (props[i].getName().equals(BPerson.traceCard.getName())) {
                a.add(a.size() - 1, (Object)props[i].getName());
                continue;
            }
            a.add((Object)props[i].getName());
        }
        this.disableLdapPersonEdit(person, op);
        propTab.op = propTab.op.mergeFacets(BHxFieldSheet.getFieldsProvidedFacets((String[])((String[])a.trim())));
        return propTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableLdapPersonEdit(BPerson person, HxOp op) {
        OrionSession session = null;
        try {
            session = person.getOrionDatabase().createSession(null);
            if (person.getPersonLdapServerJoin(session) != null) {
                Flags.setAllReadonly((BComponent)person, (boolean)true, (Context)op);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtraPersonInfo(BPerson person, HxOp op) {
        OrionSession session = null;
        try {
            session = person.getOrionDatabase().createSession(null);
            BPersonInfo personInfo = person.getPersonInfo(session);
            BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates((OrionSession)session);
            for (int i = 0; i < infoTemplates.length; ++i) {
                BInfoTemplate infoTemplate = infoTemplates[i];
                String value = infoTemplate.getDefaultValue();
                int id = infoTemplate.getInfoTemplateId();
                if (personInfo != null && personInfo.getValue(infoTemplate) != null && personInfo.getValue(infoTemplate).length() != 0) {
                    value = personInfo.getValue(infoTemplate);
                }
                Property prop = person.add(infoTemplate.getInfoTemplateName() + "?", (BValue)BString.make((String)value));
                person.setDisplayName(prop, BFormat.make((String)infoTemplate.getInfoTemplateName()), null);
                if (!infoTemplate.getMultiLine() && !infoTemplate.getSmartSense()) continue;
                Property p = person.getProperty(SlotPath.escape((String)infoTemplate.getInfoTemplateName()));
                BFacets facets = person.getSlotFacets((Slot)p);
                if (infoTemplate.getMultiLine()) {
                    facets = BFacets.make((BFacets)facets, (String)"multiLine", (BIDataValue)BBoolean.TRUE);
                }
                if (infoTemplate.getSmartSense()) {
                    facets = BFacets.make((BFacets)facets, (String)"fieldEditor", (BIDataValue)BString.make((String)"entsecHx:HxSmartPersonInfoFE"));
                }
                person.setFacets((Slot)p, facets);
            }
            if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                BPersonPortrait portrait = person.getPersonPortrait(session);
                BOrd portraitOrd = BOrd.NULL;
                if (portrait != null) {
                    portraitOrd = portrait.getImageOrd();
                }
                BFacets portraitFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)BHxPortraitFE.TYPE.toString()), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"entsecHx:UxPortrait"));
                person.add(BPersonPortrait.getPortraitDisplayName((Context)op), (BValue)portraitOrd, 0, portraitFacets, null);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BPerson person = (BPerson)super.save(op);
        BHxPersonView.saveAdditionalPersonInfo(person, op);
        return person;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAdditionalPersonInfo(BPerson person, HxOp op) {
        OrionSession session = null;
        try {
            BPersonInfo personInfo;
            session = person.getOrionDatabase().createSession((Context)op);
            if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                BPersonPortrait originalPortrait = person.getPersonPortrait(session);
                BOrd savedPortraitOrd = (BOrd)person.get(SlotPath.escape((String)BPersonPortrait.getPortraitDisplayName((Context)op)));
                BPersonPortrait newPortrait = BPersonPortrait.readFromImageOrd((BOrd)savedPortraitOrd, (OrionSession)session);
                if (newPortrait != null) {
                    if (originalPortrait == null || !originalPortrait.getImageId().equals((Object)newPortrait.getImageId())) {
                        newPortrait.setPerson(BRef.make((BIOrionObject)person));
                        session.update((BIOrionObject)newPortrait);
                    }
                } else if (originalPortrait != null) {
                    session.delete((BIOrionObject)originalPortrait);
                }
            }
            if ((personInfo = person.getPersonInfo(session)) == null) {
                personInfo = new BPersonInfo();
                personInfo.setPerson(BRef.make((BIOrionObject)person));
            }
            BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates((OrionSession)session);
            for (int i = 0; i < infoTemplates.length; ++i) {
                BInfoTemplate infoTemplate = infoTemplates[i];
                String value = person.get(SlotPath.escape((String)infoTemplate.getInfoTemplateName())).toString();
                if (value.equals(personInfo.getValue(infoTemplate).toString())) continue;
                personInfo.setValue(infoTemplate, value);
            }
            if (personInfo.isDefault(session)) {
                if (session.exists((BIOrionObject)personInfo)) {
                    session.delete((BIOrionObject)personInfo);
                }
            } else if (session.exists((BIOrionObject)personInfo)) {
                session.update((BIOrionObject)personInfo);
            } else {
                session.insert((BIOrionObject)personInfo);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    @Override
    public Tab[] getFieldEditors(HxOp op) {
        BIOrionObject o = (BIOrionObject)op.get();
        BOrionDatabase db = o.getOrionDatabase();
        Array tabs = new Array(Tab.class);
        BHxAccessRightJoinFE accessRightFE = BHxAccessRightJoinFE.INSTANCE;
        OrdTarget target = new OrdTarget((OrdTarget)op, (BObject)BAccessRight.ORION_TYPE.getOrionTypeId());
        HxOp accessRightOp = op.make("accessRight", target);
        accessRightOp.mergeFacets(BHxSmartTableView.finishLater);
        SmartCommand.matchReadonly((HxOp)accessRightOp, (HxOp)op);
        Tab accessRightTab = new Tab((BHxView)accessRightFE, HxTabUtil.getPluralDisplayName((Type)BAccessRight.ORION_TYPE, (Context)op), accessRightOp);
        if (PermissionsUtil.canReadOrionType((OrionType)BAccessRight.ORION_TYPE, (BOrionDatabase)db, (Context)op)) {
            tabs.add((Object)accessRightTab);
        }
        BHxBadgeJoinFE badgeFE = BHxBadgeJoinFE.INSTANCE;
        target = new OrdTarget((OrdTarget)op, (BObject)BBadge.ORION_TYPE.getOrionTypeId());
        HxOp badgeOp = op.make("badge", target);
        badgeOp.mergeFacets(BHxSmartTableView.finishLater);
        SmartCommand.matchReadonly((HxOp)badgeOp, (HxOp)op);
        Tab badgeTab = new Tab((BHxView)badgeFE, HxTabUtil.getPluralDisplayName((Type)BBadge.ORION_TYPE, (Context)op), badgeOp);
        if (PermissionsUtil.canReadOrionType((OrionType)BBadge.ORION_TYPE, (BOrionDatabase)db, (Context)op)) {
            tabs.add((Object)badgeTab);
        }
        return (Tab[])tabs.trim();
    }

    public class EnrollCommand
    extends AddBadgeCommand {
        public EnrollCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "enrollNewBadge";
        }

        @Override
        public String getTabString(HxOp op) {
            return ";tab=" + BHxEnrollBadgeView.TYPE;
        }
    }

    public class AddBadgeCommand
    extends DynamicTableCommand {
        public AddBadgeCommand(BHxView view) {
            super(view);
        }

        public boolean startsEnabled(HxOp op) {
            if (!super.startsEnabled(op)) {
                return false;
            }
            BReplicableObject o = (BReplicableObject)op.get();
            return !o.getLastModified().equals((Object)BAbsTime.NULL);
        }

        @Override
        public String getName(HxOp op) {
            return "assignNewBadge";
        }

        @Override
        public boolean readonlyEnablePolicy(HxOp op) {
            return false;
        }

        @Override
        public String getDisplayName(HxOp op) {
            return this.getSuperDisplayName(op);
        }

        @Override
        public BTypeSpec getTypeSpec(HxOp op) {
            return BBadge.TYPE.getTypeSpec();
        }

        public String getTabString(HxOp op) {
            return "";
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BAppTable table = this.getTable(op);
            BReplicableObject o = (BReplicableObject)op.get();
            BRef ref = BRef.make((BIOrionObject)o);
            String viewParam = SlotPath.escape((String)ref.encodeToString());
            BOrd ord = BOrd.make((String)("station:|" + table.getSlotPathOrd() + "|view:" + BHxAddAppView.TYPE + "?owner=" + viewParam + this.getTabString(op)));
            this.redirect(op, op.toUri(ord));
        }
    }

    public static class AddCommand
    extends SmartCommand {
        public AddCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "addNewPerson";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            this.redirect(op, op.toUri(BOrd.make((String)("station:|" + service.getSlotPathOrd() + "/personnel|view:" + BHxAddAppView.TYPE))));
        }
    }

    public static class PersonDuplicateCommand
    extends DuplicateCommand {
        public PersonDuplicateCommand(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public BOrionObject getDuplicateRecord(HxOp op) {
            return (BOrionObject)op.get();
        }

        @Override
        public String getTableOrd(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return "station:|" + service.getPersonnel().getSlotPath();
        }
    }
}

