/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.ErrorDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridiumx.accessDriver.BReaderProperty;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import com.tridiumx.entsecHx.access.orion.BHxBadgeView;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraSingleton
public class BHxBatchBadgeView
extends BHxBadgeView {
    @Generated
    public static final BHxBatchBadgeView INSTANCE = new BHxBatchBadgeView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxBatchBadgeView.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxBatchBadgeView() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/join.js"));
        op.addJavaScript(BOrd.make((String)"module://entsecHx/rc/securityUtilHx/select.js"));
        super.write(op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.wiegandFormat.value"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.wiegandFormat.disabledValue"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.wiegandFormat.oldValue"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.enrollmentReader.value"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.enrollmentReader.oldValue"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.scannedBadge.value"), (HxOp)op);
        SmartCommand.addFormElementToPoll((String)op.scope("prop.newBadges.value"), (HxOp)op);
        SmartCommand.hide((String)op.scope("prop.credential"), (HxOp)op);
        SmartCommand.hide((String)op.scope("prop.facilityCode"), (HxOp)op);
        HxUtils.forceUpdate((BRelTime)BRelTime.make((long)1500L), (HxOp)op);
    }

    @Override
    public BObject getPropertyObject(HxOp op) throws Exception {
        BBadge badge = (BBadge)super.getPropertyObject(op);
        badge.setCredential("");
        badge.setFacilityCode("");
        if (badge.getProperty("newBadges") == null) {
            badge.add("newBadges", (BValue)BString.make((String)""), 0, BFacets.make((String)"fieldEditor", (String)"entsecHx:HxBadgePickerFE"), null);
        }
        if (badge.getProperty("scannedBadge") == null) {
            badge.add("scannedBadge", (BValue)BString.make((String)""), 1, BFacets.make((String)"fieldEditor", (String)"entsec:SecStringFE"), null);
        }
        if (badge.getProperty("enrollmentReader") == null) {
            badge.add("enrollmentReader", (BValue)BRef.make((BOrionTypeId)BAccReaderRec.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
        }
        if (HxUtil.isPost((HxOp)op)) {
            String encoded = op.getFormValue("owner.value");
            badge.setOwner((BRef)BRef.DEFAULT.decodeFromString(encoded));
        }
        return badge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HxOp op) throws Exception {
        boolean eraseLastBadge;
        super.update(op);
        String quote = HxUtil.getInnerQuote((HxOp)op);
        HtmlWriter out = op.getHtmlWriter();
        String value = op.getFormValue("prop.enrollmentReader.value");
        String oldValue = op.getFormValue("prop.enrollmentReader.oldValue");
        SmartCommand.setFormValue((String)op.scope("prop.enrollmentReader.oldValue"), (Object)value, (HxOp)op);
        boolean bl = eraseLastBadge = !value.equals(oldValue);
        if (oldValue != null && !oldValue.equals(value)) {
            out.w((Object)("select.clearSelect(" + quote + op.scope("prop.newBadges.value") + quote + ");"));
            SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)"", (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)"", (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("prop.badgeId.value"), (Object)"", (HxOp)op);
        }
        String wiegandFormatValue = op.getFormValue("prop.wiegandFormat.value");
        boolean wiegandSwitch = false;
        String oldWiegandFormatValue = op.getFormValue("prop.wiegandFormat.oldValue");
        SmartCommand.setFormValue((String)op.scope("prop.wiegandFormat.oldValue"), (Object)wiegandFormatValue, (HxOp)op);
        if (oldWiegandFormatValue != null && !oldWiegandFormatValue.equals(wiegandFormatValue)) {
            wiegandSwitch = true;
            out.w((Object)("select.clearSelect(" + quote + op.scope("prop.newBadges.value") + quote + ");"));
            SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)"", (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)"", (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("prop.badgeId.value"), (Object)"", (HxOp)op);
        }
        BOrionDatabase db = BHxBatchBadgeView.getOrionDatabase(op);
        OrionSession session = null;
        try {
            BReaderProperty reader;
            session = db.createSession((Context)op);
            BRef ref = (BRef)BRef.DEFAULT.decodeFromString(value);
            BAccReaderRec rec = (BAccReaderRec)ref.getTarget(session);
            if (rec == null) {
                return;
            }
            if (rec.getStationName().equals(Sys.getStation().getStationName())) {
                reader = (BReaderProperty)rec.getMappedOrd().get();
            } else {
                BFoxSession foxSession = HxRemoteUtil.getEngagedFoxSession(rec.getStationName(), op);
                if (foxSession == null) {
                    SmartCommand.exception((String)op.scope("prop.enrollmentReader"), (String)"Session Unavailable", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.scannedBadge.value"), (Object)"", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)"", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)"", (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.badgeId.value"), (Object)"", (HxOp)op);
                    return;
                }
                reader = (BReaderProperty)RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)rec.getMappedOrd().toString());
                reader.lease();
            }
            if (eraseLastBadge) {
                reader.setLastBadgeRead("");
            }
            String scanned = reader.getLastBadgeRead();
            String oldScanned = op.getFormValue("prop.scannedBadge.value");
            String selectedCard = op.getFormValue("prop.newBadges.value");
            if (!scanned.equals(oldScanned) || wiegandSwitch) {
                SmartCommand.setFormValue((String)op.scope("prop.scannedBadge.value"), (Object)scanned, (HxOp)op);
                if (scanned.length() > 0) {
                    BRef wiegandRef = (BRef)BRef.DEFAULT.decodeFromString(wiegandFormatValue);
                    BWiegandFormat format = (BWiegandFormat)wiegandRef.getTarget(session);
                    if (format == null) {
                        SmartCommand.exception((String)op.scope("prop.wiegandFormat"), (String)"Please Select a Wiegand Format", (HxOp)op);
                        return;
                    }
                    SmartCommand.clearException((String)op.scope("prop.wiegandFormat"), (HxOp)op);
                    SmartCommand.clearException((String)op.scope("prop.scannedBadge"), (HxOp)op);
                    String[] possibleBadgeFormats = reader.getLastBadgePossibleFormats().getNames();
                    if (possibleBadgeFormats.length > 0 && !format.isPossibleBadgeFormat(possibleBadgeFormats)) {
                        SmartCommand.exception((String)op.scope("prop.scannedBadge"), (String)"Scanned badge has a different Wiegand Format", (HxOp)op);
                        return;
                    }
                    BBadge badge = format.getBadge(scanned);
                    if (badge == null) {
                        return;
                    }
                    BBadge checkBadge = new BBadge();
                    checkBadge.setBadgeId(scanned);
                    checkBadge = (BBadge)session.read((BIOrionObject)checkBadge);
                    if (checkBadge != null) {
                        SmartCommand.exception((String)op.scope("prop.scannedBadge"), (String)("Badge Already Exists:  " + checkBadge.toDisplayString((Context)op)), (HxOp)op);
                        return;
                    }
                    SmartCommand.clearException((String)op.scope("prop.scannedBadge"), (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.badgeId.value"), (Object)scanned, (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.credential.value"), (Object)badge.getCredential(), (HxOp)op);
                    SmartCommand.setFormValue((String)op.scope("prop.facilityCode.value"), (Object)badge.getFacilityCode(), (HxOp)op);
                    out.w((Object)("select.addToSelect(" + quote + op.scope("prop.newBadges.value") + quote + "," + quote + badge.getBadgeId() + quote + "," + quote + this.getFormatDescription(badge, format) + quote + ");"));
                    out.w((Object)("join.allSelect(" + quote + op.scope("prop.newBadges.value") + quote + ");"));
                }
            }
            SmartCommand.clearException((String)op.scope("prop.enrollmentReader"), (HxOp)op);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)1500L), (HxOp)op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BObject save(HxOp op) throws Exception {
        String batchBadges = op.getFormValue("prop.newBadges.valueAll");
        if (batchBadges == null) {
            String title = "No Badges to Enroll";
            CannotSaveException e = new CannotSaveException(title);
            new ErrorDialog("Cannot Save", (Command)this.save, (Throwable)new Exception(title)).open(op);
            throw e;
        }
        BObject save = this.getPropertyTab(op).save();
        BBadge template = (BBadge)save;
        BOrionDatabase db = BHxBatchBadgeView.getOrionDatabase(op);
        OrionSession session = null;
        try {
            session = db.createSession((Context)op);
            save = BHxBatchBadgeView.duplicate(template, TextUtil.split((String)batchBadges, (char)'|'), session, op);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return save;
    }

    public static BBadge duplicate(BBadge template, String[] badgeIds, OrionSession session, HxOp op) {
        BWiegandFormat format = template.resolveWiegandFormat(session);
        BBadge badge = null;
        BRef badgeTemplateRef = null;
        if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
            badgeTemplateRef = (BRef)template.get("template");
        }
        for (int i = 0; i < badgeIds.length; ++i) {
            badge = format.getBadge(badgeIds[i]);
            badge.setBDescription(template.getBDescription());
            badge.setStatus(template.getStatus());
            badge.setIssueDate(template.getIssueDate());
            badge.setExpirationDate(template.getExpirationDate());
            badge.setOwner(template.getOwner());
            badge.setTenant(template.getTenant());
            badge.clearAllModified();
            session.persist((BIOrionObject)badge);
            if (badgeTemplateRef == null) continue;
            BHxBatchBadgeView.saveBadgeTemplate(badge, badgeTemplateRef, session);
        }
        return badge;
    }

    public String getFormatDescription(BBadge badge, BWiegandFormat format) {
        return badge.toString() + " " + format.getWiegandFormatName();
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab propTab = super.getPropertyTab(op);
        BBadge badge = (BBadge)op.get();
        Property[] props = new Property[]{BBadge.credential, BBadge.facilityCode};
        BAppView.setReadonly((BOrionObject)badge, (Property[])props);
        return propTab;
    }
}

