/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.maintenance;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.BTenantFilterOptions;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.photoID.orion.BOrionImageFormat;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.HashMap;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.zip.BZipFile;
import javax.baja.hx.HxOp;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@NiagaraType
public class BBatchPersonnelEntryJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchPersonnelEntryJob.class);
    public static final int ITERATIONS = 65536;
    public static final int KEY_SIZE = 32;
    private BTenantFilterOptions tenantFilterOptions = null;
    private String passKey = null;
    HashMap<String, BUuid> fileNameToUuid = new HashMap();
    BIFile file;
    BRef tenantRef;
    BRef wiegandFormatRef;
    BInfoTemplate[] infoTemplates = null;
    int newInfoTemplates = 0;
    HxOp op;
    public static final String USER_TENANTS = "userTenants";
    private final int symmetricKeyIterationCount = 65536;
    private final int keySize = 256;
    private static final String UTF_8 = "UTF-8";
    private static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBatchPersonnelEntryJob() {
    }

    public BBatchPersonnelEntryJob(BIFile file, String passKey, BRef tenantRef, BRef wiegandFormatRef, HxOp op) {
        this.file = file;
        this.tenantRef = tenantRef;
        this.wiegandFormatRef = wiegandFormatRef;
        this.op = op;
        this.tenantFilterOptions = (BTenantFilterOptions)new HxOptionsManager(op).load(BTenantFilterOptions.TYPE);
        this.passKey = passKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        block5: {
            try {
                if (this.file.getExtension().toLowerCase().equals("csv")) {
                    this.importCsv(this.file, cx);
                    break block5;
                }
                if (this.file.getExtension().toLowerCase().equals("zip")) {
                    BZipFile zipFile = (BZipFile)this.file;
                    zipFile.open();
                    BIFile[] files = zipFile.getZipSpace().listFiles();
                    this.importFiles(files, cx);
                    zipFile.close();
                    break block5;
                }
                throw new IllegalStateException("unknown extension:" + this.file);
            }
            finally {
                this.cleanupJob();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFiles(BIFile[] files, Context cx) throws Exception {
        int i;
        for (i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.importFiles(((BIDirectory)files[i]).listFiles(), cx);
                continue;
            }
            if (files[i].getExtension().toLowerCase().equals("csv")) continue;
            if (!BEnterpriseSecurityService.isPhotoIDAvailable((Context)cx)) {
                this.log().failed("Images cannot be processed without a valid BPhotoIDNetwork Database...");
                throw new Exception("Images cannot be processed without a valid BPhotoIDNetwork Database...");
            }
            BIFile pictureFile = files[i];
            String fileName = pictureFile.getFileName();
            String[] split = TextUtil.split((String)pictureFile.getFileName(), (char)'.');
            byte[] bytes = pictureFile.read();
            BUuid uuid = BUuid.make();
            BOrionImageFormat imageFormat = (BOrionImageFormat)BOrionImageFormat.jpg.getRange().get(split[1].toLowerCase());
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            OrionSession session = null;
            try {
                session = service.createSession(null);
                BPersonPortrait personPortrait = new BPersonPortrait();
                if (this.tenantRef != null) {
                    personPortrait.setTenant(this.tenantRef);
                }
                personPortrait.setImageId(uuid);
                personPortrait.setImage(BBlob.make((byte[])bytes));
                personPortrait.setImageFormat(imageFormat);
                session.insert((BIOrionObject)personPortrait);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            this.fileNameToUuid.put(pictureFile.getFileName(), uuid);
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i].getExtension() == null || !files[i].getExtension().toLowerCase().equals("csv")) continue;
            this.importCsv(files[i], cx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importCsv(BIFile file, Context cx) throws Exception {
        Throwable throwable;
        BufferedReader br;
        BAccessControlService serv = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        String importLine = "";
        int lines = 0;
        int newPeople = 0;
        int newPeopleWithoutAccessRights = 0;
        int newBadges = 0;
        int newAccessRights = 0;
        int newTenants = 0;
        int newPeopleAccessJoins = 0;
        int newPeopleInfoJoins = 0;
        int newPeoplePortraits = 0;
        try (InputStream is = file.getInputStream();){
            br = new BufferedReader(new InputStreamReader(is));
            throwable = null;
            try {
                while ((importLine = br.readLine()) != null) {
                    ++lines;
                }
                this.log().message("Processing " + lines + " lines...");
                if (lines == 0) {
                    this.progress(10);
                    return;
                }
                this.progress(10);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        is = file.getInputStream();
        var15_15 = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            throwable = null;
            try {
                String[] columnNames = null;
                OrionSession session = null;
                boolean notifyColumnNotSupported = true;
                try {
                    session = serv.createSession(cx);
                    BTenant userSelectedTenant = (BTenant)this.tenantRef.getTarget(session);
                    BWiegandFormat userSelectedWiegandFormat = (BWiegandFormat)this.wiegandFormatRef.getTarget(session);
                    AesSysKeyEncoder aesSysKeyEncoder = null;
                    this.infoTemplates = BInfoTemplate.getOrderedInfoTemplates((OrionSession)session);
                    int currentLine = 0;
                    while ((importLine = br.readLine()) != null) {
                        try {
                            int i;
                            this.progress(10 + 90 * ++currentLine / lines);
                            if (importLine == null || importLine.trim().length() == 0) continue;
                            importLine = TextUtil.replace((String)importLine, (String)"\"", (String)"");
                            String[] columns = TextUtil.split((String)importLine, (char)',');
                            if (columnNames == null) {
                                columnNames = columns;
                                continue;
                            }
                            boolean defaultPersonInfo = true;
                            BPersonInfo personInfo = new BPersonInfo();
                            BPersonPortrait personPortrait = null;
                            BPerson person = new BPerson();
                            BTenant tenant = userSelectedTenant;
                            HashMap<String, String> accessRightNames = new HashMap<String, String>();
                            HashMap<String, String> startDates = new HashMap<String, String>();
                            HashMap<String, String> endDates = new HashMap<String, String>();
                            HashMap<String, String> assignedThreatLevels = new HashMap<String, String>();
                            HashMap<String, String> wiegandFormatNames = new HashMap<String, String>();
                            HashMap<String, String> credentials = new HashMap<String, String>();
                            HashMap<String, String> facilityCodes = new HashMap<String, String>();
                            HashMap<String, String> badgeStatuses = new HashMap<String, String>();
                            HashMap<String, String> badgeDescriptions = new HashMap<String, String>();
                            HashMap<String, String> issueDates = new HashMap<String, String>();
                            HashMap<String, String> expirationDates = new HashMap<String, String>();
                            boolean addTenant = false;
                            boolean validData = true;
                            boolean hasDuplicateAccessRightColumn = false;
                            for (int i2 = 0; i2 < columns.length; ++i2) {
                                columns[i2] = columns[i2].trim();
                                if (columns[i2].length() == 0) continue;
                                String columnName = TextUtil.fromFriendly((String)columnNames[i2]);
                                if (columnName.toLowerCase().startsWith("credential")) {
                                    String key = columnName.toLowerCase().substring("credential".length());
                                    if (columnName.toLowerCase().startsWith("credentialnumber")) {
                                        key = columnName.toLowerCase().substring("credentialnumber".length());
                                    }
                                    if (credentials.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each Credential column must have its own suffix, 'Credential1','Credential2', etc...");
                                    }
                                    credentials.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("facilitycode")) {
                                    String key = columnName.toLowerCase().substring("facilitycode".length());
                                    if (facilityCodes.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each FacilityCode column must have its own suffix, 'FacilityCode1','FacilityCode2', etc...");
                                    }
                                    facilityCodes.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("wiegandformat")) {
                                    String key = columnName.toLowerCase().substring("wiegandformat".length());
                                    if (wiegandFormatNames.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each WiegandFormat column must have its own suffix, 'WiegandFormat1','WiegandFormat2', etc...");
                                    }
                                    wiegandFormatNames.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("badgestatus")) {
                                    String key = columnName.toLowerCase().substring("badgestatus".length());
                                    if (badgeStatuses.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each BadgeStatus column must have its own suffix, 'BadgeStatus1','BadgeStatus2', etc...");
                                    }
                                    badgeStatuses.put(key, columns[i2].toLowerCase());
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("badgedescription")) {
                                    String key = columnName.toLowerCase().substring("badgedescription".length());
                                    if (badgeDescriptions.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each BadgeDescription column must have its own suffix, 'BadgeDescription1','BadgeDescription2', etc...");
                                    }
                                    badgeDescriptions.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("issuedate")) {
                                    String key = columnName.toLowerCase().substring("issuedate".length());
                                    if (issueDates.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each IssueDate column must have its own suffix, 'IssueDate1','IssueDate2', etc...");
                                    }
                                    issueDates.put(key, columns[i2]);
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("expirationdate")) {
                                    String key = columnName.toLowerCase().substring("expirationdate".length());
                                    if (expirationDates.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each ExpirationDate column must have its own suffix, 'ExpirationDate1','ExpirationDate2', etc...");
                                    }
                                    expirationDates.put(key, columns[i2]);
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("tenant")) {
                                    String tenantName = this.addCommas(columns[i2]);
                                    if (tenantName.length() > 0) {
                                        tenant = this.getTenant(session, tenantName);
                                        if (tenant == null) {
                                            tenant = new BTenant();
                                            tenant.setTenantId(BUuid.make());
                                            tenant.setTenantName(tenantName);
                                            addTenant = true;
                                            continue;
                                        }
                                        if (!this.isMissingTenant((BComponent)tenant, this.op)) continue;
                                        this.log().failed("Cannot import line " + currentLine + ": Tenant '" + tenantName + "'is restricted.");
                                        validData = false;
                                        break;
                                    }
                                    if (!EntsecTenantUtil.hasTenants((Context)this.op)) continue;
                                    this.log().failed("Cannot import line " + currentLine + ": Tenant 'None' is restricted.");
                                    validData = false;
                                    break;
                                }
                                if (columnName.toLowerCase().startsWith("accessright")) {
                                    String key = columnName.toLowerCase().substring("accessright".length());
                                    String accessRightName = this.addCommas(columns[i2]);
                                    if (accessRightNames.containsKey(key)) {
                                        if (key.length() != 0) throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each Access Right column must have its own suffix, 'AccessRight1','AccessRight2', etc...");
                                        hasDuplicateAccessRightColumn = true;
                                        key = "---" + currentLine;
                                    } else {
                                        BAccessRight accessRight = this.getAccessRight(session, accessRightName);
                                        if (accessRight != null && this.isMissingTenant((BComponent)accessRight, this.op)) {
                                            this.log().failed("Cannot import line " + currentLine + ": AccessRight '" + accessRightName + "':" + EntsecTenantUtil.getMissingTenantWarning((BComponent)accessRight, (HxOp)this.op));
                                            validData = false;
                                            break;
                                        }
                                    }
                                    accessRightNames.put(key, accessRightName);
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("startdate")) {
                                    String key = columnName.toLowerCase().substring("startdate".length());
                                    if (startDates.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each StartDate column must have its own suffix, 'StartDate1','StartDate2', etc...");
                                    }
                                    startDates.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("enddate")) {
                                    String key = columnName.toLowerCase().substring("enddate".length());
                                    if (endDates.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each EndDate column must have its own suffix, 'EndDate1','EndDate2', etc...");
                                    }
                                    endDates.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.toLowerCase().startsWith("assignedthreatlevel")) {
                                    String key = columnName.toLowerCase().substring("assignedthreatlevel".length());
                                    if (assignedThreatLevels.containsKey(key)) {
                                        throw new IllegalStateException("Duplicate Column Suffix: '" + key + "'. Each Assigned Threat Level column must have its own suffix, 'AssignedThreatLevel1','AssignedThreatLevel2', etc...");
                                    }
                                    assignedThreatLevels.put(key, this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("personType")) {
                                    person.setPersonType(this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("supervisor")) {
                                    if (!columns[i2].equalsIgnoreCase("true")) continue;
                                    person.setSupervisor(true);
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("department")) {
                                    person.setDepartment(this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("firstName")) {
                                    person.setFirstName(this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("lastName")) {
                                    person.setLastName(this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("middleInitial")) {
                                    person.setMiddleInitial(this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("employeeId")) {
                                    person.setEmployeeId(this.addCommas(columns[i2]));
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("traceCard")) {
                                    if (!columns[i2].equalsIgnoreCase("true")) continue;
                                    person.setTraceCard(true);
                                    continue;
                                }
                                if (columnName.equalsIgnoreCase("pinNumber")) {
                                    if (this.isInteger(columns[i2])) {
                                        BPassword pswd = BPassword.make((String)columns[i2]);
                                        person.setPinNumber(pswd);
                                        continue;
                                    }
                                    SecretKey secretKey = null;
                                    String[] splitStringArray = columns[i2].split(":");
                                    if (aesSysKeyEncoder == null) {
                                        secretKey = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM).generateSecret(new PBEKeySpec(this.passKey.toCharArray(), new String(ByteArrayUtil.hexStringToBytes((String)splitStringArray[0])).getBytes(UTF_8), 65536, 256));
                                        aesSysKeyEncoder = new AesSysKeyEncoder(secretKey);
                                    }
                                    BPassword inputPassword = BPassword.make((String)aesSysKeyEncoder.decrypt(splitStringArray[1] + ":" + splitStringArray[2]));
                                    if (this.isInteger(AccessController.doPrivileged(() -> ((BPassword)inputPassword).getValue()))) {
                                        person.setPinNumber(inputPassword);
                                        continue;
                                    }
                                    this.log().failed("Cannot import line " + currentLine + ": invalid PIN number.");
                                    validData = false;
                                    break;
                                }
                                if (columnName.indexOf("info") == 0) {
                                    int index = columnName.indexOf("info");
                                    int infoNumber = Integer.parseInt(columnName.substring(index + "info".length()));
                                    BInfoTemplate infoTemplate = this.getInfoTemplate(infoNumber, session);
                                    personInfo.setValue(infoTemplate, columns[i2]);
                                    if (infoTemplate.getDefaultValue().toString().equals(columns[i2])) continue;
                                    defaultPersonInfo = false;
                                    continue;
                                }
                                if (columnName.equals("portrait")) {
                                    BOrd ord = BOrd.make((String)columns[i2]);
                                    String fileName = columns[i2];
                                    BUuid uuid = this.fileNameToUuid.get(fileName);
                                    if (uuid == null) {
                                        this.log().failed("Cannot import line " + currentLine + ": file does not exist in zip:" + fileName);
                                        validData = false;
                                        break;
                                    }
                                    personPortrait = (BPersonPortrait)session.read(BPersonPortrait.ORION_TYPE, (BSimple)uuid);
                                    continue;
                                }
                                if (!notifyColumnNotSupported) continue;
                                notifyColumnNotSupported = false;
                                this.log().failed("Column " + columnName + " not supported for import");
                            }
                            if (!validData) continue;
                            if (person.getLastName().length() == 0) {
                                this.log().failed("Cannot import line " + currentLine + ": must contain a last name for the person.");
                                continue;
                            }
                            if (accessRightNames.size() == 0) {
                                ++newPeopleWithoutAccessRights;
                            }
                            if (hasDuplicateAccessRightColumn && (startDates.size() > 0 || endDates.size() > 0)) {
                                this.log().failed("Cannot import line " + currentLine + ": 'StartDate' and 'EndDate' cannot be used with duplicate 'AccessRight' columns.");
                                continue;
                            }
                            if (addTenant) {
                                session.insert((BIOrionObject)tenant);
                                tenant = this.getTenant(session, tenant.getTenantId());
                                ++newTenants;
                            }
                            person.setPersonId(BUuid.make());
                            if (tenant != null) {
                                person.setTenant(BRef.make((BIOrionObject)tenant));
                            }
                            session.insert((BIOrionObject)person);
                            Object[] keys = credentials.keySet().toArray();
                            for (i = 0; i < keys.length; ++i) {
                                String credential = (String)credentials.get(keys[i]);
                                String facilityCode = (String)facilityCodes.get(keys[i]);
                                String wiegandFormatName = (String)wiegandFormatNames.get(keys[i]);
                                String badgeStatusTag = (String)badgeStatuses.get(keys[i]);
                                String badgeDescription = (String)badgeDescriptions.get(keys[i]);
                                String encodedIssueDate = (String)issueDates.get(keys[i]);
                                String encodedExpirationDate = (String)expirationDates.get(keys[i]);
                                BBadge badge = new BBadge();
                                badge.setStatus(BBadgeStatus.active);
                                if (badgeStatusTag != null) {
                                    badge.setStatus((BBadgeStatus)BBadgeStatus.active.getRange().get(badgeStatusTag));
                                }
                                badge.setIssueDate(BAbsTime.now());
                                badge.setOwner(BRef.make((BIOrionObject)person));
                                badge.setCredential(credential);
                                if (badgeDescription != null) {
                                    badge.setBDescription(badgeDescription);
                                }
                                if (encodedIssueDate != null) {
                                    badge.setIssueDate((BAbsTime)BAbsTime.DEFAULT.decodeFromString(encodedIssueDate));
                                }
                                if (encodedExpirationDate != null) {
                                    badge.setExpirationDate((BAbsTime)BAbsTime.DEFAULT.decodeFromString(encodedExpirationDate));
                                }
                                BWiegandFormat wiegandFormat = userSelectedWiegandFormat;
                                if (wiegandFormatName != null) {
                                    wiegandFormat = this.getWiegandFormat(session, wiegandFormatName);
                                }
                                if (wiegandFormat == null) {
                                    wiegandFormat = userSelectedWiegandFormat;
                                    this.log().failed("Cannot import badge" + currentLine + ": invalid wiegand format.");
                                    continue;
                                }
                                badge.setWiegandFormat(BRef.make((BIOrionObject)wiegandFormat));
                                if (facilityCode != null) {
                                    badge.setFacilityCode(facilityCode);
                                } else {
                                    badge.setFacilityCode(wiegandFormat.getFacilityCode());
                                }
                                String badgeId = badge.calculateId(session);
                                if (this.getBadge(session, badgeId) != null) {
                                    this.log().failed("Cannot import badge " + currentLine + ": badge already exists. Please assign a badge to this person manually");
                                    continue;
                                }
                                if (tenant != null) {
                                    badge.setTenant(BRef.make((BIOrionObject)tenant));
                                }
                                session.insert((BIOrionObject)badge);
                                ++newBadges;
                            }
                            ++newPeople;
                            person = this.getPerson(session, person.getPersonId());
                            if (!defaultPersonInfo) {
                                personInfo.setPerson(BRef.make((BIOrionObject)person));
                                session.insert((BIOrionObject)personInfo);
                                ++newPeopleInfoJoins;
                            }
                            if (personPortrait != null) {
                                personPortrait.setPerson(BRef.make((BIOrionObject)person));
                                session.update(personPortrait);
                                ++newPeoplePortraits;
                            }
                            keys = accessRightNames.keySet().toArray();
                            for (i = 0; i < keys.length; ++i) {
                                String encodedAssignedThreatLevel;
                                String accessRightName = (String)accessRightNames.get(keys[i]);
                                BAccessRight accessRight = this.getAccessRight(session, accessRightName);
                                if (accessRight == null) {
                                    accessRight = new BAccessRight();
                                    accessRight.setAccessRightId(BUuid.make());
                                    accessRight.setAccessRightName(accessRightName);
                                    accessRight.setAcDescription(accessRightName);
                                    if (tenant != null) {
                                        accessRight.setTenant(BRef.make((BIOrionObject)tenant));
                                    }
                                    session.insert((BIOrionObject)accessRight);
                                    ++newAccessRights;
                                }
                                if (person == null) continue;
                                BPersonAccJoin join = new BPersonAccJoin();
                                join.setAccessRight(BRef.make((BIOrionObject)accessRight));
                                join.setPerson(BRef.make((BIOrionObject)person));
                                String encodedStartDate = (String)startDates.get(keys[i]);
                                String encodedEndDate = (String)endDates.get(keys[i]);
                                if (encodedStartDate != null) {
                                    join.setStartDate((BAbsTime)BAbsTime.DEFAULT.decodeFromString(encodedStartDate));
                                }
                                if (encodedEndDate != null) {
                                    join.setEndDate((BAbsTime)BAbsTime.DEFAULT.decodeFromString(encodedEndDate));
                                }
                                if ((encodedAssignedThreatLevel = (String)assignedThreatLevels.get(keys[i])) != null) {
                                    join.setAssignedThreatLevel((BThreatLevelEntry)BThreatLevelEntry.DEFAULT.decodeFromString(encodedAssignedThreatLevel));
                                }
                                session.insert((BIOrionObject)join);
                                ++newPeopleAccessJoins;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.log().failed("Exception thrown importing line " + currentLine + ": " + e.getMessage(), (Throwable)e);
                        }
                    }
                    StringBuilder newPeopleMessage = new StringBuilder().append(newPeople).append(" New People");
                    if (newPeopleWithoutAccessRights > 0) {
                        newPeopleMessage.append(" (").append(newPeopleWithoutAccessRights).append(" people without access rights)");
                    }
                    this.log().message(newPeopleMessage.toString());
                    this.log().message("" + newBadges + " New Badges");
                    this.log().message("" + newTenants + " New Tenants");
                    this.log().message("" + newAccessRights + " New Access Rights");
                    this.log().message("" + newPeopleAccessJoins + " New Associations between Access Rights and People");
                    this.log().message("" + this.newInfoTemplates + " New Additional Personnel Data Columns");
                    this.log().message("" + newPeopleInfoJoins + " People that have Additional Person Data");
                    this.log().message("" + newPeoplePortraits + " People that have a Portrait");
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var15_15 = throwable6;
            throw throwable6;
        }
        finally {
            if (is != null) {
                if (var15_15 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable7) {
                        var15_15.addSuppressed(throwable7);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    private boolean isMissingTenant(BComponent accessRight, HxOp cx) {
        BRefList requiredList = EntsecTenantUtil.getRequiredTenants((BComponent)accessRight, (Context)cx);
        BRefList matchableList = EntsecTenantUtil.getMatchableTenants((BComponent)accessRight, (Context)cx);
        if (requiredList == null && matchableList == null) {
            return false;
        }
        BRefList sessionTenantList = this.tenantFilterOptions.getTenants();
        BRefList tenantList = null;
        tenantList = sessionTenantList != null && sessionTenantList.isBound() && !cx.getFacets().getb(USER_TENANTS, false) ? sessionTenantList : EntsecTenantUtil.getUserTenantList((Context)cx);
        return tenantList != null && tenantList.isBound() && !tenantList.containsAll(requiredList) && !tenantList.contains(matchableList);
    }

    private BInfoTemplate getInfoTemplate(int infoTemplateId, OrionSession session) {
        for (int i = 0; i < this.infoTemplates.length; ++i) {
            if (this.infoTemplates[i].getInfoTemplateId() != infoTemplateId) continue;
            return this.infoTemplates[i];
        }
        BInfoTemplate infoTemplate = new BInfoTemplate();
        infoTemplate.setInfoTemplateName("info" + infoTemplateId);
        infoTemplate.setInfoTemplateId(infoTemplateId);
        session.insert((BIOrionObject)infoTemplate);
        this.infoTemplates = BInfoTemplate.getOrderedInfoTemplates((OrionSession)session);
        ++this.newInfoTemplates;
        return infoTemplate;
    }

    private BBadge getBadge(OrionSession session, String badgeId) {
        BIOrionObject orionObject = session.read(BBadge.ORION_TYPE, new PropertyValue(BBadge.badgeId, (BValue)BString.make((String)badgeId)));
        if (orionObject != null && orionObject instanceof BBadge) {
            return (BBadge)orionObject;
        }
        return null;
    }

    private BTenant getTenant(OrionSession session, BUuid id) {
        BIOrionObject orionObject = session.read(BTenant.ORION_TYPE, new PropertyValue(BTenant.tenantId, (BValue)id));
        if (orionObject != null && orionObject instanceof BTenant) {
            return (BTenant)orionObject;
        }
        return null;
    }

    private BTenant getTenant(OrionSession session, String name) {
        BIOrionObject orionObject = session.read(BTenant.ORION_TYPE, new PropertyValue(BTenant.tenantName, (BValue)BString.make((String)name)));
        if (orionObject != null && orionObject instanceof BTenant) {
            return (BTenant)orionObject;
        }
        return null;
    }

    private BWiegandFormat getWiegandFormat(OrionSession session, String name) {
        BIOrionObject orionObject = session.read(BWiegandFormat.ORION_TYPE, new PropertyValue(BWiegandFormat.wiegandFormatName, (BValue)BString.make((String)name)));
        if (orionObject != null && orionObject instanceof BWiegandFormat) {
            return (BWiegandFormat)orionObject;
        }
        return null;
    }

    private BPerson getPerson(OrionSession session, BUuid id) {
        BIOrionObject orionObject = session.read(BPerson.ORION_TYPE, new PropertyValue(BPerson.personId, (BValue)id));
        if (orionObject != null && orionObject instanceof BPerson) {
            return (BPerson)orionObject;
        }
        return null;
    }

    private BAccessRight getAccessRight(OrionSession session, BUuid id) {
        BIOrionObject orionObject = session.read(BAccessRight.ORION_TYPE, new PropertyValue(BAccessRight.accessRightId, (BValue)id));
        if (orionObject != null && orionObject instanceof BAccessRight) {
            return (BAccessRight)orionObject;
        }
        return null;
    }

    private BAccessRight getAccessRight(OrionSession session, String name) {
        BIOrionObject orionObject = session.read(BAccessRight.ORION_TYPE, new PropertyValue(BAccessRight.accessRightName, (BValue)BString.make((String)name)));
        if (orionObject != null && orionObject instanceof BAccessRight) {
            return (BAccessRight)orionObject;
        }
        return null;
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String addCommas(String str) {
        if (str == null) {
            return str;
        }
        return TextUtil.replace((String)str, (String)"<comma>", (String)",");
    }

    public void cleanupJob() {
        this.fileNameToUuid = null;
        this.file = null;
        this.tenantRef = null;
        this.wiegandFormatRef = null;
        this.infoTemplates = null;
        this.op = null;
    }
}

