/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.fieldeditors;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsecHx.access.fieldeditors.BHxUnitFE;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"baja:Facets"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxFacetsFE
extends BHxFieldEditor {
    public static final Lexicon lex = Lexicon.make(BHxFacetsFE.class);
    @Generated
    public static final BHxFacetsFE INSTANCE = new BHxFacetsFE();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxFacetsFE.class);
    private SmartCommand editFacets = new EditFacetsCommand((BHxView)this);
    private SmartCommand editUnits;
    private SmartCommand add;
    private SmartCommand delete;
    private static final String GO_TO_PRESET = "goToPreset";
    private static final String CAMERA_PRESET = "cameraPreset";
    private static final String START_RECORDING = "startRecording";
    private static final String SEND_ALARM_TO_DISPLAY = "sendAlarmToDisplay";
    private static final String FACETS_SUMMARY_ID = "facetsSummary";
    private static String[] keys = new String[]{"allowNull", "forceSign", "showDate", "showTime", "showTimeZone", "showSeconds", "showMilliseconds", "showUnits", "multiLine", "ordRelativize", "goToPreset", "startRecording", "sendAlarmToDisplay", "precision", "radix", "fieldWidth", "cameraPreset", "max", "min", "cellEditor", "realms", "falseText", "trueText", "units"};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxFacetsFE() {
        this.registerEvent((Event)this.editFacets);
        this.editUnits = new EditUnitsCommand((BHxView)this);
        this.registerEvent((Event)this.editUnits);
        this.add = new AddGenericFacetCommand((BHxView)this);
        this.registerEvent((Event)this.add);
        this.delete = new DeleteGenericFacetCommand((BHxView)this);
        this.registerEvent((Event)this.delete);
    }

    private String facetsAttribute(HxOp op) {
        String attribute = SmartCommand.universalScope((String)"facets", (HxOp)op);
        return TextUtil.replace((String)attribute, (String)"properties.alarmClass", (String)"properties.metaData");
    }

    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://entsecHx/rc/securityUtilHx/select.js"));
        op.getRequest().getSession().removeAttribute(this.facetsAttribute(op));
        if (op.canWrite()) {
            HxTabUtil.writeCommand((SmartCommand)this.editFacets, (boolean)true, (HxOp)op);
        }
        BFacets facets = (BFacets)op.get();
        this.writeFacetsSummary(facets, op);
        super.write(op);
    }

    public BObject save(HxOp op) throws Exception {
        BObject facets = (BObject)op.getRequest().getSession().getAttribute(this.facetsAttribute(op));
        if (facets == null) {
            facets = op.get();
        }
        if (facets == null) {
            facets = BFacets.DEFAULT;
        }
        return facets.asSimple().newCopy();
    }

    public boolean process(HxOp op) throws Exception {
        HxOp unitOp;
        BFacets facets = (BFacets)op.get();
        BUnit unit = (BUnit)facets.get("units");
        if (unit == null) {
            unit = BUnit.DEFAULT;
        }
        if (BHxUnitFE.INSTANCE.process(unitOp = op.make("units", new OrdTarget((OrdTarget)op, (BObject)unit)))) {
            return true;
        }
        return super.process(op);
    }

    private void writeFacetsSummary(BFacets facets, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String[] keys = facets.list();
        BHxFacetsFE.sortFacetKeys(keys);
        out.w((Object)"<div id='").w((Object)FACETS_SUMMARY_ID).w((Object)"'>");
        if (keys.length == 0) {
            out.w((Object)"[No configured facets]");
        } else {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = BHxFacetsFE.unescape(facets.gets(key, ""));
                if (!key.equals("units")) {
                    out.w((Object)(i + 1 + ". ")).w((Object)key).w((Object)"=").safe(value, false).w((Object)"<br />");
                    continue;
                }
                out.w((Object)(i + 1 + ". ")).w((Object)key).w((Object)"=").w((Object)value).w((Object)"<br />");
            }
        }
        out.w((Object)"</div>");
    }

    public static void updateFacetsSummary(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BFacets facets = (BFacets)op.getRequest().getSession().getAttribute(INSTANCE.facetsAttribute(op));
        if (facets == null) {
            facets = (BFacets)op.get();
        }
        if (facets == null) {
            facets = BFacets.DEFAULT;
        }
        out.w((Object)"var summary = document.getElementById('").w((Object)FACETS_SUMMARY_ID).w((Object)"');");
        out.w((Object)"if(summary != null){");
        out.w((Object)"while(summary.hasChildNodes()) summary.removeChild(summary.firstChild);");
        if (facets.list().length == 0) {
            out.w((Object)"summary.appendChild(document.createTextNode('[No configured facets]'));");
        } else {
            String[] keys = facets.list();
            BHxFacetsFE.sortFacetKeys(keys);
            for (int i = 0; i < keys.length; ++i) {
                String item = i + 1 + ". " + keys[i] + "=" + BHxFacetsFE.unescape(facets.gets(keys[i], ""));
                out.w((Object)"summary.appendChild(document.createTextNode('").w((Object)item).w((Object)"'));");
                out.w((Object)"summary.appendChild(document.createElement('br'));");
            }
        }
        out.w((Object)"}");
    }

    private static void sortFacetKeys(String[] keys) {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string1, String string2) {
                return string1.compareTo(string2);
            }
        };
        Arrays.sort(keys, comparator);
    }

    private static String escape(String string) {
        StringBuffer escapedString = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':' || c == '/' || c == '|' || Character.isLetterOrDigit(c)) {
                escapedString.append(c);
                continue;
            }
            escapedString.append(SlotPath.escape((String)(c + "")));
        }
        return escapedString.toString();
    }

    private static String unescape(String string) {
        return SlotPath.unescape((String)string);
    }

    private boolean isBooleanKey(String facetKey) {
        return facetKey.equals("allowNull") || facetKey.equals("forceSign") || facetKey.equals("showDate") || facetKey.equals("showTime") || facetKey.equals("showMilliseconds") || facetKey.equals("showTimeZone") || facetKey.equals("showSeconds") || facetKey.equals("showUnits") || facetKey.equals("multiLine") || facetKey.equals("ordRelativize") || facetKey.equals(GO_TO_PRESET) || facetKey.equals(SEND_ALARM_TO_DISPLAY) || facetKey.equals(START_RECORDING);
    }

    private boolean isStringKey(String facetKey) {
        return facetKey.equals("trueText") || facetKey.equals("falseText") || facetKey.equals("cellEditor") || facetKey.equals("fieldEditor") || facetKey.equals("realms") || facetKey.equals("targetType");
    }

    private boolean isFloatKey(String facetKey) {
        return facetKey.equals("max") || facetKey.equals("min");
    }

    private boolean isIntKey(String facetKey) {
        return facetKey.equals("precision") || facetKey.equals("radix") || facetKey.equals("fieldWidth");
    }

    private boolean isEnumKey(String facetKey) {
        return facetKey.equals(CAMERA_PRESET);
    }

    private boolean isUnitsKey(String facetKey) {
        return facetKey.equals("units");
    }

    private boolean isCustomKey(String facetKey) {
        return !this.isBooleanKey(facetKey) && !this.isStringKey(facetKey) && !this.isFloatKey(facetKey) && !this.isIntKey(facetKey) && !this.isEnumKey(facetKey) && !this.isUnitsKey(facetKey);
    }

    private class EditUnitsDialog
    extends Dialog {
        public EditUnitsDialog(String title, Command handler) {
            super(title, handler);
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand("submitLevel2"), new Dialog.Cancel((Dialog)this)};
        }

        protected void writeContent(HxOp op) throws Exception {
            super.writeContent(op);
            BFacets facets = (BFacets)op.get();
            BUnit currentUnit = (BUnit)facets.getFacet("units");
            if (currentUnit == null) {
                currentUnit = BUnit.DEFAULT;
            }
            HxOp unitOp = op.make("units", new OrdTarget((OrdTarget)op, (BObject)currentUnit));
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)currentUnit, (Context)unitOp);
            editor.write(unitOp);
        }
    }

    private class EditUnitsCommand
    extends SmartCommand {
        private Dialog dlg;

        public EditUnitsCommand(BHxView view) {
            super(view);
            this.dlg = new EditUnitsDialog("Edit Units", (Command)this);
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BFacets facets = (BFacets)op.get();
            BUnit currentUnit = (BUnit)facets.getFacet("units");
            if (currentUnit == null) {
                currentUnit = BUnit.DEFAULT;
            }
            HxOp unitOp = op.make("units", new OrdTarget((OrdTarget)op, (BObject)currentUnit));
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)currentUnit, (Context)unitOp);
            BUnit newUnit = (BUnit)editor.save(unitOp);
            HtmlWriter out = op.getHtmlWriter();
            String scopedTextFieldName = op.getFormValue("scopedTextFieldName");
            out.w((Object)"var unitsField = document.getElementById('").w((Object)scopedTextFieldName).w((Object)"');");
            String unitDescription = newUnit.getUnitName() + " (" + newUnit.getSymbol() + ")";
            out.w((Object)"unitsField.value = '").w((Object)unitDescription).w((Object)"';");
            out.w((Object)"unitsField.size = ").w(unitDescription.length() + 1).w((Object)";");
        }

        public String getName(HxOp op) {
            return "editUnits";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }
    }

    private class DeleteGenericFacetCommand
    extends SmartCommand {
        public DeleteGenericFacetCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "deleteGenericFacetCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var indices = new Array();");
            out.w((Object)"var checkboxes = new Array();");
            out.w((Object)"var headers = document.getElementsByTagName('th');");
            out.w((Object)"var table = headers[0].parentNode.parentNode;");
            out.w((Object)"var inputElems = document.getElementsByTagName('input');");
            out.w((Object)"for(var i = 0; i < inputElems.length; i++){");
            out.w((Object)"if(inputElems[i].type == 'checkbox' && inputElems[i].name == 'checkbox' && inputElems[i].checked)");
            out.w((Object)"checkboxes.push(inputElems[i]);");
            out.w((Object)"}");
            out.w((Object)"for(var i = 0; i < checkboxes.length; i++){");
            out.w((Object)"indices.push(checkboxes[i].parentNode.parentNode.rowIndex);");
            out.w((Object)"}");
            out.w((Object)"while(indices.length > 0)");
            out.w((Object)"table.deleteRow(indices.pop());");
            out.w((Object)"var selectAllRows = document.getElementById('selectAllCheckBox');");
            out.w((Object)"if(selectAllRows.checked) selectAllRows.checked = false;");
        }
    }

    private class AddGenericFacetCommand
    extends SmartCommand {
        public AddGenericFacetCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "addGenericFacetCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var headers = document.getElementsByTagName('th');");
            out.w((Object)"var table = headers[0].parentNode.parentNode;");
            out.w((Object)"table.insertRow(table.rows.length);");
            out.w((Object)"var row = table.rows[table.rows.length - 1];");
            out.w((Object)"var checkboxCell = document.createElement('td');");
            out.w((Object)"var checkbox = document.createElement('input');");
            out.w((Object)"checkbox.type = 'checkbox';");
            out.w((Object)"checkbox.name = 'checkbox';");
            out.w((Object)"checkboxCell.appendChild(checkbox);");
            out.w((Object)"row.appendChild(checkboxCell);");
            String rowId = BUuid.make().toCompactString();
            String scopedKeyFieldName = op.scope("keyField" + rowId);
            out.w((Object)"var keysCell = document.createElement('td');");
            out.w((Object)"keysCell.style.textAlign = 'center';");
            out.w((Object)"var list = document.createElement('select');");
            out.w((Object)"list.name = '").w((Object)scopedKeyFieldName).w((Object)"';");
            out.w((Object)"list.id = list.name;");
            out.w((Object)"keysCell.appendChild(list);");
            out.w((Object)"row.appendChild(keysCell);");
            out.w((Object)"var customKey = document.createElement('option');");
            out.w((Object)"customKey.value = 'custom';");
            out.w((Object)"customKey.text = 'Custom';");
            out.w((Object)"try{");
            out.w((Object)"list.add(customKey,list.options[null]);");
            out.w((Object)"}");
            out.w((Object)"catch(e){");
            out.w((Object)"list.add(customKey, null);");
            out.w((Object)"}");
            for (int i = 0; i < keys.length; ++i) {
                out.w((Object)"var key = document.createElement('option');");
                out.w((Object)"key.value = '").w((Object)keys[i]).w((Object)"';");
                if (BHxFacetsFE.this.isBooleanKey(keys[i])) {
                    out.w((Object)"key.setAttribute('keyType','").w((Object)BBoolean.TYPE).w((Object)"');");
                } else if (BHxFacetsFE.this.isStringKey(keys[i])) {
                    out.w((Object)"key.setAttribute('keyType','").w((Object)BString.TYPE).w((Object)"');");
                } else if (BHxFacetsFE.this.isFloatKey(keys[i])) {
                    out.w((Object)"key.setAttribute('keyType','").w((Object)BFloat.TYPE).w((Object)"');");
                } else if (BHxFacetsFE.this.isIntKey(keys[i])) {
                    out.w((Object)"key.setAttribute('keyType','").w((Object)BInteger.TYPE).w((Object)"');");
                } else if (BHxFacetsFE.this.isUnitsKey(keys[i])) {
                    out.w((Object)"key.setAttribute('keyType','").w((Object)BUnit.TYPE).w((Object)"');");
                }
                out.w((Object)"key.text = '").w((Object)TextUtil.toFriendly((String)keys[i])).w((Object)"';");
                out.w((Object)"try{");
                out.w((Object)"list.add(key,list.options[null]);");
                out.w((Object)"}");
                out.w((Object)"catch(e){");
                out.w((Object)"list.add(key, null);");
                out.w((Object)"}");
            }
            out.w((Object)"list.selectedIndex = 1;");
            String scopedListFieldName = op.scope("listField" + rowId);
            out.w((Object)"function addBooleanList(row){");
            out.w((Object)"var listCell = document.createElement('td');");
            out.w((Object)"listCell.style.textAlign = 'center';");
            out.w((Object)"var listField = document.createElement('select');");
            out.w((Object)"listField.name = '").w((Object)scopedListFieldName).w((Object)"';");
            out.w((Object)"listField.id = listField.name;");
            out.w((Object)"listCell.appendChild(listField);");
            out.w((Object)"row.appendChild(listCell);");
            out.w((Object)"var trueOption = document.createElement('option');");
            out.w((Object)"trueOption.value = 'true';");
            out.w((Object)"trueOption.text = 'true';");
            out.w((Object)"var falseOption = document.createElement('option');");
            out.w((Object)"falseOption.value = 'false';");
            out.w((Object)"falseOption.text = 'false';");
            out.w((Object)"try{");
            out.w((Object)"listField.add(trueOption, listField.options[null]);");
            out.w((Object)"listField.add(falseOption, listField.options[null]);");
            out.w((Object)"}");
            out.w((Object)"catch(e){");
            out.w((Object)"listField.add(trueOption, null);");
            out.w((Object)"listField.add(falseOption, null);");
            out.w((Object)"}");
            out.w((Object)"}");
            String scopedTextFieldName = op.scope("textField" + rowId);
            out.w((Object)"function addTextField(row, keyField){");
            out.w((Object)"var textCell = document.createElement('td');");
            out.w((Object)"textCell.style.textAlign = 'center';");
            out.w((Object)"var textField = document.createElement('input');");
            out.w((Object)"textField.name = '").w((Object)scopedTextFieldName).w((Object)"';");
            out.w((Object)"textField.id = textField.name;");
            out.w((Object)"textField.type = 'text';");
            out.w((Object)"textCell.appendChild(textField);");
            out.w((Object)"if(keyField.value == 'units'){");
            out.w((Object)"textField.readOnly = 'readonly';");
            BUnit currentUnit = (BUnit)((BFacets)op.get()).get("units");
            if (currentUnit == null) {
                currentUnit = BUnit.DEFAULT;
            }
            String unitDescription = currentUnit.getUnitName() + " (" + currentUnit.getSymbol() + ")";
            out.w((Object)"textField.size = ").w(unitDescription.length() + 1).w((Object)";");
            out.w((Object)"textField.value = '").w((Object)unitDescription).w((Object)"';");
            out.w((Object)"textCell.appendChild(document.createTextNode(' '));");
            out.w((Object)"var editUnitsCommand = document.createElement('img');");
            out.w((Object)"editUnitsCommand.src = '").w((Object)HxUtil.encodeURLForHref((String)op.toUri(BIcon.std((String)"doubleArrowRight.png").getOrdList().get(0)))).w((Object)"';");
            out.w((Object)"editUnitsCommand.style.cursor = 'pointer';");
            String invokeCode = SmartCommand.getInvokeCode((Command)BHxFacetsFE.this.editUnits, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op);
            invokeCode = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("scopedTextFieldName"), (Object)scopedTextFieldName, (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op) + invokeCode;
            out.w((Object)"editUnitsCommand.onclick = function(){").w((Object)invokeCode).w((Object)"};");
            out.w((Object)"textCell.appendChild(editUnitsCommand);");
            out.w((Object)"}");
            out.w((Object)"row.appendChild(textCell);");
            out.w((Object)"}");
            out.w((Object)"addBooleanList(row);");
            out.w((Object)"list.onchange = function(){");
            out.w((Object)"var type = this.options[this.selectedIndex].getAttribute('keyType');");
            out.w((Object)"row.removeChild(row.lastChild);");
            out.w((Object)"if(type == 'baja:Boolean'){");
            out.w((Object)"addBooleanList(row);");
            out.w((Object)"}");
            out.w((Object)"else{");
            out.w((Object)"addTextField(row, this);");
            out.w((Object)"if(this.value == 'custom'){");
            out.w((Object)"var customKeyTextField = document.createElement('input');");
            out.w((Object)"customKeyTextField.type = 'text';");
            out.w((Object)"customKeyTextField.name = '").w((Object)scopedKeyFieldName).w((Object)"';");
            out.w((Object)"this.parentNode.appendChild(customKeyTextField);");
            out.w((Object)"this.parentNode.removeChild(this);");
            out.w((Object)"}");
            out.w((Object)"}");
            out.w((Object)"};");
        }
    }

    private class FacetsDialog
    extends Dialog {
        public FacetsDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BComponent component = op.getComponent();
            if (this.inBooleanList(component)) {
                this.writeBooleanFacets(op);
            } else if (this.inNumericList(component)) {
                this.writeNumericFacets(op);
            } else if (this.inGenericList(component)) {
                this.writeGenericFacets(op);
            }
            super.writeContent(op);
        }

        private boolean inNumericList(BComponent component) {
            Type type = component.getType();
            return type.is(BNumericPoint.TYPE);
        }

        private boolean inBooleanList(BComponent component) {
            Type type = component.getType();
            return type.is(BBooleanPoint.TYPE);
        }

        private boolean inGenericList(BComponent component) {
            return !this.inBooleanList(component) && !this.inNumericList(component);
        }

        private void writeBooleanFacets(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BFacets facets = BFacets.DEFAULT;
            BFacets extensionFacets = (BFacets)op.getRequest().getSession().getAttribute(BHxFacetsFE.this.facetsAttribute(op));
            facets = extensionFacets != null ? extensionFacets : (BFacets)op.get();
            if (facets == null) {
                facets = BFacets.DEFAULT;
            }
            String trueText = facets.gets("trueText", "");
            String falseText = facets.gets("falseText", "");
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)lex.getText("booleanFacets.trueText"), (HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            out.w((Object)("<input type='text' name='" + op.scope("trueText") + "' value='")).safe(trueText, false).w((Object)"' />");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)lex.getText("booleanFacets.falseText"), (HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            out.w((Object)("<input type='text' name='" + op.scope("falseText") + "' value='")).safe(falseText, false).w((Object)"' />");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }

        private void writeNumericFacets(HxOp op) throws Exception {
            BFacets facets = BFacets.DEFAULT;
            BFacets extensionFacets = (BFacets)op.getRequest().getSession().getAttribute(BHxFacetsFE.this.facetsAttribute(op));
            facets = extensionFacets != null ? extensionFacets : (BFacets)op.get();
            if (facets == null) {
                facets = BFacets.DEFAULT;
            }
            HtmlWriter out = op.getHtmlWriter();
            BUnit unit = (BUnit)facets.get("units");
            if (unit == null) {
                unit = BUnit.DEFAULT;
            }
            HxOp unitOp = op.make("units", new OrdTarget((OrdTarget)op, (BObject)unit));
            BHxFieldEditor.makeFor((BObject)unit, (Context)unitOp).write(unitOp);
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            double min = facets.getd("min", 0.0);
            HxTabUtil.startRow((String)lex.getText("numericFacets.min"), (HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            out.w((Object)("<input name='" + op.scope("min") + "' type='text' value='")).w(min).w((Object)"' />");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            double max = facets.getd("max", 0.0);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)lex.getText("numericFacets.max"), (HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            out.w((Object)("<input name='" + op.scope("max") + "' type='text' value='")).w(max).w((Object)"' />");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            int precision = facets.geti("precision", 2);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)lex.getText("numericFacets.precision"), (HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            out.w((Object)("<input name='" + op.scope("precision") + "' type='text' value='")).w(precision).w((Object)"' />");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }

        private void writeGenericFacets(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BFacets facets = BFacets.DEFAULT;
            BFacets extensionFacets = (BFacets)op.getRequest().getSession().getAttribute(BHxFacetsFE.this.facetsAttribute(op));
            facets = extensionFacets != null ? extensionFacets : (BFacets)op.get();
            if (facets == null) {
                facets = BFacets.DEFAULT;
            }
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            StringBuffer script = new StringBuffer();
            script.append("var inputElems = document.getElementsByTagName(&quot;input&quot;);");
            script.append("for(var i = 0; i < inputElems.length; i++){");
            script.append("if(inputElems[i].type == &quot;checkbox&quot; && inputElems[i].name == &quot;checkbox&quot;){");
            script.append("if(this.checked) inputElems[i].checked = true;");
            script.append("else inputElems[i].checked = false;");
            script.append("}");
            script.append("}");
            out.w((Object)"<tr><td><input type='checkbox' id='selectAllCheckBox' onclick='").w((Object)script.toString()).w((Object)"' /></td>");
            out.w((Object)"<th style='font-size:13px; font-family:Arial;'>").safe((Object)lex.getText("facetKey")).w((Object)"</th>");
            out.w((Object)"<th style='font-size:13px; font-family:Arial;'>").safe((Object)lex.getText("facetValue")).w((Object)"</th></tr>");
            String[] keys = facets.list();
            BHxFacetsFE.sortFacetKeys(keys);
            for (int i = 0; i < keys.length; ++i) {
                out.w((Object)"<tr>");
                out.w((Object)"<td>");
                out.w((Object)"<input type='checkbox' name='checkbox' />");
                out.w((Object)"</td>");
                out.w((Object)"<td style='text-align:center;'>");
                this.writeFacetKey(op, i, keys[i]);
                out.w((Object)"</td>");
                out.w((Object)"<td style='text-align:center;'>");
                this.writeFacetValue(op, i, facets.get(keys[i]));
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
            }
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.writeCommand((SmartCommand)BHxFacetsFE.this.add, (HxOp)op);
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.writeCommand((SmartCommand)BHxFacetsFE.this.delete, (HxOp)op);
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }

        private void writeFacetKey(HxOp op, int index, String currentKey) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String rowId = BUuid.make().toCompactString();
            String scopedKeyFieldName = op.scope("keyField" + rowId);
            op.setAttribute("keyField" + index, (Object)rowId);
            out.w((Object)"<input type='text' name='").w((Object)scopedKeyFieldName).w((Object)"' readonly='readonly' value='").w((Object)currentKey).w((Object)"' />");
        }

        private void writeFacetValue(HxOp op, int index, BObject currentValue) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String rowId = op.getAttribute("keyField" + index).toString();
            String scopedTextFieldName = op.scope("textField" + rowId);
            if (!currentValue.getType().is(BBoolean.TYPE)) {
                out.w((Object)"<input type='text' id='").w((Object)scopedTextFieldName).w((Object)"' name='").w((Object)scopedTextFieldName).w((Object)"' value='").safe(BHxFacetsFE.unescape(currentValue.toString()), false).w((Object)"' />");
                if (currentValue.getType().is(BUnit.TYPE)) {
                    BUnit unit = (BUnit)currentValue;
                    String unitDescription = unit.getUnitName() + " (" + unit.getSymbol() + ")";
                    StringBuffer script = new StringBuffer();
                    script.append("var unitsField = document.getElementById('").append(scopedTextFieldName).append("');");
                    script.append("unitsField.readOnly = 'readonly';");
                    script.append("unitsField.size = ").append(unitDescription.length() + 1).append(";");
                    script.append("unitsField.value = '").append(unitDescription).append("';");
                    script.append("unitsField.parentNode.appendChild(document.createTextNode(' '));");
                    script.append("var editUnitsCommand = document.createElement('img');");
                    script.append("editUnitsCommand.src = '").append(op.toUri(BIcon.std((String)"doubleArrowRight.png").getOrdList().get(0))).append("';");
                    script.append("editUnitsCommand.style.cursor = 'pointer';");
                    String invokeCode = SmartCommand.getInvokeCode((Command)BHxFacetsFE.this.editUnits, (String)HxUtil.getInnerQuote((HxOp)op), (HxOp)op);
                    invokeCode = SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("scopedTextFieldName"), (Object)scopedTextFieldName, (String)HxUtil.getInnerQuote((HxOp)op), (boolean)true, (HxOp)op) + invokeCode;
                    script.append("editUnitsCommand.onclick = function(){").append(invokeCode).append("};");
                    script.append("unitsField.parentNode.appendChild(editUnitsCommand);");
                    op.addOnload(script.toString());
                }
                return;
            }
            String scopedListFieldName = op.scope("listField" + rowId);
            out.w((Object)"<select name='").w((Object)scopedListFieldName).w((Object)"'>");
            out.w((Object)"<option ");
            out.attr("value", (Object)BBoolean.TRUE);
            if (currentValue.equals((Object)BBoolean.TRUE)) {
                out.attr("selected", "selected");
            }
            out.w((Object)">");
            out.w((Object)BBoolean.TRUE);
            out.w((Object)"</option>");
            out.w((Object)"<option ");
            out.attr("value", (Object)BBoolean.FALSE);
            if (currentValue.equals((Object)BBoolean.FALSE)) {
                out.attr("selected", "selected");
            }
            out.w((Object)">");
            out.w((Object)BBoolean.FALSE);
            out.w((Object)"</option>");
            out.w((Object)"</select>");
        }
    }

    private class EditFacetsCommand
    extends SmartCommand {
        private FacetsDialog dlg;

        public EditFacetsCommand(BHxView view) {
            super(view);
            this.dlg = new FacetsDialog(this.getDisplayName(null), (Command)this);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
            } else {
                Type componentType = op.getComponent().getType();
                if (componentType.is(BBooleanPoint.TYPE)) {
                    this.setBooleanFacets(op);
                } else if (componentType.is(BNumericPoint.TYPE)) {
                    this.setNumericFacets(op);
                } else {
                    this.setGenericFacets(op);
                }
                BHxFacetsFE.updateFacetsSummary(op);
            }
            super.handle(op);
        }

        private void setBooleanFacets(HxOp op) throws Exception {
            String trueText = op.getFormValue("trueText");
            String falseText = op.getFormValue("falseText");
            op.getRequest().getSession().setAttribute(BHxFacetsFE.this.facetsAttribute(op), (Object)BFacets.makeBoolean((String)trueText, (String)falseText));
            SaveCommand.setModified((HxOp)op);
        }

        private void setNumericFacets(HxOp op) throws Exception {
            BFacets facets = (BFacets)op.get();
            BUnit units = (BUnit)facets.get("units");
            if (units == null) {
                units = BUnit.DEFAULT;
            }
            HxOp unitOp = op.make("units", new OrdTarget((OrdTarget)op, (BObject)units));
            String unit = unitOp.getFormValue("unit");
            String min = op.getFormValue("min");
            String max = op.getFormValue("max");
            String precision = op.getFormValue("precision");
            double facet_min = Double.MIN_VALUE;
            double facet_max = Double.MAX_VALUE;
            double facet_precision = 0.0;
            if (min != null && !min.equals("min")) {
                this.validateNumber(min, op);
                facet_min = Double.parseDouble(min);
            }
            if (max != null && !max.equals("max")) {
                this.validateNumber(max, op);
                facet_max = Double.parseDouble(max);
            }
            if (facet_max < facet_min) {
                new ErrorDialog("Incorrect limits", (Throwable)new Exception("The maximum limit cannot be less than the minimum limit.")).open(op);
                return;
            }
            if (precision != null) {
                this.validateNumber(precision, op);
                facet_precision = Double.parseDouble(precision);
                if (facet_precision < 0.0) {
                    new ErrorDialog("Negative Precision", (Throwable)new Exception("Precision cannot be negative")).open(op);
                    return;
                }
            }
            facets = BFacets.makeNumeric((BUnit)BUnit.getUnit((String)unit), (int)((int)facet_precision), (double)facet_min, (double)facet_max);
            op.getRequest().getSession().setAttribute(BHxFacetsFE.this.facetsAttribute(op), (Object)facets);
            SaveCommand.setModified((HxOp)op);
            super.handle(op);
        }

        private void validateNumber(String number, HxOp op) {
            try {
                Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                try {
                    new ErrorDialog("Number Format Error", (Throwable)new Exception(number + " is not a number")).open(op);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }

        private void setGenericFacets(HxOp op) throws Exception {
            BFacets facets = BFacets.DEFAULT;
            String[] keys = op.getFormKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].startsWith("listField") && !keys[i].startsWith("textField")) continue;
                String facetValue = op.getFormValue(keys[i]);
                String rowId = keys[i].substring(9);
                String facetKey = op.getFormValue("keyField" + rowId);
                if (facetKey == null || facetKey.equals("")) {
                    throw new Exception(this.lexModule.getText("facetsEditor.invalidFacetKeyError", (Context)op));
                }
                if (BHxFacetsFE.this.isBooleanKey(facetKey)) {
                    facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)facetKey, (BIDataValue)BBoolean.make((String)facetValue)));
                    continue;
                }
                if (BHxFacetsFE.this.isIntKey(facetKey)) {
                    try {
                        facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)facetKey, (BIDataValue)BInteger.make((String)facetValue)));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception(this.lexModule.getText("facetsEditor.invalidIntegerError", (Context)op, new Object[]{facetKey}));
                    }
                }
                if (BHxFacetsFE.this.isEnumKey(facetKey)) {
                    try {
                        facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)facetKey, (BIDataValue)BDynamicEnum.make((int)Integer.parseInt(facetValue))));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception(this.lexModule.getText("facetsEditor.invalidIntegerError", (Context)op, new Object[]{facetKey}));
                    }
                }
                if (BHxFacetsFE.this.isFloatKey(facetKey)) {
                    try {
                        facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)facetKey, (BIDataValue)BDouble.make((String)facetValue)));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception(this.lexModule.getText("facetsEditor.invalidFloatError", (Context)op, new Object[]{facetKey}));
                    }
                }
                if (BHxFacetsFE.this.isUnitsKey(facetKey)) {
                    String unitName = facetValue.substring(0, facetValue.indexOf("(")).trim();
                    facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)unitName)));
                    continue;
                }
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)facetKey, (BIDataValue)BString.make((String)BHxFacetsFE.escape(facetValue))));
            }
            op.getRequest().getSession().setAttribute(BHxFacetsFE.this.facetsAttribute(op), (Object)facets);
            SaveCommand.setModified((HxOp)op);
        }

        public String getName(HxOp op) {
            return "editFacets";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }
    }
}

