/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.filter.BPersonStringFilter;
import com.tridiumx.entsec.filter.BSecAbsTimeFilter;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import com.tridiumx.entsecHx.access.orion.BHxPersonView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppTableView;
import com.tridiumx.entsecHx.orionToolsHx.DuplicateCommand;
import com.tridiumx.entsecHx.orionToolsHx.FilteredRedirectCommand;
import com.tridiumx.entsecHx.orionToolsHx.OrionBatchEditCommand;
import com.tridiumx.entsecHx.orionToolsHx.PersonDelete;
import com.tridiumx.entsecHx.orionToolsHx.match.MatchCommand;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:Personnel"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxPersonnelView
extends BHxAppTableView {
    static Lexicon lex = Lexicon.make(BHxPersonnelView.class);
    @Generated
    public static final BHxPersonnelView INSTANCE = new BHxPersonnelView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxPersonnelView.class);
    SmartCommand matchCommand = new MatchCommand((BHxView)this);
    SmartCommand batchCommand;
    SmartCommand showHistoryCommand;
    SmartCommand showPersonHistoryCommand;
    SmartCommand showReadersCommand;
    SmartCommand showExpirationsCommand;
    SmartCommand duplicateCommand;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxPersonnelView() {
        this.registerEvent((Event)this.matchCommand);
        this.batchCommand = new PersonBatchEditCommand((BHxView)this);
        this.registerEvent((Event)this.batchCommand);
        this.showHistoryCommand = new ShowHistoryCommand((BHxView)this);
        this.registerEvent((Event)this.showHistoryCommand);
        this.showPersonHistoryCommand = new ShowPersonHistoryCommand((BHxView)this);
        this.registerEvent((Event)this.showPersonHistoryCommand);
        this.showReadersCommand = new ShowReadersCommand((BHxView)this);
        this.registerEvent((Event)this.showReadersCommand);
        this.showExpirationsCommand = new ShowExpirationsCommand((BHxView)this);
        this.registerEvent((Event)this.showExpirationsCommand);
        this.duplicateCommand = new DuplicateCommand((BHxView)this);
        this.registerEvent((Event)this.duplicateCommand);
        this.delete = new PersonDelete((BHxView)this);
        this.registerEvent((Event)this.delete);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.add, this.hyperlinkCommand, this.summary, this.showHistoryCommand, this.showReadersCommand, this.showExpirationsCommand, this.delete, this.filterCommand, this.columnsCommand, this.refresh, this.batchCommand, this.matchCommand, this.duplicateCommand, this.reportCommand, this.exportCommand};
    }

    public static class ShowExpirationsCommand
    extends FilteredRedirectCommand.RefFilter {
        public ShowExpirationsCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showExpirations";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return service.getPersonAccessRightReport();
        }

        @Override
        public Type getRefType(HxOp op) {
            return BPerson.TYPE;
        }
    }

    public static class ShowReadersCommand
    extends FilteredRedirectCommand.RefFilter {
        public ShowReadersCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showReaders";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return service.getPersonReaderReport();
        }

        @Override
        public Type getRefType(HxOp op) {
            return BPerson.TYPE;
        }
    }

    public static class ShowPersonHistoryCommand
    extends FilteredRedirectCommand.RefStringFilter {
        public ShowPersonHistoryCommand(BHxView view) {
            super(view);
        }

        @Override
        public Type getFilterType(HxOp op) {
            return BPersonStringFilter.TYPE;
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            BSecurityHistoryConsolidator accessHistory = service.getAccessHistory();
            return accessHistory;
        }

        @Override
        public BComponent getOptionsManagerSubject(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            BSecurityHistoryConsolidator accessHistory = service.getAccessHistory();
            return accessHistory.getQuery();
        }

        public String getName(HxOp op) {
            return "showPersonHistory";
        }

        @Override
        public boolean alterFilterEntry(BFilterEntry entry, HxOp op) {
            if (entry.getName().endsWith("timestamp")) {
                SlotCursor props = entry.getProperties();
                props.next(BSecAbsTimeFilter.class);
                BSecAbsTimeFilter filter = (BSecAbsTimeFilter)props.get();
                filter.setTimeRangeType(BDynamicTimeRangeType.last7Days);
                entry.setActive(true);
                return true;
            }
            return super.alterFilterEntry(entry, op);
        }
    }

    public static class ShowHistoryCommand
    extends FilteredRedirectCommand.RefStringFilter {
        public ShowHistoryCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showHistory";
        }

        @Override
        public Type getFilterType(HxOp op) {
            return BPersonStringFilter.TYPE;
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            BSecurityHistoryConsolidator accessHistory = service.getAccessHistory();
            return accessHistory;
        }

        @Override
        public BComponent getOptionsManagerSubject(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            BSecurityHistoryConsolidator accessHistory = service.getAccessHistory();
            return accessHistory.getQuery();
        }
    }

    public class PersonBatchEditCommand
    extends OrionBatchEditCommand {
        public PersonBatchEditCommand(BHxView view) {
            super(view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HxOp op) throws Exception {
            BDynamicTable dt = (BDynamicTable)op.get();
            OrionSession session = null;
            Object[] subjects = null;
            if (!this.dlg.isSubmit(op)) {
                try {
                    session = dt.getOrionDatabase().createSession((Context)op);
                    subjects = this.getSubjects(op);
                    if (subjects != null) {
                        for (int i = 0; i < subjects.length; ++i) {
                            BPerson person = (BPerson)subjects[i];
                            BPersonLdapServerJoin personLdapServerJoin = person.getPersonLdapServerJoin(session);
                            if (personLdapServerJoin == null) continue;
                            throw new BajaRuntimeException(this.lexModule.getText("ldap.person.edit.Exception", (Context)op));
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            super.handle(op);
        }

        @Override
        public BOrionObject getBatchTemplate(HxOp op) {
            BPerson person = (BPerson)super.getBatchTemplate(op);
            person.add("addAccessRights", (BValue)BRefList.make((BOrionTypeId)BAccessRight.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            person.add("removeAccessRights", (BValue)BRefList.make((BOrionTypeId)BAccessRight.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            return person;
        }

        @Override
        public void saveRow(BComponent saved, BOrionObject subject, BOrionObject template, OrionSession session, HxOp op) throws Exception {
            BPersonAccJoin join;
            BRef ref;
            int i;
            super.saveRow(saved, subject, template, session, op);
            BRef personRef = BRef.make((BIOrionObject)((BIOrionObject)saved));
            BRefList refList = (BRefList)template.get("addAccessRights");
            BSimple[] values = refList.getIds();
            if (values != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    join = new BPersonAccJoin();
                    join.setPerson(personRef);
                    join.setAccessRight(ref);
                    if (session.exists((BIOrionObject)join)) continue;
                    session.insert((BIOrionObject)join);
                }
            }
            if ((values = (refList = (BRefList)template.get("removeAccessRights")).getIds()) != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    join = new BPersonAccJoin();
                    join.setPerson(personRef);
                    join.setAccessRight(ref);
                    if (!session.exists((BIOrionObject)join)) continue;
                    session.delete((BIOrionObject)join);
                }
            }
            BHxPersonView.saveAdditionalPersonInfo((BPerson)saved, op);
        }

        @Override
        public String[] getProperties(BComponent o, HxOp op) {
            Array a = new Array(String.class);
            a.addAll((Object[])new String[]{"department", "personType", "tenant", "supervisor", "traceCard"});
            Property[] props = o.getDynamicPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                if (props[i].getType() != BString.TYPE && props[i].getType() != BRefList.TYPE) continue;
                a.add((Object)props[i].getName());
            }
            return (String[])a.trim();
        }
    }
}

