/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.gx.awt.AwtEnv;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;

public class PxUtil {
    public static BufferedImage read(BIFile file) {
        try {
            int ih;
            BWidget w = new PxDecoder(file).decodeDocument();
            PxUtil.syncImg(w);
            w.computePreferredSize();
            int iw = (int)w.getPreferredWidth();
            if (iw <= 0) {
                iw = 100;
            }
            if ((ih = (int)w.getPreferredHeight()) <= 0) {
                ih = 100;
            }
            w.setBounds(0.0, 0.0, (double)iw, (double)ih);
            w.layout();
            BufferedImage img = new BufferedImage(iw, ih, 2);
            Graphics2D g2d = img.createGraphics();
            g2d.setClip(0, 0, iw, ih);
            Graphics gx = ((AwtEnv)AwtEnv.get()).makeGraphics(g2d);
            w.paint(gx);
            gx.dispose();
            return img;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void syncImg(BWidget w) throws Exception {
        Property[] props = w.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getType().is(BImage.TYPE)) continue;
            ((BImage)w.get(props[i])).sync();
        }
        BWidget[] kids = w.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            PxUtil.syncImg(kids[i]);
        }
    }
}

