/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.raster.viewer.BPictureGrid;
import com.tridium.raster.viewer.Thumb;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

@NiagaraType
public class BPicture
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BPicture.class);
    static final int size = 100;
    static final BFont font = Theme.widget().getTextFont();
    static final BBrush normalFg = BColor.black.toBrush();
    static final BBrush cutFg = BColor.make((int)100, (int)100, (int)100).toBrush();
    static final BBrush selectFg = Theme.widget().getSelectionForeground();
    static final BBrush selectBg = Theme.widget().getSelectionBackground();
    static final BBrush selAlpha = BColor.make((String)"#33666699").toBrush();
    static final double namey = 100.0 - font.getDescent();
    static final double imagew = 96.0;
    static final double imageh = 100.0 - font.getHeight() - 6.0;
    BPictureGrid grid;
    int index;
    BIFile file;
    String name;
    Thumb thumb;
    boolean paintSinceLoaded;
    boolean selected;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPicture() {
        throw new UnsupportedOperationException();
    }

    public BPicture(BPictureGrid grid, BIFile file) {
        this.grid = grid;
        this.file = file;
        this.name = file.getFileName();
        this.thumb = Thumb.make(file);
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 100.0);
    }

    public void animate() {
        if (!this.thumb.isLoaded()) {
            this.repaint();
        } else if (!this.paintSinceLoaded) {
            this.repaint();
        }
    }

    void refresh() {
        this.thumb.unload();
        this.paintSinceLoaded = false;
    }

    public void paint(Graphics g) {
        double namew;
        double namex;
        BBrush box;
        BBrush bg;
        BBrush fg;
        boolean cut = this.file.isPendingMove();
        if (this.selected) {
            fg = selectFg;
            bg = selectBg;
            box = selectBg;
        } else {
            fg = cut ? cutFg : normalFg;
            bg = null;
            box = Theme.widget().getControlAuxiliary();
        }
        if (!this.thumb.isLoaded()) {
            this.thumb.dibs();
        } else {
            this.paintSinceLoaded = true;
            BImage image = this.thumb.getImage();
            double imagex = 2.0 + (96.0 - image.getWidth()) / 2.0;
            double imagey = 2.0 + (imageh - image.getHeight()) / 2.0;
            if (cut) {
                g.drawImage(image.getDisabledImage(), imagex, imagey);
            } else {
                g.drawImage(image, imagex, imagey);
            }
        }
        if (this.selected) {
            g.setBrush(selAlpha);
            g.fillRect(2.0, 2.0, 96.0, imageh + 1.0);
        }
        g.setBrush(box);
        g.strokeRect(1.0, 1.0, 97.0, imageh + 2.0);
        if (this.selected) {
            g.setBrush(selectBg);
            g.strokeRect(0.0, 0.0, 99.0, imageh + 4.0);
        }
        if ((namex = (100.0 - (namew = font.width(this.name))) / 2.0) < 0.0) {
            namex = 0.0;
        }
        if (bg != null) {
            g.setBrush(bg);
            g.fillRect(namex - 2.0, imageh + 4.0, namew + 4.0, 100.0 - imageh - 3.0);
        }
        g.setBrush(fg);
        g.setFont(font);
        g.drawString(this.name, namex, namey);
    }

    public void mouseEntered(BMouseEvent event) {
        if (this.grid != null) {
            this.grid.mouseEntered(this, event);
        }
    }

    public void mouseExited(BMouseEvent event) {
        if (this.grid != null) {
            this.grid.mouseExited(this, event);
        }
    }

    public void mousePressed(BMouseEvent event) {
        if (this.grid != null) {
            this.grid.mousePressed(this, event);
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.grid != null) {
            this.grid.mouseReleased(this, event);
        }
    }

    public String toStatusString() {
        String s = this.name;
        if (this.thumb.isLoaded()) {
            s = s + " [" + (int)this.thumb.getOrigWidth() + "," + (int)this.thumb.getOrigHeight() + "]";
        }
        return s;
    }
}

