/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.schedule;

import com.tridium.bacnet.ui.schedule.BBacnetScheduleExportManager;
import com.tridium.bacnet.ui.schedule.BBacnetScheduleImportManager;
import com.tridium.bacnet.ui.schedule.ScheduleLearn;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrState;

public class ScheduleState
extends MgrState {
    BOrd lastSaveTwinOrd;
    Object[] lastLearn;
    private static ScheduleState state = new ScheduleState();
    private static final String KEY = "bacnet:BacnetScheduleManager";

    public static ScheduleState getState() {
        return state;
    }

    public static String toKey(BBacnetScheduleImportManager manager) {
        return KEY;
    }

    public static String toKey(BBacnetScheduleExportManager manager) {
        return KEY;
    }

    public void save(BAbstractManager manager) {
        super.save(manager);
        this.lastSaveTwinOrd = manager.getWbShell().getActiveOrd();
    }

    public void restore(BAbstractManager manager) {
        super.restore(manager);
        if (this.lastSaveTwinOrd == null) {
            return;
        }
        BOrd restoreTwinOrd = manager.getWbShell().getActiveOrd();
        OrdQuery[] restoreQuery = restoreTwinOrd.parse();
        OrdQuery[] saveQuery = this.lastSaveTwinOrd.parse();
        int len = Math.min(restoreQuery.length, saveQuery.length);
        for (int i = 0; i < len; ++i) {
            String r = restoreQuery[i].toString();
            String s = saveQuery[i].toString();
            if (r.startsWith("view") || s.startsWith("view") || restoreQuery[i].toString().equals(saveQuery[i].toString())) continue;
            return;
        }
        this.restoreForOrd(manager);
    }

    protected void saveForOrd(BAbstractManager mgr) {
        super.saveForOrd(mgr);
        ScheduleLearn lrn = (ScheduleLearn)mgr.getLearn();
        this.lastLearn = lrn.lastLearn;
    }

    protected void restoreForOrd(BAbstractManager mgr) {
        super.restoreForOrd(mgr);
        ScheduleLearn lrn = (ScheduleLearn)mgr.getLearn();
        if (this.lastLearn != null) {
            lrn.updateRoots(this.lastLearn);
        }
    }
}

