/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.history;

import com.tridium.bacnet.ui.history.BMultiRecord;
import javax.baja.collection.Column;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public class MultiColumn
implements Column {
    private BComplex parent;
    private Property prop;
    private BFacets facets;
    private String displayName;
    int histNdx = -1;

    public MultiColumn(Property prop, String displayName, BFacets facets, int histNdx) {
        this.prop = prop;
        this.facets = facets;
        this.histNdx = histNdx;
        this.displayName = displayName;
    }

    public String getName() {
        return this.getDisplayName(null);
    }

    public final String getDisplayName(Context cx) {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName(cx);
    }

    public Property getProperty() {
        return this.prop;
    }

    public String getDefaultDisplayName(Context cx) {
        if (this.parent == null) {
            return this.prop.getDefaultDisplayName(cx);
        }
        return this.parent.getDisplayName((Slot)this.prop, cx);
    }

    public Type getType() {
        return this.prop.getType();
    }

    public int getFlags() {
        return this.prop.getDefaultFlags();
    }

    public BFacets getFacets() {
        if (this.facets != null) {
            return this.facets;
        }
        return this.prop.getFacets();
    }

    public BObject get(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return BString.DEFAULT;
        }
        return c.get(this.prop);
    }

    public String getString(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return "";
        }
        return c.getString(this.prop);
    }

    public double getDouble(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return Double.NaN;
        }
        return c.getDouble(this.prop);
    }

    public float getFloat(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return Float.NaN;
        }
        return c.getFloat(this.prop);
    }

    public boolean getBoolean(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return false;
        }
        return c.getBoolean(this.prop);
    }

    public int getInt(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return 0;
        }
        return c.getInt(this.prop);
    }

    public long getLong(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return 0L;
        }
        return c.getLong(this.prop);
    }

    public int getFlags(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return 0;
        }
        return c.getFlags((Slot)this.prop);
    }

    public BFacets getFacets(BObject target) {
        BComplex c = this.getTarget(target);
        if (c == null) {
            return null;
        }
        return c.getSlotFacets((Slot)this.prop);
    }

    private BComplex getTarget(BObject target) {
        return ((BMultiRecord)target).getRecord(this.histNdx);
    }
}

