/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.ui.util.LayoutUtil;
import java.util.ArrayList;
import java.util.List;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetBitString"})})
public class BBacnetBitStringFE
extends BWbFieldEditor
implements BWbFieldEditor.IDialogContentProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBitStringFE.class);
    BTextField summary;
    BGridPane editPane = new BGridPane(3);
    BExpandablePane expander;
    List<BCheckBox> cboxes;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetBitStringFE() {
        BToolBar toolbar = new BToolBar();
        BButton addButton = new BButton((Command)new AddBitCommand(this));
        addButton.setButtonStyle(BButtonStyle.toolBar);
        addButton.setPadding(BInsets.NULL);
        toolbar.add("add", (BValue)addButton, null);
        BButton removeButton = new BButton((Command)new RemoveBitCommand(this));
        removeButton.setButtonStyle(BButtonStyle.toolBar);
        removeButton.setPadding(BInsets.NULL);
        toolbar.add("remove", (BValue)removeButton, null);
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        toolbarPane.add(null, (BValue)toolbar, null);
        BGridPane expansion = new BGridPane(2);
        expansion.add(null, (BValue)this.editPane);
        expansion.add(null, (BValue)toolbarPane);
        this.summary = new BTextField("", 25, false);
        this.expander = new BExpandablePane((BWidget)this.summary, (BWidget)expansion);
        this.setContent((BWidget)this.expander);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BBacnetBitString bs = (BBacnetBitString)value;
        String[] tags = BacnetBitStringUtil.getTags((Context)cx);
        int bslen = bs.length();
        int tagslen = tags.length;
        if (this.cboxes == null || this.cboxes.size() != bslen) {
            this.cboxes = new ArrayList<BCheckBox>(bslen);
            this.editPane.removeAll();
            for (int i = 0; i < bslen; ++i) {
                String tag = i < tagslen ? tags[i] : "bit" + i;
                this.addBitCheckBox(tag, bs.getBit(i));
            }
        } else {
            for (int i = 0; i < bslen; ++i) {
                this.cboxes.get(i).setSelected(bs.getBit(i));
            }
        }
        this.summary.setText(bs.toString());
        this.summary.setVisibleColumns(bs.toString().length());
    }

    private void addBitCheckBox(String tag, boolean value) {
        BCheckBox checkbox = new BCheckBox(tag, value);
        this.cboxes.add(checkbox);
        checkbox.setEnabled(!this.isReadonly());
        this.editPane.add(tag, (BValue)checkbox, null);
        this.linkTo((BComponent)checkbox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.setModified();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        boolean[] bits = new boolean[this.cboxes.size()];
        for (int i = 0; i < this.cboxes.size(); ++i) {
            bits[i] = this.cboxes.get(i).isSelected();
        }
        BBacnetBitString bs = BBacnetBitString.make((boolean[])bits);
        this.summary.setText(bs.getActiveTags(cx));
        return bs;
    }

    public BWidget getDialogContent() {
        this.expander.setExpanded(true);
        return LayoutUtil.getScrollablePaneForDialogEditor((BWidget)new BBorderPane((BWidget)this));
    }

    private void removeBit() {
        if (this.cboxes.isEmpty()) {
            return;
        }
        int bslen = this.cboxes.size() - 1;
        this.cboxes.remove(bslen);
        BWidget[] children = (BWidget[])this.editPane.getChildren(BCheckBox.class);
        this.editPane.remove(children[children.length - 1].getPropertyInParent());
        BLink[] links = this.getLinks((Slot)BWbPlugin.setModified);
        BLink link = links[links.length - 1];
        link.deactivate();
        this.remove(link.getPropertyInParent());
        this.setModified();
    }

    private class RemoveBitCommand
    extends Command {
        public RemoveBitCommand(BBacnetBitStringFE fieldEditor) {
            super((BWidget)fieldEditor, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            BBacnetBitStringFE.this.removeBit();
            return null;
        }
    }

    private class AddBitCommand
    extends Command {
        public AddBitCommand(BBacnetBitStringFE fieldEditor) {
            super((BWidget)fieldEditor, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            String[] tags;
            int bslen = BBacnetBitStringFE.this.cboxes.size();
            String tag = bslen < (tags = BacnetBitStringUtil.getTags((Context)BBacnetBitStringFE.this.getCurrentContext())).length ? tags[bslen] : "bit" + bslen;
            BBacnetBitStringFE.this.addBitCheckBox(tag, false);
            return null;
        }
    }
}

