/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.export;

import com.tridium.bacnet.ui.export.BBacnetNiagaraLogExportManager;
import java.util.ArrayList;
import javax.baja.bacnet.export.BBacnetNiagaraHistoryDescriptor;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;

class LogExportController
extends FolderController {
    static Lexicon lex = UiLexicon.makeUiLexicon(LogExportController.class);
    private static final Log logger = Log.getLog((String)"bacnet.server");
    public final MgrController.MgrCommand updateStationName;

    public LogExportController(BBacnetNiagaraLogExportManager manager) {
        super((BFolderManager)manager);
        this.updateStationName = new UpdateStationName((BWidget)manager);
        this.updateStationName.setFlags(3);
        this.cancel.setFlags(0);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return LogExportController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.updateStationName});
    }

    public void updateCommands() {
        super.updateCommands();
        BMgrTable table = this.getTable();
        boolean updateEnabled = false;
        if (table != null) {
            BComponent[] logs = table.getSelectedComponents();
            for (int i = 0; i < logs.length; ++i) {
                if (!logs[i].getType().is(BBacnetNiagaraHistoryDescriptor.TYPE)) continue;
                updateEnabled = true;
                break;
            }
        }
        this.updateStationName.setEnabled(updateEnabled);
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        super.doDiscover(cx);
        BBacnetNiagaraLogExportManager.Learn learn = (BBacnetNiagaraLogExportManager.Learn)this.getManager().getLearn();
        BHistorySpace space = learn.getHistorySpace();
        if (space == null) {
            return null;
        }
        ArrayList<BIHistory> discovered = new ArrayList<BIHistory>(50);
        BHistoryDevice[] devs = space.listDevices();
        for (int i = 0; i < devs.length; ++i) {
            BIHistory[] histories = space.listHistories(devs[i]);
            for (int j = 0; j < histories.length; ++j) {
                if (histories[j].getId().getHistoryName().equals("AlarmHistory") || histories[j].getId().getHistoryName().equals("AuditHistory")) continue;
                discovered.add(histories[j]);
            }
        }
        learn.updateTable(discovered.toArray(new BIHistory[0]));
        return null;
    }

    public CommandArtifact doUpdateStationName() throws Exception {
        Array ahist = new Array(BBacnetNiagaraHistoryDescriptor.class);
        BComponent[] logs = this.getTable().getSelectedComponents();
        for (int i = 0; i < logs.length; ++i) {
            if (!logs[i].getType().is(BBacnetNiagaraHistoryDescriptor.TYPE)) continue;
            ahist.add((Object)((BBacnetNiagaraHistoryDescriptor)logs[i]));
        }
        BBacnetNiagaraHistoryDescriptor h0 = (BBacnetNiagaraHistoryDescriptor)ahist.first();
        if (h0 == null) {
            return null;
        }
        BHistoryId id0 = h0.getId();
        BWbFieldEditor newNameEd = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
        newNameEd.loadValue((BObject)BString.make((String)id0.getDeviceName()));
        BEdgePane pane = new BEdgePane();
        BGridPane gpane = new BGridPane(2);
        gpane.add(null, (BValue)new BLabel(lex.getText("logExportManager.updateStationName.label")));
        gpane.add(null, (BValue)newNameEd);
        pane.setTop((BWidget)gpane);
        pane.setBottom((BWidget)new BLabel(lex.getText("logExportManager.updateStationName.message")));
        int ret = BDialog.open((BWidget)this.getManager(), (String)lex.getText("logExportManager.updateStationName.title"), (Object)pane, (int)3);
        if (ret == 2) {
            return null;
        }
        String newName = ((BString)newNameEd.saveValue()).getString();
        logger.message("Update history device names to " + newName);
        for (BBacnetNiagaraHistoryDescriptor h : ahist) {
            String oldObjName = h.getObjectName();
            String oldDefaultName = SlotPath.unescape((String)h.getId().toString());
            h.setId(BHistoryId.make((String)newName, (String)h.getId().getHistoryName()));
            if (oldObjName.equals(oldDefaultName)) {
                h.setObjectName(SlotPath.unescape((String)h.getId().toString()));
            }
            logger.message("  -- Updated history device name for " + h + ": new id=" + h.getId());
        }
        return null;
    }

    class UpdateStationName
    extends MgrController.MgrCommand {
        UpdateStationName(BWidget owner) {
            super(owner, lex, "updateStationName");
        }

        public CommandArtifact doInvoke() throws Exception {
            return LogExportController.this.doUpdateStationName();
        }
    }
}

